/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.RefAdvertiser;

public class RefAdvertiser$PacketLineOutRefAdvertiser
extends RefAdvertiser {
    private final CharsetEncoder utf8 = StandardCharsets.UTF_8.newEncoder();
    private final PacketLineOut pckOut;
    private byte[] binArr = new byte[256];
    private ByteBuffer binBuf = ByteBuffer.wrap(this.binArr);
    private char[] chArr = new char[256];
    private CharBuffer chBuf = CharBuffer.wrap(this.chArr);

    public RefAdvertiser$PacketLineOutRefAdvertiser(PacketLineOut packetLineOut) {
        this.pckOut = packetLineOut;
    }

    @Override
    public void advertiseId(AnyObjectId anyObjectId, String string) {
        anyObjectId.copyTo(this.binArr, 0);
        this.binArr[40] = 32;
        this.binBuf.position(41);
        this.append(string);
        if (this.first) {
            this.first = false;
            if (!this.capablities.isEmpty()) {
                this.append(0);
                for (String string2 : this.capablities) {
                    this.append(32);
                    this.append(string2);
                }
            }
        }
        this.append(10);
        this.pckOut.writePacket(this.binArr, 0, this.binBuf.position());
    }

    private void append(String string) {
        int n2 = string.length();
        if (n2 > this.chArr.length) {
            this.chArr = new char[n2 + 256];
            this.chBuf = CharBuffer.wrap(this.chArr);
        }
        string.getChars(0, n2, this.chArr, 0);
        this.chBuf.position(0).limit(n2);
        this.utf8.reset();
        while (true) {
            CoderResult coderResult;
            if ((coderResult = this.utf8.encode(this.chBuf, this.binBuf, true)).isOverflow()) {
                this.grow();
                continue;
            }
            if (coderResult.isUnderflow()) break;
            coderResult.throwException();
        }
    }

    private void append(int n2) {
        if (!this.binBuf.hasRemaining()) {
            this.grow();
        }
        this.binBuf.put((byte)n2);
    }

    private void grow() {
        int n2 = this.binBuf.position();
        byte[] byArray = new byte[this.binArr.length << 1];
        System.arraycopy(this.binArr, 0, byArray, 0, n2);
        this.binArr = byArray;
        this.binBuf = ByteBuffer.wrap(this.binArr);
        this.binBuf.position(n2);
    }

    @Override
    protected void writeOne(CharSequence charSequence) {
        this.pckOut.writeString(charSequence.toString());
    }

    @Override
    protected void end() {
        this.pckOut.end();
    }
}

