/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.UnpackException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.internal.submodule.SubmoduleValidator;
import org.eclipse.jgit.internal.submodule.SubmoduleValidator$SubmoduleValidationException;
import org.eclipse.jgit.internal.transport.connectivity.FullConnectivityChecker;
import org.eclipse.jgit.internal.transport.parser.FirstCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.GitmoduleEntry;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.ConnectivityChecker;
import org.eclipse.jgit.transport.ConnectivityChecker$ConnectivityCheckInfo;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineIn$InputOverLimitIOException;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.PushCertificate;
import org.eclipse.jgit.transport.PushCertificateParser;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceiveCommand$Result;
import org.eclipse.jgit.transport.ReceiveCommand$Type;
import org.eclipse.jgit.transport.ReceiveCommandErrorHandler;
import org.eclipse.jgit.transport.ReceivePack$1;
import org.eclipse.jgit.transport.ReceivePack$2;
import org.eclipse.jgit.transport.ReceivePack$3;
import org.eclipse.jgit.transport.ReceivePack$DefaultUnpackErrorHandler;
import org.eclipse.jgit.transport.ReceivePack$MessageOutputWrapper;
import org.eclipse.jgit.transport.ReceivePack$PostReceiveExecutor;
import org.eclipse.jgit.transport.ReceivePack$ReceiveConfig;
import org.eclipse.jgit.transport.ReceivePack$Reporter;
import org.eclipse.jgit.transport.ReceivedPackStatistics;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.RefAdvertiser$PacketLineOutRefAdvertiser;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.transport.RequestNotYetReadException;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.SideBandOutputStream;
import org.eclipse.jgit.transport.SideBandProgressMonitor;
import org.eclipse.jgit.transport.SignedPushConfig;
import org.eclipse.jgit.transport.TransferConfig;
import org.eclipse.jgit.transport.UnpackErrorHandler;
import org.eclipse.jgit.transport.UserAgent;
import org.eclipse.jgit.util.io.InterruptTimer;
import org.eclipse.jgit.util.io.TimeoutInputStream;
import org.eclipse.jgit.util.io.TimeoutOutputStream;

public class ReceivePack {
    private final Repository db;
    private final RevWalk walk;
    private boolean biDirectionalPipe = true;
    private boolean expectDataAfterPackFooter;
    private ObjectChecker objectChecker;
    private boolean allowCreates;
    private boolean allowAnyDeletes;
    private boolean allowBranchDeletes;
    private boolean allowNonFastForwards;
    private boolean allowPushOptions;
    private boolean atomic;
    private boolean allowOfsDelta;
    private boolean allowQuiet = true;
    private PersonIdent refLogIdent;
    private AdvertiseRefsHook advertiseRefsHook;
    private RefFilter refFilter;
    private int timeout;
    private InterruptTimer timer;
    private TimeoutInputStream timeoutIn;
    private OutputStream origOut;
    private InputStream rawIn;
    private OutputStream rawOut;
    private OutputStream msgOut;
    private SideBandOutputStream errOut;
    private PacketLineIn pckIn;
    private PacketLineOut pckOut;
    private final ReceivePack$MessageOutputWrapper msgOutWrapper = new ReceivePack$MessageOutputWrapper(this);
    private PackParser parser;
    private Map refs;
    private Set advertisedHaves;
    private Set enabledCapabilities;
    String userAgent;
    private Set clientShallowCommits;
    private List commands;
    private long maxCommandBytes;
    private long maxDiscardBytes;
    private StringBuilder advertiseError;
    private boolean sideBand;
    private boolean quiet;
    private PackLock packLock;
    private boolean checkReferencedAreReachable;
    private long maxObjectSizeLimit;
    private long maxPackSizeLimit = -1L;
    private Long packSize;
    private PushCertificateParser pushCertificateParser;
    private SignedPushConfig signedPushConfig;
    private PushCertificate pushCert;
    private ReceivedPackStatistics stats;
    protected ConnectivityChecker connectivityChecker = new FullConnectivityChecker();
    private PreReceiveHook preReceive;
    private ReceiveCommandErrorHandler receiveCommandErrorHandler = new ReceivePack$1(this);
    private UnpackErrorHandler unpackErrorHandler = new ReceivePack$DefaultUnpackErrorHandler(this);
    private PostReceiveHook postReceive;
    private boolean reportStatus;
    private boolean usePushOptions;
    private List pushOptions;

    public ReceivePack(Repository repository) {
        this.db = repository;
        this.walk = new RevWalk(this.db);
        this.walk.setRetainBody(false);
        TransferConfig transferConfig = (TransferConfig)this.db.getConfig().get(TransferConfig.KEY);
        this.objectChecker = transferConfig.newReceiveObjectChecker();
        ReceivePack$ReceiveConfig receivePack$ReceiveConfig = (ReceivePack$ReceiveConfig)this.db.getConfig().get(ReceivePack$ReceiveConfig::new);
        this.allowCreates = receivePack$ReceiveConfig.allowCreates;
        this.allowAnyDeletes = true;
        this.allowBranchDeletes = receivePack$ReceiveConfig.allowDeletes;
        this.allowNonFastForwards = receivePack$ReceiveConfig.allowNonFastForwards;
        this.allowOfsDelta = receivePack$ReceiveConfig.allowOfsDelta;
        this.allowPushOptions = receivePack$ReceiveConfig.allowPushOptions;
        this.maxCommandBytes = receivePack$ReceiveConfig.maxCommandBytes;
        this.maxDiscardBytes = receivePack$ReceiveConfig.maxDiscardBytes;
        this.advertiseRefsHook = AdvertiseRefsHook.DEFAULT;
        this.refFilter = RefFilter.DEFAULT;
        this.advertisedHaves = new HashSet();
        this.clientShallowCommits = new HashSet();
        this.signedPushConfig = receivePack$ReceiveConfig.signedPush;
        this.preReceive = PreReceiveHook.NULL;
        this.postReceive = PostReceiveHook.NULL;
    }

    public Repository getRepository() {
        return this.db;
    }

    public RevWalk getRevWalk() {
        return this.walk;
    }

    public Map getAdvertisedRefs() {
        return this.refs;
    }

    public void setAdvertisedRefs(Map map, Set set) {
        this.refs = map != null ? map : this.getAllRefs();
        this.refs = this.refFilter.filter(this.refs);
        this.advertisedHaves.clear();
        Ref ref = (Ref)this.refs.get("HEAD");
        if (ref != null && ref.isSymbolic()) {
            this.refs.remove("HEAD");
        }
        for (Ref ref2 : this.refs.values()) {
            if (ref2.getObjectId() == null) continue;
            this.advertisedHaves.add(ref2.getObjectId());
        }
        if (set != null) {
            this.advertisedHaves.addAll(set);
        } else {
            this.advertisedHaves.addAll(this.db.getAdditionalHaves());
        }
    }

    public final Set getAdvertisedObjects() {
        return this.advertisedHaves;
    }

    public boolean isCheckReferencedObjectsAreReachable() {
        return this.checkReferencedAreReachable;
    }

    public void setCheckReferencedObjectsAreReachable(boolean bl2) {
        this.checkReferencedAreReachable = bl2;
    }

    public boolean isBiDirectionalPipe() {
        return this.biDirectionalPipe;
    }

    public void setBiDirectionalPipe(boolean bl2) {
        this.biDirectionalPipe = bl2;
    }

    public boolean isExpectDataAfterPackFooter() {
        return this.expectDataAfterPackFooter;
    }

    public void setExpectDataAfterPackFooter(boolean bl2) {
        this.expectDataAfterPackFooter = bl2;
    }

    public boolean isCheckReceivedObjects() {
        return this.objectChecker != null;
    }

    public void setCheckReceivedObjects(boolean bl2) {
        if (bl2 && this.objectChecker == null) {
            this.setObjectChecker(new ObjectChecker());
        } else if (!bl2 && this.objectChecker != null) {
            this.setObjectChecker(null);
        }
    }

    public void setObjectChecker(ObjectChecker objectChecker) {
        this.objectChecker = objectChecker;
    }

    public boolean isAllowCreates() {
        return this.allowCreates;
    }

    public void setAllowCreates(boolean bl2) {
        this.allowCreates = bl2;
    }

    public boolean isAllowDeletes() {
        return this.allowAnyDeletes;
    }

    public void setAllowDeletes(boolean bl2) {
        this.allowAnyDeletes = bl2;
    }

    public boolean isAllowBranchDeletes() {
        return this.allowBranchDeletes;
    }

    public void setAllowBranchDeletes(boolean bl2) {
        this.allowBranchDeletes = bl2;
    }

    public boolean isAllowNonFastForwards() {
        return this.allowNonFastForwards;
    }

    public void setAllowNonFastForwards(boolean bl2) {
        this.allowNonFastForwards = bl2;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public void setAtomic(boolean bl2) {
        this.atomic = bl2;
    }

    public PersonIdent getRefLogIdent() {
        return this.refLogIdent;
    }

    public void setRefLogIdent(PersonIdent personIdent) {
        this.refLogIdent = personIdent;
    }

    public AdvertiseRefsHook getAdvertiseRefsHook() {
        return this.advertiseRefsHook;
    }

    public RefFilter getRefFilter() {
        return this.refFilter;
    }

    public void setAdvertiseRefsHook(AdvertiseRefsHook advertiseRefsHook) {
        this.advertiseRefsHook = advertiseRefsHook != null ? advertiseRefsHook : AdvertiseRefsHook.DEFAULT;
    }

    public void setRefFilter(RefFilter refFilter) {
        this.refFilter = refFilter != null ? refFilter : RefFilter.DEFAULT;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n2) {
        this.timeout = n2;
    }

    public void setMaxCommandBytes(long l2) {
        this.maxCommandBytes = l2;
    }

    public void setMaxCommandDiscardBytes(long l2) {
        this.maxDiscardBytes = l2;
    }

    public void setMaxObjectSizeLimit(long l2) {
        this.maxObjectSizeLimit = l2;
    }

    public void setMaxPackSizeLimit(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().receivePackInvalidLimit, l2));
        }
        this.maxPackSizeLimit = l2;
    }

    public boolean isSideBand() {
        this.checkRequestWasRead();
        return this.enabledCapabilities.contains("side-band-64k");
    }

    public boolean isAllowQuiet() {
        return this.allowQuiet;
    }

    public void setAllowQuiet(boolean bl2) {
        this.allowQuiet = bl2;
    }

    public boolean isAllowPushOptions() {
        return this.allowPushOptions;
    }

    public void setAllowPushOptions(boolean bl2) {
        this.allowPushOptions = bl2;
    }

    public boolean isQuiet() {
        this.checkRequestWasRead();
        return this.quiet;
    }

    public void setSignedPushConfig(SignedPushConfig signedPushConfig) {
        this.signedPushConfig = signedPushConfig;
    }

    private PushCertificateParser getPushCertificateParser() {
        if (this.pushCertificateParser == null) {
            this.pushCertificateParser = new PushCertificateParser(this.db, this.signedPushConfig);
        }
        return this.pushCertificateParser;
    }

    public String getPeerUserAgent() {
        return UserAgent.getAgent(this.enabledCapabilities, this.userAgent);
    }

    public List getAllCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public void setReceiveCommandErrorHandler(ReceiveCommandErrorHandler receiveCommandErrorHandler) {
        this.receiveCommandErrorHandler = receiveCommandErrorHandler;
    }

    public void sendError(String string) {
        if (this.refs == null) {
            if (this.advertiseError == null) {
                this.advertiseError = new StringBuilder();
            }
            this.advertiseError.append(string).append('\n');
        } else {
            this.msgOutWrapper.write(Constants.encode("error: " + string + "\n"));
        }
    }

    private void fatalError(String string) {
        if (this.errOut != null) {
            try {
                this.errOut.write(Constants.encode(string));
                this.errOut.flush();
            }
            catch (IOException iOException) {}
        } else {
            this.sendError(string);
        }
    }

    public void sendMessage(String string) {
        this.msgOutWrapper.write(Constants.encode(string + "\n"));
    }

    public OutputStream getMessageOutputStream() {
        return this.msgOutWrapper;
    }

    public boolean hasReceivedPack() {
        return this.packSize != null;
    }

    public long getPackSize() {
        if (this.packSize != null) {
            return this.packSize;
        }
        throw new IllegalStateException(JGitText.get().packSizeNotSetYet);
    }

    private Set getClientShallowCommits() {
        return this.clientShallowCommits;
    }

    private boolean hasCommands() {
        return !this.commands.isEmpty();
    }

    private boolean hasError() {
        return this.advertiseError != null;
    }

    protected void init(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
        this.origOut = outputStream;
        this.rawIn = inputStream;
        this.rawOut = outputStream;
        this.msgOut = outputStream2;
        if (this.timeout > 0) {
            Thread thread = Thread.currentThread();
            this.timer = new InterruptTimer(thread.getName() + "-Timer");
            this.timeoutIn = new TimeoutInputStream(this.rawIn, this.timer);
            TimeoutOutputStream timeoutOutputStream = new TimeoutOutputStream(this.rawOut, this.timer);
            this.timeoutIn.setTimeout(this.timeout * 1000);
            timeoutOutputStream.setTimeout(this.timeout * 1000);
            this.rawIn = this.timeoutIn;
            this.rawOut = timeoutOutputStream;
        }
        this.pckIn = new PacketLineIn(this.rawIn);
        this.pckOut = new PacketLineOut(this.rawOut);
        this.pckOut.setFlushOnEnd(false);
        this.enabledCapabilities = new HashSet();
        this.commands = new ArrayList();
    }

    private Map getAdvertisedOrDefaultRefs() {
        if (this.refs == null) {
            this.setAdvertisedRefs(null, null);
        }
        return this.refs;
    }

    protected void receivePackAndCheckConnectivity() {
        this.receivePack();
        if (this.needCheckConnectivity()) {
            this.checkSubmodules();
            this.checkConnectivity();
        }
        this.parser = null;
    }

    private void unlockPack() {
        if (this.packLock != null) {
            this.packLock.unlock();
            this.packLock = null;
        }
    }

    public void sendAdvertisedRefs(RefAdvertiser refAdvertiser) {
        String string;
        if (this.advertiseError != null) {
            refAdvertiser.writeOne("ERR " + this.advertiseError);
            return;
        }
        try {
            this.advertiseRefsHook.advertiseRefs(this);
        }
        catch (ServiceMayNotContinueException serviceMayNotContinueException) {
            if (serviceMayNotContinueException.getMessage() != null) {
                refAdvertiser.writeOne("ERR " + serviceMayNotContinueException.getMessage());
                serviceMayNotContinueException.setOutput();
            }
            throw serviceMayNotContinueException;
        }
        refAdvertiser.init(this.db);
        refAdvertiser.advertiseCapability("side-band-64k");
        refAdvertiser.advertiseCapability("delete-refs");
        refAdvertiser.advertiseCapability("report-status");
        if (this.allowQuiet) {
            refAdvertiser.advertiseCapability("quiet");
        }
        if ((string = this.getPushCertificateParser().getAdvertiseNonce()) != null) {
            refAdvertiser.advertiseCapability(string);
        }
        if (this.db.getRefDatabase().performsAtomicTransactions()) {
            refAdvertiser.advertiseCapability("atomic");
        }
        if (this.allowOfsDelta) {
            refAdvertiser.advertiseCapability("ofs-delta");
        }
        if (this.allowPushOptions) {
            refAdvertiser.advertiseCapability("push-options");
        }
        refAdvertiser.advertiseCapability("agent", UserAgent.get());
        refAdvertiser.send(this.getAdvertisedOrDefaultRefs().values());
        for (ObjectId objectId : this.advertisedHaves) {
            refAdvertiser.advertiseHave(objectId);
        }
        if (refAdvertiser.isEmpty()) {
            refAdvertiser.advertiseId(ObjectId.zeroId(), "capabilities^{}");
        }
        refAdvertiser.end();
    }

    @Nullable
    public ReceivedPackStatistics getReceivedPackStatistics() {
        return this.stats;
    }

    private Map getAllRefs() {
        try {
            return this.db.getRefDatabase().getRefs().stream().collect(Collectors.toMap(Ref::getName, Function.identity()));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private void recvCommands() {
        PacketLineIn packetLineIn = this.maxCommandBytes > 0L ? new PacketLineIn(this.rawIn, this.maxCommandBytes) : this.pckIn;
        PushCertificateParser pushCertificateParser = this.getPushCertificateParser();
        boolean bl2 = true;
        try {
            while (true) {
                Object object;
                String string;
                try {
                    string = packetLineIn.readString();
                }
                catch (EOFException eOFException) {
                    if (this.commands.isEmpty()) {
                        return;
                    }
                    throw eOFException;
                }
                if (PacketLineIn.isEnd(string)) break;
                if (string.length() >= 48 && string.startsWith("shallow ")) {
                    this.parseShallow(string.substring(8, 48));
                    continue;
                }
                if (bl2) {
                    bl2 = false;
                    object = FirstCommand.fromLine(string);
                    this.enabledCapabilities = ((FirstCommand)object).getCapabilities();
                    string = ((FirstCommand)object).getLine();
                    this.enableCapabilities();
                    if (string.equals("push-cert")) {
                        pushCertificateParser.receiveHeader(packetLineIn, !this.isBiDirectionalPipe());
                        continue;
                    }
                }
                if (string.equals("-----BEGIN PGP SIGNATURE-----")) {
                    pushCertificateParser.receiveSignature(packetLineIn);
                    continue;
                }
                object = ReceivePack.parseCommand(string);
                if (((ReceiveCommand)object).getRefName().equals("HEAD")) {
                    ((ReceiveCommand)object).setResult(ReceiveCommand$Result.REJECTED_CURRENT_BRANCH);
                } else {
                    ((ReceiveCommand)object).setRef((Ref)this.refs.get(((ReceiveCommand)object).getRefName()));
                }
                this.commands.add(object);
                if (!pushCertificateParser.enabled()) continue;
                pushCertificateParser.addCommand((ReceiveCommand)object);
            }
            this.pushCert = pushCertificateParser.build();
            if (this.hasCommands()) {
                this.readPostCommands(packetLineIn);
            }
        }
        catch (Throwable throwable) {
            this.discardCommands();
            throw throwable;
        }
    }

    private void discardCommands() {
        if (this.sideBand) {
            long l2 = this.maxDiscardBytes;
            if (l2 < 0L) {
                l2 = Math.max(3L * this.maxCommandBytes, 0x300000L);
            }
            try {
                new PacketLineIn(this.rawIn, l2).discardUntilEnd();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void parseShallow(String string) {
        ObjectId objectId;
        try {
            objectId = ObjectId.fromString(string);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            throw new PackProtocolException(invalidObjectIdException.getMessage(), invalidObjectIdException);
        }
        this.clientShallowCommits.add(objectId);
    }

    void readPostCommands(PacketLineIn packetLineIn) {
        if (this.usePushOptions) {
            String string;
            this.pushOptions = new ArrayList(4);
            while (!PacketLineIn.isEnd(string = packetLineIn.readString())) {
                this.pushOptions.add(string);
            }
        }
    }

    private void enableCapabilities() {
        this.reportStatus = this.isCapabilityEnabled("report-status");
        this.usePushOptions = this.isCapabilityEnabled("push-options");
        this.sideBand = this.isCapabilityEnabled("side-band-64k");
        boolean bl2 = this.quiet = this.allowQuiet && this.isCapabilityEnabled("quiet");
        if (this.sideBand) {
            OutputStream outputStream = this.rawOut;
            this.rawOut = new SideBandOutputStream(1, 65520, outputStream);
            this.msgOut = new SideBandOutputStream(2, 65520, outputStream);
            this.errOut = new SideBandOutputStream(3, 65520, outputStream);
            this.pckOut = new PacketLineOut(this.rawOut);
            this.pckOut.setFlushOnEnd(false);
        }
    }

    private boolean isCapabilityEnabled(String string) {
        return this.enabledCapabilities.contains(string);
    }

    private void checkRequestWasRead() {
        if (this.enabledCapabilities == null) {
            throw new RequestNotYetReadException();
        }
    }

    private boolean needPack() {
        for (ReceiveCommand receiveCommand : this.commands) {
            if (receiveCommand.getType() == ReceiveCommand$Type.DELETE) continue;
            return true;
        }
        return false;
    }

    private void receivePack() {
        if (this.timeoutIn != null) {
            this.timeoutIn.setTimeout(10 * this.timeout * 1000);
        }
        NullProgressMonitor nullProgressMonitor = NullProgressMonitor.INSTANCE;
        ProgressMonitor progressMonitor = NullProgressMonitor.INSTANCE;
        if (this.sideBand && !this.quiet) {
            progressMonitor = new SideBandProgressMonitor(this.msgOut);
        }
        try (ObjectInserter objectInserter = this.db.newObjectInserter();){
            String string = "jgit receive-pack";
            if (this.getRefLogIdent() != null) {
                string = string + " from " + this.getRefLogIdent().toExternalString();
            }
            this.parser = objectInserter.newPackParser(this.packInputStream());
            this.parser.setAllowThin(true);
            this.parser.setNeedNewObjectIds(this.checkReferencedAreReachable);
            this.parser.setNeedBaseObjectIds(this.checkReferencedAreReachable);
            this.parser.setCheckEofAfterPackFooter(!this.biDirectionalPipe && !this.isExpectDataAfterPackFooter());
            this.parser.setExpectDataAfterPackFooter(this.isExpectDataAfterPackFooter());
            this.parser.setObjectChecker(this.objectChecker);
            this.parser.setLockMessage(string);
            this.parser.setMaxObjectSizeLimit(this.maxObjectSizeLimit);
            this.packLock = this.parser.parse(nullProgressMonitor, progressMonitor);
            this.packSize = this.parser.getPackSize();
            this.stats = this.parser.getReceivedPackStatistics();
            objectInserter.flush();
        }
        if (this.timeoutIn != null) {
            this.timeoutIn.setTimeout(this.timeout * 1000);
        }
    }

    private InputStream packInputStream() {
        InputStream inputStream = this.rawIn;
        if (this.maxPackSizeLimit >= 0L) {
            inputStream = new ReceivePack$2(this, inputStream, this.maxPackSizeLimit);
        }
        return inputStream;
    }

    private boolean needCheckConnectivity() {
        return this.isCheckReceivedObjects() || this.isCheckReferencedObjectsAreReachable() || !this.getClientShallowCommits().isEmpty();
    }

    private void checkSubmodules() {
        ObjectDatabase objectDatabase = this.db.getObjectDatabase();
        if (this.objectChecker == null) {
            return;
        }
        for (GitmoduleEntry gitmoduleEntry : this.objectChecker.getGitsubmodules()) {
            AnyObjectId anyObjectId = gitmoduleEntry.getBlobId();
            ObjectLoader objectLoader = objectDatabase.open(anyObjectId, 3);
            SubmoduleValidator.assertValidGitModulesFile(new String(objectLoader.getBytes(), StandardCharsets.UTF_8));
        }
    }

    private void checkConnectivity() {
        ProgressMonitor progressMonitor = NullProgressMonitor.INSTANCE;
        if (this.sideBand && !this.quiet) {
            SideBandProgressMonitor sideBandProgressMonitor = new SideBandProgressMonitor(this.msgOut);
            sideBandProgressMonitor.setDelayStart(750L, TimeUnit.MILLISECONDS);
            progressMonitor = sideBandProgressMonitor;
        }
        this.connectivityChecker.checkConnectivity(this.createConnectivityCheckInfo(), this.advertisedHaves, progressMonitor);
    }

    private ConnectivityChecker$ConnectivityCheckInfo createConnectivityCheckInfo() {
        ConnectivityChecker$ConnectivityCheckInfo connectivityChecker$ConnectivityCheckInfo = new ConnectivityChecker$ConnectivityCheckInfo();
        connectivityChecker$ConnectivityCheckInfo.setCheckObjects(this.checkReferencedAreReachable);
        connectivityChecker$ConnectivityCheckInfo.setCommands(this.getAllCommands());
        connectivityChecker$ConnectivityCheckInfo.setRepository(this.db);
        connectivityChecker$ConnectivityCheckInfo.setParser(this.parser);
        connectivityChecker$ConnectivityCheckInfo.setWalk(this.walk);
        return connectivityChecker$ConnectivityCheckInfo;
    }

    private void validateCommands() {
        for (ReceiveCommand receiveCommand : this.commands) {
            ObjectId objectId;
            Ref ref = receiveCommand.getRef();
            if (receiveCommand.getResult() != ReceiveCommand$Result.NOT_ATTEMPTED) continue;
            if (receiveCommand.getType() == ReceiveCommand$Type.DELETE) {
                if (!this.isAllowDeletes()) {
                    receiveCommand.setResult(ReceiveCommand$Result.REJECTED_NODELETE);
                    continue;
                }
                if (!this.isAllowBranchDeletes() && ref.getName().startsWith("refs/heads/")) {
                    receiveCommand.setResult(ReceiveCommand$Result.REJECTED_NODELETE);
                    continue;
                }
            }
            if (receiveCommand.getType() == ReceiveCommand$Type.CREATE) {
                if (!this.isAllowCreates()) {
                    receiveCommand.setResult(ReceiveCommand$Result.REJECTED_NOCREATE);
                    continue;
                }
                if (ref != null && !this.isAllowNonFastForwards()) {
                    receiveCommand.setResult(ReceiveCommand$Result.REJECTED_NONFASTFORWARD);
                    continue;
                }
                if (ref != null) {
                    receiveCommand.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON, JGitText.get().refAlreadyExists);
                    continue;
                }
            }
            if (receiveCommand.getType() == ReceiveCommand$Type.DELETE && ref != null) {
                objectId = ref.getObjectId();
                if (objectId == null) {
                    objectId = ObjectId.zeroId();
                }
                if (!ObjectId.zeroId().equals(receiveCommand.getOldId()) && !objectId.equals(receiveCommand.getOldId())) {
                    receiveCommand.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON, JGitText.get().invalidOldIdSent);
                    continue;
                }
            }
            if (receiveCommand.getType() == ReceiveCommand$Type.UPDATE) {
                block25: {
                    RevObject revObject;
                    RevObject revObject2;
                    if (ref == null) {
                        receiveCommand.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON, JGitText.get().noSuchRef);
                        continue;
                    }
                    objectId = ref.getObjectId();
                    if (objectId == null) {
                        receiveCommand.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON, JGitText.get().cannotUpdateUnbornBranch);
                        continue;
                    }
                    if (!objectId.equals(receiveCommand.getOldId())) {
                        receiveCommand.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON, JGitText.get().invalidOldIdSent);
                        continue;
                    }
                    try {
                        revObject2 = this.walk.parseAny(receiveCommand.getOldId());
                    }
                    catch (IOException iOException) {
                        this.receiveCommandErrorHandler.handleOldIdValidationException(receiveCommand, iOException);
                        continue;
                    }
                    try {
                        revObject = this.walk.parseAny(receiveCommand.getNewId());
                    }
                    catch (IOException iOException) {
                        this.receiveCommandErrorHandler.handleNewIdValidationException(receiveCommand, iOException);
                        continue;
                    }
                    if (revObject2 instanceof RevCommit && revObject instanceof RevCommit) {
                        try {
                            if (this.walk.isMergedInto((RevCommit)revObject2, (RevCommit)revObject)) {
                                receiveCommand.setTypeFastForwardUpdate();
                                break block25;
                            }
                            receiveCommand.setType(ReceiveCommand$Type.UPDATE_NONFASTFORWARD);
                        }
                        catch (IOException iOException) {
                            this.receiveCommandErrorHandler.handleFastForwardCheckException(receiveCommand, iOException);
                        }
                    } else {
                        receiveCommand.setType(ReceiveCommand$Type.UPDATE_NONFASTFORWARD);
                    }
                }
                if (receiveCommand.getType() == ReceiveCommand$Type.UPDATE_NONFASTFORWARD && !this.isAllowNonFastForwards()) {
                    receiveCommand.setResult(ReceiveCommand$Result.REJECTED_NONFASTFORWARD);
                    continue;
                }
            }
            if (receiveCommand.getRefName().startsWith("refs/") && Repository.isValidRefName(receiveCommand.getRefName())) continue;
            receiveCommand.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON, JGitText.get().funnyRefname);
        }
    }

    private boolean anyRejects() {
        for (ReceiveCommand receiveCommand : this.commands) {
            if (receiveCommand.getResult() == ReceiveCommand$Result.NOT_ATTEMPTED || receiveCommand.getResult() == ReceiveCommand$Result.OK) continue;
            return true;
        }
        return false;
    }

    private void failPendingCommands() {
        ReceiveCommand.abort(this.commands);
    }

    protected List filterCommands(ReceiveCommand$Result receiveCommand$Result) {
        return ReceiveCommand.filter(this.commands, receiveCommand$Result);
    }

    protected void executeCommands() {
        Object object;
        List list = this.filterCommands(ReceiveCommand$Result.NOT_ATTEMPTED);
        if (list.isEmpty()) {
            return;
        }
        Object object2 = NullProgressMonitor.INSTANCE;
        if (this.sideBand) {
            object = new SideBandProgressMonitor(this.msgOut);
            ((BatchingProgressMonitor)object).setDelayStart(250L, TimeUnit.MILLISECONDS);
            object2 = object;
        }
        object = this.db.getRefDatabase().newBatchUpdate();
        ((BatchRefUpdate)object).setAllowNonFastForwards(this.isAllowNonFastForwards());
        ((BatchRefUpdate)object).setAtomic(this.isAtomic());
        ((BatchRefUpdate)object).setRefLogIdent(this.getRefLogIdent());
        ((BatchRefUpdate)object).setRefLogMessage("push", true);
        ((BatchRefUpdate)object).addCommand(list);
        try {
            ((BatchRefUpdate)object).setPushCertificate(this.getPushCertificate());
            ((BatchRefUpdate)object).execute(this.walk, (ProgressMonitor)object2);
        }
        catch (IOException iOException) {
            this.receiveCommandErrorHandler.handleBatchRefUpdateException(list, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStatusReport(Throwable throwable) {
        ReceivePack$3 receivePack$3 = new ReceivePack$3(this);
        try {
            if (throwable != null) {
                ((ReceivePack$Reporter)receivePack$3).sendString("unpack error " + throwable.getMessage());
                if (this.reportStatus) {
                    for (ReceiveCommand receiveCommand : this.commands) {
                        ((ReceivePack$Reporter)receivePack$3).sendString("ng " + receiveCommand.getRefName() + " n/a (unpacker error)");
                    }
                }
                return;
            }
            if (this.reportStatus) {
                ((ReceivePack$Reporter)receivePack$3).sendString("unpack ok");
            }
            for (ReceiveCommand receiveCommand : this.commands) {
                if (receiveCommand.getResult() == ReceiveCommand$Result.OK) {
                    if (!this.reportStatus) continue;
                    ((ReceivePack$Reporter)receivePack$3).sendString("ok " + receiveCommand.getRefName());
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (this.reportStatus) {
                    stringBuilder.append("ng ").append(receiveCommand.getRefName()).append(" ");
                } else {
                    stringBuilder.append(" ! [rejected] ").append(receiveCommand.getRefName()).append(" (");
                }
                if (receiveCommand.getResult() == ReceiveCommand$Result.REJECTED_MISSING_OBJECT) {
                    if (receiveCommand.getMessage() == null) {
                        stringBuilder.append("missing object(s)");
                    } else if (receiveCommand.getMessage().length() == 40) {
                        stringBuilder.append("object ");
                        stringBuilder.append(receiveCommand.getMessage());
                        stringBuilder.append(" missing");
                    } else {
                        stringBuilder.append(receiveCommand.getMessage());
                    }
                } else if (receiveCommand.getMessage() != null) {
                    stringBuilder.append(receiveCommand.getMessage());
                } else {
                    switch (receiveCommand.getResult()) {
                        case NOT_ATTEMPTED: {
                            stringBuilder.append("server bug; ref not processed");
                            break;
                        }
                        case REJECTED_NOCREATE: {
                            stringBuilder.append("creation prohibited");
                            break;
                        }
                        case REJECTED_NODELETE: {
                            stringBuilder.append("deletion prohibited");
                            break;
                        }
                        case REJECTED_NONFASTFORWARD: {
                            stringBuilder.append("non-fast forward");
                            break;
                        }
                        case REJECTED_CURRENT_BRANCH: {
                            stringBuilder.append("branch is currently checked out");
                            break;
                        }
                        case REJECTED_OTHER_REASON: {
                            stringBuilder.append("unspecified reason");
                            break;
                        }
                        case LOCK_FAILURE: {
                            stringBuilder.append("failed to lock");
                            break;
                        }
                        case REJECTED_MISSING_OBJECT: 
                        case OK: {
                            throw new AssertionError();
                        }
                    }
                }
                if (!this.reportStatus) {
                    stringBuilder.append(")");
                }
                ((ReceivePack$Reporter)receivePack$3).sendString(stringBuilder.toString());
            }
        }
        finally {
            if (this.reportStatus) {
                this.pckOut.end();
            }
        }
    }

    private void close() {
        if (this.sideBand) {
            ((SideBandOutputStream)this.msgOut).flushBuffer();
            ((SideBandOutputStream)this.rawOut).flushBuffer();
            PacketLineOut packetLineOut = new PacketLineOut(this.origOut);
            packetLineOut.setFlushOnEnd(false);
            packetLineOut.end();
        }
        if (this.biDirectionalPipe) {
            if (!this.sideBand && this.msgOut != null) {
                this.msgOut.flush();
            }
            this.rawOut.flush();
        }
    }

    private void release() {
        this.walk.close();
        this.unlockPack();
        this.timeoutIn = null;
        this.rawIn = null;
        this.rawOut = null;
        this.msgOut = null;
        this.pckIn = null;
        this.pckOut = null;
        this.refs = null;
        this.commands = null;
        if (this.timer != null) {
            try {
                this.timer.terminate();
            }
            finally {
                this.timer = null;
            }
        }
    }

    public PushCertificate getPushCertificate() {
        return this.pushCert;
    }

    public void setPushCertificate(PushCertificate pushCertificate) {
        this.pushCert = pushCertificate;
    }

    @Nullable
    public List getPushOptions() {
        if (this.isAllowPushOptions() && this.usePushOptions) {
            return Collections.unmodifiableList(this.pushOptions);
        }
        return null;
    }

    public void setPushOptions(@Nullable List list) {
        this.usePushOptions = list != null;
        this.pushOptions = list;
    }

    public PreReceiveHook getPreReceiveHook() {
        return this.preReceive;
    }

    public void setPreReceiveHook(PreReceiveHook preReceiveHook) {
        this.preReceive = preReceiveHook != null ? preReceiveHook : PreReceiveHook.NULL;
    }

    public PostReceiveHook getPostReceiveHook() {
        return this.postReceive;
    }

    public void setPostReceiveHook(PostReceiveHook postReceiveHook) {
        this.postReceive = postReceiveHook != null ? postReceiveHook : PostReceiveHook.NULL;
    }

    public UnpackErrorHandler getUnpackErrorHandler() {
        return this.unpackErrorHandler;
    }

    public void setUnpackErrorHandler(UnpackErrorHandler unpackErrorHandler) {
        this.unpackErrorHandler = unpackErrorHandler;
    }

    @Deprecated
    public void setEchoCommandFailures(boolean bl2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
        this.init(inputStream, outputStream, outputStream2);
        try {
            this.service();
        }
        catch (PackProtocolException packProtocolException) {
            this.fatalError(packProtocolException.getMessage());
            throw packProtocolException;
        }
        catch (PacketLineIn$InputOverLimitIOException packetLineIn$InputOverLimitIOException) {
            String string = JGitText.get().tooManyCommands;
            this.fatalError(string);
            throw new PackProtocolException(string, packetLineIn$InputOverLimitIOException);
        }
        finally {
            try {
                this.close();
            }
            finally {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveWithExceptionPropagation(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
        this.init(inputStream, outputStream, outputStream2);
        try {
            this.service();
        }
        finally {
            try {
                this.close();
            }
            finally {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void service() {
        if (this.isBiDirectionalPipe()) {
            this.sendAdvertisedRefs(new RefAdvertiser$PacketLineOutRefAdvertiser(this.pckOut));
            this.pckOut.flush();
        } else {
            this.getAdvertisedOrDefaultRefs();
        }
        if (this.hasError()) {
            return;
        }
        this.recvCommands();
        if (this.hasCommands()) {
            try (ReceivePack$PostReceiveExecutor receivePack$PostReceiveExecutor = new ReceivePack$PostReceiveExecutor(this, null);){
                if (this.needPack()) {
                    try {
                        this.receivePackAndCheckConnectivity();
                    }
                    catch (IOException | Error | RuntimeException | SubmoduleValidator$SubmoduleValidationException throwable) {
                        this.unlockPack();
                        this.unpackErrorHandler.handleUnpackException(throwable);
                        throw new UnpackException(throwable);
                    }
                }
                try {
                    this.setAtomic(this.isCapabilityEnabled("atomic"));
                    this.validateCommands();
                    if (this.atomic && this.anyRejects()) {
                        this.failPendingCommands();
                    }
                    this.preReceive.onPreReceive(this, this.filterCommands(ReceiveCommand$Result.NOT_ATTEMPTED));
                    if (this.atomic && this.anyRejects()) {
                        this.failPendingCommands();
                    }
                    this.executeCommands();
                }
                finally {
                    this.unlockPack();
                }
                this.sendStatusReport(null);
            }
            this.autoGc();
        }
    }

    private void autoGc() {
        Repository repository = this.getRepository();
        if (!repository.getConfig().getBoolean("receive", "autogc", true)) {
            return;
        }
        repository.autoGC(NullProgressMonitor.INSTANCE);
    }

    static ReceiveCommand parseCommand(String string) {
        ObjectId objectId;
        ObjectId objectId2;
        if (string == null || string.length() < 83) {
            throw new PackProtocolException(JGitText.get().errorInvalidProtocolWantedOldNewRef);
        }
        String string2 = string.substring(0, 40);
        String string3 = string.substring(41, 81);
        try {
            objectId2 = ObjectId.fromString(string2);
            objectId = ObjectId.fromString(string3);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            throw new PackProtocolException(JGitText.get().errorInvalidProtocolWantedOldNewRef, invalidObjectIdException);
        }
        String string4 = string.substring(82);
        if (!Repository.isValidRefName(string4)) {
            throw new PackProtocolException(JGitText.get().errorInvalidProtocolWantedOldNewRef);
        }
        return new ReceiveCommand(objectId2, objectId, string4);
    }

    static /* synthetic */ OutputStream access$100(ReceivePack receivePack) {
        return receivePack.msgOut;
    }

    static /* synthetic */ boolean access$200(ReceivePack receivePack) {
        return receivePack.reportStatus;
    }

    static /* synthetic */ PacketLineOut access$300(ReceivePack receivePack) {
        return receivePack.pckOut;
    }

    static /* synthetic */ PostReceiveHook access$500(ReceivePack receivePack) {
        return receivePack.postReceive;
    }

    static /* synthetic */ void access$600(ReceivePack receivePack, Throwable throwable) {
        receivePack.sendStatusReport(throwable);
    }
}

