/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceiveCommand$Result;

public interface ReceiveCommandErrorHandler {
    default public void handleNewIdValidationException(ReceiveCommand receiveCommand, IOException iOException) {
        receiveCommand.setResult(ReceiveCommand$Result.REJECTED_MISSING_OBJECT, receiveCommand.getNewId().name());
    }

    default public void handleOldIdValidationException(ReceiveCommand receiveCommand, IOException iOException) {
        receiveCommand.setResult(ReceiveCommand$Result.REJECTED_MISSING_OBJECT, receiveCommand.getOldId().name());
    }

    default public void handleFastForwardCheckException(ReceiveCommand receiveCommand, IOException iOException) {
        if (iOException instanceof MissingObjectException) {
            receiveCommand.setResult(ReceiveCommand$Result.REJECTED_MISSING_OBJECT, iOException.getMessage());
        } else {
            receiveCommand.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON);
        }
    }

    default public void handleBatchRefUpdateException(List list, IOException iOException) {
        for (ReceiveCommand receiveCommand : list) {
            if (receiveCommand.getResult() != ReceiveCommand$Result.NOT_ATTEMPTED) continue;
            receiveCommand.reject(iOException);
        }
    }
}

