/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand$Result;
import org.eclipse.jgit.transport.ReceiveCommand$Type;
import org.eclipse.jgit.transport.ReceivePack;

public class ReceiveCommand {
    private final ObjectId oldId;
    private final String oldSymref;
    private final ObjectId newId;
    private final String newSymref;
    private final String name;
    private ReceiveCommand$Type type;
    private boolean typeIsCorrect;
    private Ref ref;
    private ReceiveCommand$Result status = ReceiveCommand$Result.NOT_ATTEMPTED;
    private String message;
    private boolean customRefLog;
    private String refLogMessage;
    private boolean refLogIncludeResult;
    private Boolean forceRefLog;

    public static List filter(Iterable iterable, ReceiveCommand$Result receiveCommand$Result) {
        ArrayList<ReceiveCommand> arrayList = iterable instanceof Collection ? new ArrayList(((Collection)iterable).size()) : new ArrayList<ReceiveCommand>();
        for (ReceiveCommand receiveCommand : iterable) {
            if (receiveCommand.getResult() != receiveCommand$Result) continue;
            arrayList.add(receiveCommand);
        }
        return arrayList;
    }

    public static List filter(List list, ReceiveCommand$Result receiveCommand$Result) {
        return ReceiveCommand.filter((Iterable)list, receiveCommand$Result);
    }

    public static void abort(Iterable iterable) {
        for (ReceiveCommand receiveCommand : iterable) {
            if (receiveCommand.getResult() != ReceiveCommand$Result.NOT_ATTEMPTED) continue;
            receiveCommand.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON, JGitText.get().transactionAborted);
        }
    }

    public static boolean isTransactionAborted(ReceiveCommand receiveCommand) {
        return receiveCommand.getResult() == ReceiveCommand$Result.REJECTED_OTHER_REASON && receiveCommand.getMessage().equals(JGitText.get().transactionAborted);
    }

    public static ReceiveCommand link(@NonNull ObjectId objectId, @NonNull String string, @NonNull String string2) {
        return new ReceiveCommand(objectId, string, string2);
    }

    public static ReceiveCommand link(@Nullable String string, @NonNull String string2, @NonNull String string3) {
        return new ReceiveCommand(string, string2, string3);
    }

    public static ReceiveCommand unlink(@NonNull String string, @NonNull ObjectId objectId, @NonNull String string2) {
        return new ReceiveCommand(string, objectId, string2);
    }

    public ReceiveCommand(ObjectId objectId, ObjectId objectId2, String string) {
        if (objectId == null) {
            throw new IllegalArgumentException(JGitText.get().oldIdMustNotBeNull);
        }
        if (objectId2 == null) {
            throw new IllegalArgumentException(JGitText.get().newIdMustNotBeNull);
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().nameMustNotBeNullOrEmpty);
        }
        this.oldId = objectId;
        this.oldSymref = null;
        this.newId = objectId2;
        this.newSymref = null;
        this.name = string;
        this.type = ReceiveCommand$Type.UPDATE;
        if (ObjectId.zeroId().equals(objectId)) {
            this.type = ReceiveCommand$Type.CREATE;
        }
        if (ObjectId.zeroId().equals(objectId2)) {
            this.type = ReceiveCommand$Type.DELETE;
        }
    }

    public ReceiveCommand(ObjectId objectId, ObjectId objectId2, String string, ReceiveCommand$Type receiveCommand$Type) {
        if (objectId == null) {
            throw new IllegalArgumentException(JGitText.get().oldIdMustNotBeNull);
        }
        if (objectId2 == null) {
            throw new IllegalArgumentException(JGitText.get().newIdMustNotBeNull);
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().nameMustNotBeNullOrEmpty);
        }
        this.oldId = objectId;
        this.oldSymref = null;
        this.newId = objectId2;
        this.newSymref = null;
        this.name = string;
        switch (receiveCommand$Type) {
            case CREATE: {
                if (ObjectId.zeroId().equals(objectId)) break;
                throw new IllegalArgumentException(JGitText.get().createRequiresZeroOldId);
            }
            case DELETE: {
                if (ObjectId.zeroId().equals(objectId2)) break;
                throw new IllegalArgumentException(JGitText.get().deleteRequiresZeroNewId);
            }
            case UPDATE: 
            case UPDATE_NONFASTFORWARD: {
                if (!ObjectId.zeroId().equals(objectId2) && !ObjectId.zeroId().equals(objectId)) break;
                throw new IllegalArgumentException(JGitText.get().updateRequiresOldIdAndNewId);
            }
            default: {
                throw new IllegalStateException(JGitText.get().enumValueNotSupported0);
            }
        }
        this.type = receiveCommand$Type;
    }

    private ReceiveCommand(ObjectId objectId, String string, String string2) {
        if (objectId == null) {
            throw new IllegalArgumentException(JGitText.get().oldIdMustNotBeNull);
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().nameMustNotBeNullOrEmpty);
        }
        this.oldId = objectId;
        this.oldSymref = null;
        this.newId = ObjectId.zeroId();
        this.newSymref = string;
        this.name = string2;
        this.type = AnyObjectId.isEqual(ObjectId.zeroId(), objectId) ? ReceiveCommand$Type.CREATE : (string != null ? ReceiveCommand$Type.UPDATE : ReceiveCommand$Type.DELETE);
        this.typeIsCorrect = true;
    }

    private ReceiveCommand(String string, ObjectId objectId, String string2) {
        if (objectId == null) {
            throw new IllegalArgumentException(JGitText.get().newIdMustNotBeNull);
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().nameMustNotBeNullOrEmpty);
        }
        this.oldId = ObjectId.zeroId();
        this.oldSymref = string;
        this.newId = objectId;
        this.newSymref = null;
        this.name = string2;
        this.type = string == null ? ReceiveCommand$Type.CREATE : (!AnyObjectId.isEqual(ObjectId.zeroId(), objectId) ? ReceiveCommand$Type.UPDATE : ReceiveCommand$Type.DELETE);
        this.typeIsCorrect = true;
    }

    private ReceiveCommand(@Nullable String string, String string2, String string3) {
        if (string3 == null || string3.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().nameMustNotBeNullOrEmpty);
        }
        this.oldId = ObjectId.zeroId();
        this.oldSymref = string;
        this.newId = ObjectId.zeroId();
        this.newSymref = string2;
        this.name = string3;
        if (string == null) {
            if (string2 == null) {
                throw new IllegalArgumentException(JGitText.get().bothRefTargetsMustNotBeNull);
            }
            this.type = ReceiveCommand$Type.CREATE;
        } else {
            this.type = string2 != null ? ReceiveCommand$Type.UPDATE : ReceiveCommand$Type.DELETE;
        }
        this.typeIsCorrect = true;
    }

    public ObjectId getOldId() {
        return this.oldId;
    }

    @Nullable
    public String getOldSymref() {
        return this.oldSymref;
    }

    public ObjectId getNewId() {
        return this.newId;
    }

    @Nullable
    public String getNewSymref() {
        return this.newSymref;
    }

    public String getRefName() {
        return this.name;
    }

    public ReceiveCommand$Type getType() {
        return this.type;
    }

    public Ref getRef() {
        return this.ref;
    }

    public ReceiveCommand$Result getResult() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setRefLogMessage(String string, boolean bl2) {
        this.customRefLog = true;
        if (string == null && !bl2) {
            this.disableRefLog();
        } else if (string == null && bl2) {
            this.refLogMessage = "";
            this.refLogIncludeResult = true;
        } else {
            this.refLogMessage = string;
            this.refLogIncludeResult = bl2;
        }
    }

    public void disableRefLog() {
        this.customRefLog = true;
        this.refLogMessage = null;
        this.refLogIncludeResult = false;
    }

    public void setForceRefLog(boolean bl2) {
        this.forceRefLog = bl2;
    }

    public boolean hasCustomRefLog() {
        return this.customRefLog;
    }

    public boolean isRefLogDisabled() {
        return this.refLogMessage == null;
    }

    @Nullable
    public String getRefLogMessage() {
        return this.refLogMessage;
    }

    public boolean isRefLogIncludingResult() {
        return this.refLogIncludeResult;
    }

    @Nullable
    public Boolean isForceRefLog() {
        return this.forceRefLog;
    }

    public void setResult(ReceiveCommand$Result receiveCommand$Result) {
        this.setResult(receiveCommand$Result, null);
    }

    public void setResult(ReceiveCommand$Result receiveCommand$Result, String string) {
        this.status = receiveCommand$Result;
        this.message = string;
    }

    public void updateType(RevWalk revWalk) {
        if (this.typeIsCorrect) {
            return;
        }
        if (this.type == ReceiveCommand$Type.UPDATE && !AnyObjectId.isEqual(this.oldId, this.newId)) {
            RevObject revObject = revWalk.parseAny(this.oldId);
            RevObject revObject2 = revWalk.parseAny(this.newId);
            if (!(revObject instanceof RevCommit && revObject2 instanceof RevCommit && revWalk.isMergedInto((RevCommit)revObject, (RevCommit)revObject2))) {
                this.setType(ReceiveCommand$Type.UPDATE_NONFASTFORWARD);
            }
        }
        this.typeIsCorrect = true;
    }

    public void execute(ReceivePack receivePack) {
        try {
            String string = this.getOldSymref();
            boolean bl2 = this.getNewSymref() != null || this.type == ReceiveCommand$Type.DELETE && string != null;
            RefUpdate refUpdate = receivePack.getRepository().updateRef(this.getRefName(), bl2);
            if (!(string == null || refUpdate.getRef().isSymbolic() && refUpdate.getRef().getTarget().getName().equals(string))) {
                this.setResult(ReceiveCommand$Result.LOCK_FAILURE);
                return;
            }
            refUpdate.setRefLogIdent(receivePack.getRefLogIdent());
            refUpdate.setRefLogMessage(this.refLogMessage, this.refLogIncludeResult);
            switch (this.getType()) {
                case DELETE: {
                    if (!ObjectId.zeroId().equals(this.getOldId())) {
                        refUpdate.setExpectedOldObjectId(this.getOldId());
                    }
                    refUpdate.setForceUpdate(true);
                    this.setResult(refUpdate.delete(receivePack.getRevWalk()));
                    break;
                }
                case CREATE: 
                case UPDATE: 
                case UPDATE_NONFASTFORWARD: {
                    refUpdate.setForceUpdate(receivePack.isAllowNonFastForwards());
                    refUpdate.setExpectedOldObjectId(this.getOldId());
                    refUpdate.setRefLogMessage("push", true);
                    if (this.getNewSymref() != null) {
                        this.setResult(refUpdate.link(this.getNewSymref()));
                        break;
                    }
                    refUpdate.setNewObjectId(this.getNewId());
                    this.setResult(refUpdate.update(receivePack.getRevWalk()));
                }
            }
        }
        catch (IOException iOException) {
            this.reject(iOException);
        }
    }

    void setRef(Ref ref) {
        this.ref = ref;
    }

    void setType(ReceiveCommand$Type receiveCommand$Type) {
        this.type = receiveCommand$Type;
    }

    void setTypeFastForwardUpdate() {
        this.type = ReceiveCommand$Type.UPDATE;
        this.typeIsCorrect = true;
    }

    public void setResult(RefUpdate$Result refUpdate$Result) {
        switch (refUpdate$Result) {
            case NOT_ATTEMPTED: {
                this.setResult(ReceiveCommand$Result.NOT_ATTEMPTED);
                break;
            }
            case LOCK_FAILURE: 
            case IO_FAILURE: {
                this.setResult(ReceiveCommand$Result.LOCK_FAILURE);
                break;
            }
            case NO_CHANGE: 
            case NEW: 
            case FORCED: 
            case FAST_FORWARD: {
                this.setResult(ReceiveCommand$Result.OK);
                break;
            }
            case REJECTED: {
                this.setResult(ReceiveCommand$Result.REJECTED_NONFASTFORWARD);
                break;
            }
            case REJECTED_CURRENT_BRANCH: {
                this.setResult(ReceiveCommand$Result.REJECTED_CURRENT_BRANCH);
                break;
            }
            case REJECTED_MISSING_OBJECT: {
                this.setResult(ReceiveCommand$Result.REJECTED_MISSING_OBJECT);
                break;
            }
            case REJECTED_OTHER_REASON: {
                this.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON);
                break;
            }
            default: {
                this.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON, refUpdate$Result.name());
            }
        }
    }

    void reject(IOException iOException) {
        this.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().lockError, iOException.getMessage()));
    }

    public String toString() {
        return this.getType().name() + ": " + this.getOldId().name() + " " + this.getNewId().name() + " " + this.getRefName();
    }
}

