/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.RemoteRefUpdate$Status;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.Transport;

class PushProcess {
    static final String PROGRESS_OPENING_CONNECTION = JGitText.get().openingConnection;
    private final Transport transport;
    private PushConnection connection;
    private final Map toPush;
    private final RevWalk walker;
    private final OutputStream out;
    private List pushOptions;

    PushProcess(Transport transport, Collection collection) {
        this(transport, collection, null);
    }

    PushProcess(Transport transport, Collection collection, OutputStream outputStream) {
        this.walker = new RevWalk(transport.local);
        this.transport = transport;
        this.toPush = new LinkedHashMap();
        this.out = outputStream;
        this.pushOptions = transport.getPushOptions();
        for (RemoteRefUpdate remoteRefUpdate : collection) {
            if (this.toPush.put(remoteRefUpdate.getRemoteName(), remoteRefUpdate) == null) continue;
            throw new TransportException(MessageFormat.format(JGitText.get().duplicateRemoteRefUpdateIsIllegal, remoteRefUpdate.getRemoteName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PushResult execute(ProgressMonitor progressMonitor) {
        try {
            Object object;
            progressMonitor.beginTask(PROGRESS_OPENING_CONNECTION, 0);
            PushResult pushResult = new PushResult();
            this.connection = this.transport.openPush();
            try {
                pushResult.setAdvertisedRefs(this.transport.getURI(), this.connection.getRefsMap());
                pushResult.peerUserAgent = this.connection.getPeerUserAgent();
                pushResult.setRemoteUpdates(this.toPush);
                progressMonitor.endTask();
                object = this.prepareRemoteUpdates();
                if (this.transport.isDryRun()) {
                    this.modifyUpdatesForDryRun();
                } else if (!object.isEmpty()) {
                    this.connection.push(progressMonitor, (Map)object, this.out);
                }
            }
            finally {
                this.connection.close();
                pushResult.addMessages(this.connection.getMessages());
            }
            if (!this.transport.isDryRun()) {
                this.updateTrackingRefs();
            }
            for (RemoteRefUpdate remoteRefUpdate : this.toPush.values()) {
                TrackingRefUpdate trackingRefUpdate = remoteRefUpdate.getTrackingRefUpdate();
                if (trackingRefUpdate == null) continue;
                pushResult.add(trackingRefUpdate);
            }
            object = pushResult;
            return object;
        }
        finally {
            this.walker.close();
        }
    }

    private Map prepareRemoteUpdates() {
        boolean bl2 = this.transport.isPushAtomic();
        LinkedHashMap<String, RemoteRefUpdate> linkedHashMap = new LinkedHashMap<String, RemoteRefUpdate>();
        for (RemoteRefUpdate remoteRefUpdate : this.toPush.values()) {
            Ref ref = this.connection.getRef(remoteRefUpdate.getRemoteName());
            ObjectId objectId = null;
            if (ref != null) {
                objectId = ref.getObjectId();
            }
            if (objectId == null) {
                objectId = ObjectId.zeroId();
            }
            if (remoteRefUpdate.getNewObjectId().equals(objectId)) {
                if (remoteRefUpdate.isDelete()) {
                    remoteRefUpdate.setStatus(RemoteRefUpdate$Status.NON_EXISTING);
                    continue;
                }
                remoteRefUpdate.setStatus(RemoteRefUpdate$Status.UP_TO_DATE);
                continue;
            }
            if (remoteRefUpdate.isExpectingOldObjectId() && !remoteRefUpdate.getExpectedOldObjectId().equals(objectId)) {
                remoteRefUpdate.setStatus(RemoteRefUpdate$Status.REJECTED_REMOTE_CHANGED);
                if (!bl2) continue;
                return this.rejectAll();
            }
            if (!remoteRefUpdate.isExpectingOldObjectId()) {
                remoteRefUpdate.setExpectedOldObjectId(objectId);
            }
            if (objectId.equals(ObjectId.zeroId()) || remoteRefUpdate.isDelete()) {
                remoteRefUpdate.setFastForward(true);
                linkedHashMap.put(remoteRefUpdate.getRemoteName(), remoteRefUpdate);
                continue;
            }
            boolean bl3 = true;
            try {
                RevObject revObject = this.walker.parseAny(objectId);
                RevObject revObject2 = this.walker.parseAny(remoteRefUpdate.getNewObjectId());
                if (!(revObject instanceof RevCommit && revObject2 instanceof RevCommit && this.walker.isMergedInto((RevCommit)revObject, (RevCommit)revObject2))) {
                    bl3 = false;
                }
            }
            catch (MissingObjectException missingObjectException) {
                bl3 = false;
            }
            catch (Exception exception) {
                throw new TransportException(this.transport.getURI(), MessageFormat.format(JGitText.get().readingObjectsFromLocalRepositoryFailed, exception.getMessage()), exception);
            }
            remoteRefUpdate.setFastForward(bl3);
            if (!bl3 && !remoteRefUpdate.isForceUpdate()) {
                remoteRefUpdate.setStatus(RemoteRefUpdate$Status.REJECTED_NONFASTFORWARD);
                if (!bl2) continue;
                return this.rejectAll();
            }
            linkedHashMap.put(remoteRefUpdate.getRemoteName(), remoteRefUpdate);
        }
        return linkedHashMap;
    }

    private Map rejectAll() {
        for (RemoteRefUpdate remoteRefUpdate : this.toPush.values()) {
            if (remoteRefUpdate.getStatus() != RemoteRefUpdate$Status.NOT_ATTEMPTED) continue;
            remoteRefUpdate.setStatus(RemoteRefUpdate$Status.REJECTED_OTHER_REASON);
            remoteRefUpdate.setMessage(JGitText.get().transactionAborted);
        }
        return Collections.emptyMap();
    }

    private void modifyUpdatesForDryRun() {
        for (RemoteRefUpdate remoteRefUpdate : this.toPush.values()) {
            if (remoteRefUpdate.getStatus() != RemoteRefUpdate$Status.NOT_ATTEMPTED) continue;
            remoteRefUpdate.setStatus(RemoteRefUpdate$Status.OK);
        }
    }

    private void updateTrackingRefs() {
        for (RemoteRefUpdate remoteRefUpdate : this.toPush.values()) {
            RemoteRefUpdate$Status remoteRefUpdate$Status = remoteRefUpdate.getStatus();
            if (!remoteRefUpdate.hasTrackingRefUpdate() || remoteRefUpdate$Status != RemoteRefUpdate$Status.UP_TO_DATE && remoteRefUpdate$Status != RemoteRefUpdate$Status.OK) continue;
            try {
                remoteRefUpdate.updateTrackingRef(this.walker);
            }
            catch (IOException iOException) {}
        }
    }

    public List getPushOptions() {
        return this.pushOptions;
    }
}

