/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushCertificate;
import org.eclipse.jgit.transport.PushCertificateStore$1;
import org.eclipse.jgit.transport.PushCertificateStore$2;
import org.eclipse.jgit.transport.PushCertificateStore$PendingCert;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.treewalk.TreeWalk;

public class PushCertificateStore
implements AutoCloseable {
    static final String REF_NAME = "refs/meta/push-certs";
    private final Repository db;
    private final List pending;
    ObjectReader reader;
    RevCommit commit;

    public PushCertificateStore(Repository repository) {
        this.db = repository;
        this.pending = new ArrayList();
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.commit = null;
        }
    }

    public PushCertificate get(String string) {
        if (this.reader == null) {
            this.load();
        }
        try (TreeWalk treeWalk = this.newTreeWalk(string);){
            PushCertificate pushCertificate = PushCertificateStore.read(treeWalk);
            return pushCertificate;
        }
    }

    public Iterable getAll(String string) {
        return () -> new PushCertificateStore$1(this, string);
    }

    void load() {
        this.close();
        this.reader = this.db.newObjectReader();
        Ref ref = this.db.getRefDatabase().exactRef(REF_NAME);
        if (ref == null) {
            return;
        }
        try (RevWalk revWalk = new RevWalk(this.reader);){
            this.commit = revWalk.parseCommit(ref.getObjectId());
        }
    }

    /*
     * Exception decompiling
     */
    static PushCertificate read(TreeWalk var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void put(PushCertificate pushCertificate, PersonIdent personIdent) {
        this.put(pushCertificate, personIdent, null);
    }

    public void put(PushCertificate pushCertificate, PersonIdent personIdent, Collection collection) {
        this.pending.add(new PushCertificateStore$PendingCert(pushCertificate, personIdent, collection));
    }

    /*
     * Loose catch block
     */
    public RefUpdate$Result save() {
        ObjectId objectId = this.write();
        if (objectId == null) {
            return RefUpdate$Result.NO_CHANGE;
        }
        try {
            try (ObjectInserter objectInserter = this.db.newObjectInserter();){
                RefUpdate$Result refUpdate$Result = this.updateRef(objectId);
                switch (refUpdate$Result) {
                    case FAST_FORWARD: 
                    case NEW: 
                    case NO_CHANGE: {
                        this.pending.clear();
                        break;
                    }
                }
                RefUpdate$Result refUpdate$Result2 = refUpdate$Result;
                return refUpdate$Result2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.close();
        }
    }

    public boolean save(BatchRefUpdate batchRefUpdate) {
        ObjectId objectId = this.write();
        if (objectId == null || objectId.equals(this.commit)) {
            return false;
        }
        batchRefUpdate.addCommand(new ReceiveCommand(this.commit != null ? this.commit : ObjectId.zeroId(), objectId, REF_NAME));
        return true;
    }

    public void clear() {
        this.pending.clear();
    }

    private ObjectId write() {
        if (this.pending.isEmpty()) {
            return null;
        }
        if (this.reader == null) {
            this.load();
        }
        PushCertificateStore.sortPending(this.pending);
        ObjectId objectId = this.commit;
        DirCache dirCache = this.newDirCache();
        try (ObjectInserter objectInserter = this.db.newObjectInserter();){
            for (PushCertificateStore$PendingCert pushCertificateStore$PendingCert : this.pending) {
                objectId = this.saveCert(objectInserter, dirCache, pushCertificateStore$PendingCert, objectId);
            }
            objectInserter.flush();
            RevCommit revCommit = objectId;
            return revCommit;
        }
    }

    private static void sortPending(List list) {
        Collections.sort(list, (pushCertificateStore$PendingCert, pushCertificateStore$PendingCert2) -> Long.signum(pushCertificateStore$PendingCert.ident.getWhen().getTime() - pushCertificateStore$PendingCert2.ident.getWhen().getTime()));
    }

    private DirCache newDirCache() {
        if (this.commit != null) {
            return DirCache.read(this.reader, this.commit.getTree());
        }
        return DirCache.newInCore();
    }

    private ObjectId saveCert(ObjectInserter objectInserter, DirCache dirCache, PushCertificateStore$PendingCert pushCertificateStore$PendingCert, ObjectId objectId) {
        Object object2;
        HashMap<String, Object> hashMap;
        if (pushCertificateStore$PendingCert.matching != null) {
            hashMap = new HashMap<String, Object>();
            for (Object object2 : pushCertificateStore$PendingCert.matching) {
                if (hashMap.put(((ReceiveCommand)object2).getRefName(), object2) == null) continue;
                throw new IllegalStateException();
            }
        } else {
            hashMap = null;
        }
        DirCacheEditor dirCacheEditor = dirCache.editor();
        object2 = pushCertificateStore$PendingCert.cert.toText() + pushCertificateStore$PendingCert.cert.getSignature();
        ObjectId objectId2 = objectInserter.insert(3, ((String)object2).getBytes(StandardCharsets.UTF_8));
        boolean bl2 = false;
        for (ReceiveCommand receiveCommand : pushCertificateStore$PendingCert.cert.getCommands()) {
            if (hashMap != null && !PushCertificateStore.commandsEqual(receiveCommand, (ReceiveCommand)hashMap.get(receiveCommand.getRefName()))) continue;
            bl2 = true;
            dirCacheEditor.add(new PushCertificateStore$2(this, PushCertificateStore.pathName(receiveCommand.getRefName()), objectId2));
        }
        if (!bl2) {
            return objectId;
        }
        dirCacheEditor.finish();
        CommitBuilder commitBuilder = new CommitBuilder();
        commitBuilder.setAuthor(pushCertificateStore$PendingCert.ident);
        commitBuilder.setCommitter(pushCertificateStore$PendingCert.ident);
        commitBuilder.setTreeId(dirCache.writeTree(objectInserter));
        if (objectId != null) {
            commitBuilder.setParentId(objectId);
        } else {
            commitBuilder.setParentIds(Collections.emptyList());
        }
        commitBuilder.setMessage(PushCertificateStore.buildMessage(pushCertificateStore$PendingCert.cert));
        return objectInserter.insert(1, commitBuilder.build());
    }

    private static boolean commandsEqual(ReceiveCommand receiveCommand, ReceiveCommand receiveCommand2) {
        if (receiveCommand == null || receiveCommand2 == null) {
            return receiveCommand == receiveCommand2;
        }
        return receiveCommand.getRefName().equals(receiveCommand2.getRefName()) && receiveCommand.getOldId().equals(receiveCommand2.getOldId()) && receiveCommand.getNewId().equals(receiveCommand2.getNewId());
    }

    private RefUpdate$Result updateRef(ObjectId objectId) {
        RefUpdate refUpdate = this.db.updateRef(REF_NAME);
        refUpdate.setExpectedOldObjectId(this.commit != null ? this.commit : ObjectId.zeroId());
        refUpdate.setNewObjectId(objectId);
        refUpdate.setRefLogIdent(((PushCertificateStore$PendingCert)this.pending.get((int)(this.pending.size() - 1))).ident);
        refUpdate.setRefLogMessage(JGitText.get().storePushCertReflog, false);
        try (RevWalk revWalk = new RevWalk(this.reader);){
            RefUpdate$Result refUpdate$Result = refUpdate.update(revWalk);
            return refUpdate$Result;
        }
    }

    private TreeWalk newTreeWalk(String string) {
        if (this.commit == null) {
            return null;
        }
        return TreeWalk.forPath(this.reader, PushCertificateStore.pathName(string), this.commit.getTree());
    }

    static String pathName(String string) {
        return string + "@{cert}";
    }

    private static String buildMessage(PushCertificate pushCertificate) {
        StringBuilder stringBuilder = new StringBuilder();
        if (pushCertificate.getCommands().size() == 1) {
            stringBuilder.append(MessageFormat.format(JGitText.get().storePushCertOneRef, ((ReceiveCommand)pushCertificate.getCommands().get(0)).getRefName()));
        } else {
            stringBuilder.append(MessageFormat.format(JGitText.get().storePushCertMultipleRefs, pushCertificate.getCommands().size()));
        }
        return stringBuilder.append('\n').toString();
    }
}

