/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.NonceGenerator;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PushCertificate;
import org.eclipse.jgit.transport.PushCertificate$NonceStatus;
import org.eclipse.jgit.transport.PushCertificateIdent;
import org.eclipse.jgit.transport.PushCertificateParser$PacketLineReader;
import org.eclipse.jgit.transport.PushCertificateParser$StreamReader;
import org.eclipse.jgit.transport.PushCertificateParser$StringReader;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.SignedPushConfig;

public class PushCertificateParser {
    static final String BEGIN_SIGNATURE = "-----BEGIN PGP SIGNATURE-----";
    static final String END_SIGNATURE = "-----END PGP SIGNATURE-----";
    static final String VERSION = "certificate version";
    static final String PUSHER = "pusher";
    static final String PUSHEE = "pushee";
    static final String NONCE = "nonce";
    static final String END_CERT = "push-cert-end";
    private static final String VERSION_0_1 = "0.1";
    private boolean received;
    private String version;
    private PushCertificateIdent pusher;
    private String pushee;
    private String sentNonce;
    private String receivedNonce;
    private PushCertificate$NonceStatus nonceStatus;
    private String signature;
    private final Repository db;
    private final int nonceSlopLimit;
    private final boolean enabled;
    private final NonceGenerator nonceGenerator;
    private final List commands = new ArrayList();

    public static PushCertificate fromReader(Reader reader) {
        return new PushCertificateParser().parse(reader);
    }

    public static PushCertificate fromString(String string) {
        return PushCertificateParser.fromReader(new StringReader(string));
    }

    public PushCertificateParser(Repository repository, SignedPushConfig signedPushConfig) {
        if (signedPushConfig != null) {
            this.nonceSlopLimit = signedPushConfig.getCertNonceSlopLimit();
            this.nonceGenerator = signedPushConfig.getNonceGenerator();
        } else {
            this.nonceSlopLimit = 0;
            this.nonceGenerator = null;
        }
        this.db = repository;
        this.enabled = this.nonceGenerator != null;
    }

    private PushCertificateParser() {
        this.db = null;
        this.nonceSlopLimit = 0;
        this.nonceGenerator = null;
        this.enabled = true;
    }

    public PushCertificate parse(Reader reader) {
        PushCertificateParser$StreamReader pushCertificateParser$StreamReader = new PushCertificateParser$StreamReader(reader);
        this.receiveHeader(pushCertificateParser$StreamReader, true);
        try {
            String string;
            while (!(string = pushCertificateParser$StreamReader.read()).isEmpty()) {
                if (string.equals(BEGIN_SIGNATURE)) {
                    this.receiveSignature(pushCertificateParser$StreamReader);
                    break;
                }
                this.addCommand(string);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return this.build();
    }

    public PushCertificate build() {
        if (!this.received || !this.enabled) {
            return null;
        }
        try {
            return new PushCertificate(this.version, this.pusher, this.pushee, this.receivedNonce, this.nonceStatus, Collections.unmodifiableList(this.commands), this.signature);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public boolean enabled() {
        return this.enabled;
    }

    public String getAdvertiseNonce() {
        String string = this.sentNonce();
        if (string == null) {
            return null;
        }
        return "push-cert=" + string;
    }

    private String sentNonce() {
        if (this.sentNonce == null && this.nonceGenerator != null) {
            this.sentNonce = this.nonceGenerator.createNonce(this.db, TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        }
        return this.sentNonce;
    }

    private static String parseHeader(PushCertificateParser$StringReader pushCertificateParser$StringReader, String string) {
        return PushCertificateParser.parseHeader(pushCertificateParser$StringReader.read(), string);
    }

    private static String parseHeader(String string, String string2) {
        if (string.isEmpty()) {
            throw new EOFException();
        }
        if (string.length() <= string2.length() || !string.startsWith(string2) || string.charAt(string2.length()) != ' ') {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().pushCertificateInvalidField, string2));
        }
        return string.substring(string2.length() + 1);
    }

    public void receiveHeader(PacketLineIn packetLineIn, boolean bl2) {
        this.receiveHeader(new PushCertificateParser$PacketLineReader(packetLineIn, null), bl2);
    }

    private void receiveHeader(PushCertificateParser$StringReader pushCertificateParser$StringReader, boolean bl2) {
        try {
            try {
                this.version = PushCertificateParser.parseHeader(pushCertificateParser$StringReader, VERSION);
            }
            catch (EOFException eOFException) {
                return;
            }
            this.received = true;
            if (!this.version.equals(VERSION_0_1)) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().pushCertificateInvalidFieldValue, VERSION, this.version));
            }
            String string = PushCertificateParser.parseHeader(pushCertificateParser$StringReader, PUSHER);
            this.pusher = PushCertificateIdent.parse(string);
            if (this.pusher == null) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().pushCertificateInvalidFieldValue, PUSHER, string));
            }
            String string2 = pushCertificateParser$StringReader.read();
            if (string2.startsWith(PUSHEE)) {
                this.pushee = PushCertificateParser.parseHeader(string2, PUSHEE);
                this.receivedNonce = PushCertificateParser.parseHeader(pushCertificateParser$StringReader, NONCE);
            } else {
                this.receivedNonce = PushCertificateParser.parseHeader(string2, NONCE);
            }
            PushCertificate$NonceStatus pushCertificate$NonceStatus = this.nonceStatus = this.nonceGenerator != null ? this.nonceGenerator.verify(this.receivedNonce, this.sentNonce(), this.db, bl2, this.nonceSlopLimit) : PushCertificate$NonceStatus.UNSOLICITED;
            if (!pushCertificateParser$StringReader.read().isEmpty()) {
                throw new PackProtocolException(JGitText.get().pushCertificateInvalidHeader);
            }
        }
        catch (EOFException eOFException) {
            throw new PackProtocolException(JGitText.get().pushCertificateInvalidHeader, eOFException);
        }
    }

    public void receiveSignature(PacketLineIn packetLineIn) {
        PushCertificateParser$PacketLineReader pushCertificateParser$PacketLineReader = new PushCertificateParser$PacketLineReader(packetLineIn, null);
        this.receiveSignature(pushCertificateParser$PacketLineReader);
        if (!pushCertificateParser$PacketLineReader.read().equals(END_CERT)) {
            throw new PackProtocolException(JGitText.get().pushCertificateInvalidSignature);
        }
    }

    private void receiveSignature(PushCertificateParser$StringReader pushCertificateParser$StringReader) {
        this.received = true;
        try {
            String string;
            StringBuilder stringBuilder = new StringBuilder(BEGIN_SIGNATURE).append('\n');
            while (!(string = pushCertificateParser$StringReader.read()).equals(END_SIGNATURE)) {
                stringBuilder.append(string).append('\n');
            }
            this.signature = stringBuilder.append(END_SIGNATURE).append('\n').toString();
        }
        catch (EOFException eOFException) {
            throw new PackProtocolException(JGitText.get().pushCertificateInvalidSignature, eOFException);
        }
    }

    public void addCommand(ReceiveCommand receiveCommand) {
        this.commands.add(receiveCommand);
    }

    public void addCommand(String string) {
        this.commands.add(ReceivePack.parseCommand(string));
    }
}

