/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class PushCertificateIdent {
    private final String raw;
    private final String userId;
    private final long when;
    private final int tzOffset;

    public static PushCertificateIdent parse(String string) {
        boolean bl2;
        MutableInteger mutableInteger = new MutableInteger();
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        int n2 = byArray.length - 1;
        if ((n2 = RawParseUtils.lastIndexOfTrim(byArray, ' ', n2)) < 0 || byArray[n2] != 32) {
            return new PushCertificateIdent(string, string, 0L, 0);
        }
        int n3 = n2++;
        int n4 = RawParseUtils.parseTimeZoneOffset(byArray, n2, mutableInteger);
        boolean bl3 = mutableInteger.value != n2;
        if ((n3 = RawParseUtils.lastIndexOfTrim(byArray, ' ', n3)) < 0 || byArray[n3] != 32) {
            return new PushCertificateIdent(string, string, 0L, 0);
        }
        int n5 = n3++;
        long l2 = RawParseUtils.parseLongBase10(byArray, n3, mutableInteger);
        boolean bl4 = bl2 = mutableInteger.value != n3;
        if (bl3 && bl2) {
            n5 = n3 - 1;
        } else {
            n4 = 0;
            l2 = 0L;
            n5 = bl3 && !bl2 ? n2 - 1 : byArray.length;
        }
        String string2 = new String(byArray, 0, n5, StandardCharsets.UTF_8);
        return new PushCertificateIdent(string, string2, l2 * 1000L, n4);
    }

    public PushCertificateIdent(String string, long l2, int n2) {
        this.userId = string;
        this.when = l2;
        this.tzOffset = n2;
        StringBuilder stringBuilder = new StringBuilder(string).append(' ').append(l2 / 1000L).append(' ');
        PersonIdent.appendTimezone(stringBuilder, n2);
        this.raw = stringBuilder.toString();
    }

    private PushCertificateIdent(String string, String string2, long l2, int n2) {
        this.raw = string;
        this.userId = string2;
        this.when = l2;
        this.tzOffset = n2;
    }

    public String getRaw() {
        return this.raw;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getName() {
        int n2;
        int n3 = this.userId.indexOf(60);
        if (n3 < 0 || this.userId.indexOf(62, n3) < 0) {
            n3 = this.userId.length();
        }
        --n3;
        while (n3 >= 0 && this.userId.charAt(n3) == ' ') {
            --n3;
        }
        for (n2 = 0; n2 < n3 && this.userId.charAt(n2) == ' '; ++n2) {
        }
        return this.userId.substring(n2, n3 + 1);
    }

    public String getEmailAddress() {
        int n2 = this.userId.indexOf(60);
        if (n2 < 0) {
            return null;
        }
        int n3 = this.userId.indexOf(62, n2);
        if (n3 < 0) {
            return null;
        }
        return this.userId.substring(n2 + 1, n3);
    }

    public Date getWhen() {
        return new Date(this.when);
    }

    public TimeZone getTimeZone() {
        return PersonIdent.getTimeZone(this.tzOffset);
    }

    public int getTimeZoneOffset() {
        return this.tzOffset;
    }

    public boolean equals(Object object) {
        return object instanceof PushCertificateIdent && this.raw.equals(((PushCertificateIdent)object).raw);
    }

    public int hashCode() {
        return this.raw.hashCode();
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy Z", Locale.US);
        simpleDateFormat.setTimeZone(this.getTimeZone());
        return this.getClass().getSimpleName() + "[raw=\"" + this.raw + "\", userId=\"" + this.userId + "\", " + simpleDateFormat.format(this.when) + "]";
    }
}

