/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.PushCertificate$NonceStatus;
import org.eclipse.jgit.transport.PushCertificateIdent;
import org.eclipse.jgit.transport.ReceiveCommand;

public class PushCertificate {
    private final String version;
    private final PushCertificateIdent pusher;
    private final String pushee;
    private final String nonce;
    private final PushCertificate$NonceStatus nonceStatus;
    private final List commands;
    private final String signature;

    PushCertificate(String string, PushCertificateIdent pushCertificateIdent, String string2, String string3, PushCertificate$NonceStatus pushCertificate$NonceStatus, List list, String string4) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().pushCertificateInvalidField, "certificate version"));
        }
        if (pushCertificateIdent == null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().pushCertificateInvalidField, "pusher"));
        }
        if (string3 == null || string3.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().pushCertificateInvalidField, "nonce"));
        }
        if (pushCertificate$NonceStatus == null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().pushCertificateInvalidField, "nonce status"));
        }
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().pushCertificateInvalidField, "command"));
        }
        if (string4 == null || string4.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().pushCertificateInvalidSignature);
        }
        if (!string4.startsWith("-----BEGIN PGP SIGNATURE-----") || !string4.endsWith("-----END PGP SIGNATURE-----\n")) {
            throw new IllegalArgumentException(JGitText.get().pushCertificateInvalidSignature);
        }
        this.version = string;
        this.pusher = pushCertificateIdent;
        this.pushee = string2;
        this.nonce = string3;
        this.nonceStatus = pushCertificate$NonceStatus;
        this.commands = list;
        this.signature = string4;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPusher() {
        return this.pusher.getRaw();
    }

    public PushCertificateIdent getPusherIdent() {
        return this.pusher;
    }

    public String getPushee() {
        return this.pushee;
    }

    public String getNonce() {
        return this.nonce;
    }

    public PushCertificate$NonceStatus getNonceStatus() {
        return this.nonceStatus;
    }

    public List getCommands() {
        return this.commands;
    }

    public String getSignature() {
        return this.signature;
    }

    public String toText() {
        return this.toStringBuilder().toString();
    }

    public String toTextWithSignature() {
        return this.toStringBuilder().append(this.signature).toString();
    }

    private StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder().append("certificate version").append(' ').append(this.version).append('\n').append("pusher").append(' ').append(this.getPusher()).append('\n');
        if (this.pushee != null) {
            stringBuilder.append("pushee").append(' ').append(this.pushee).append('\n');
        }
        stringBuilder.append("nonce").append(' ').append(this.nonce).append('\n').append('\n');
        for (ReceiveCommand receiveCommand : this.commands) {
            stringBuilder.append(receiveCommand.getOldId().name()).append(' ').append(receiveCommand.getNewId().name()).append(' ').append(receiveCommand.getRefName()).append('\n');
        }
        return stringBuilder;
    }

    public int hashCode() {
        return this.signature.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PushCertificate)) {
            return false;
        }
        PushCertificate pushCertificate = (PushCertificate)object;
        return this.version.equals(pushCertificate.version) && this.pusher.equals(pushCertificate.pusher) && Objects.equals(this.pushee, pushCertificate.pushee) && this.nonceStatus == pushCertificate.nonceStatus && this.signature.equals(pushCertificate.signature) && PushCertificate.commandsEqual(this, pushCertificate);
    }

    private static boolean commandsEqual(PushCertificate pushCertificate, PushCertificate pushCertificate2) {
        if (pushCertificate.commands.size() != pushCertificate2.commands.size()) {
            return false;
        }
        for (int i2 = 0; i2 < pushCertificate.commands.size(); ++i2) {
            ReceiveCommand receiveCommand = (ReceiveCommand)pushCertificate.commands.get(i2);
            ReceiveCommand receiveCommand2 = (ReceiveCommand)pushCertificate2.commands.get(i2);
            if (receiveCommand.getOldId().equals(receiveCommand2.getOldId()) && receiveCommand.getNewId().equals(receiveCommand2.getNewId()) && receiveCommand.getRefName().equals(receiveCommand2.getRefName())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toTextWithSignature() + ']';
    }
}

