/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.FetchV2Request;
import org.eclipse.jgit.transport.FetchV2Request$Builder;
import org.eclipse.jgit.transport.FilterSpec;
import org.eclipse.jgit.transport.LsRefsV2Request;
import org.eclipse.jgit.transport.LsRefsV2Request$Builder;
import org.eclipse.jgit.transport.ObjectInfoRequest;
import org.eclipse.jgit.transport.ObjectInfoRequest$Builder;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.TransferConfig;

final class ProtocolV2Parser {
    private final TransferConfig transferConfig;

    ProtocolV2Parser(TransferConfig transferConfig) {
        this.transferConfig = transferConfig;
    }

    private static String consumeCapabilities(PacketLineIn packetLineIn, Consumer consumer, Consumer consumer2) {
        String string = "server-option=";
        String string2 = "agent=";
        String string3 = packetLineIn.readString();
        while (!PacketLineIn.isDelimiter(string3) && !PacketLineIn.isEnd(string3)) {
            if (string3.startsWith(string)) {
                consumer.accept(string3.substring(string.length()));
            } else if (string3.startsWith(string2)) {
                consumer2.accept(string3.substring(string2.length()));
            }
            string3 = packetLineIn.readString();
        }
        return string3;
    }

    FetchV2Request parseFetchRequest(PacketLineIn packetLineIn) {
        FetchV2Request$Builder fetchV2Request$Builder = FetchV2Request.builder();
        fetchV2Request$Builder.addClientCapability("side-band-64k");
        String string2 = ProtocolV2Parser.consumeCapabilities(packetLineIn, string -> fetchV2Request$Builder.addServerOption((String)string), string -> fetchV2Request$Builder.setAgent((String)string));
        if (PacketLineIn.isEnd(string2)) {
            return fetchV2Request$Builder.build();
        }
        if (!PacketLineIn.isDelimiter(string2)) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, string2));
        }
        boolean bl2 = false;
        for (String string3 : packetLineIn.readStrings()) {
            if (string3.startsWith("want ")) {
                fetchV2Request$Builder.addWantId(ObjectId.fromString(string3.substring(5)));
                continue;
            }
            if (this.transferConfig.isAllowRefInWant() && string3.startsWith("want-ref ")) {
                fetchV2Request$Builder.addWantedRef(string3.substring("want-ref".length() + 1));
                continue;
            }
            if (string3.startsWith("have ")) {
                fetchV2Request$Builder.addPeerHas(ObjectId.fromString(string3.substring(5)));
                continue;
            }
            if (string3.equals("done")) {
                fetchV2Request$Builder.setDoneReceived();
                continue;
            }
            if (string3.equals("wait-for-done")) {
                fetchV2Request$Builder.setWaitForDone();
                continue;
            }
            if (string3.equals("thin-pack")) {
                fetchV2Request$Builder.addClientCapability("thin-pack");
                continue;
            }
            if (string3.equals("no-progress")) {
                fetchV2Request$Builder.addClientCapability("no-progress");
                continue;
            }
            if (string3.equals("include-tag")) {
                fetchV2Request$Builder.addClientCapability("include-tag");
                continue;
            }
            if (string3.equals("ofs-delta")) {
                fetchV2Request$Builder.addClientCapability("ofs-delta");
                continue;
            }
            if (string3.startsWith("shallow ")) {
                fetchV2Request$Builder.addClientShallowCommit(ObjectId.fromString(string3.substring(8)));
                continue;
            }
            if (string3.startsWith("deepen ")) {
                int n2 = Integer.parseInt(string3.substring(7));
                if (n2 <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidDepth, n2));
                }
                if (fetchV2Request$Builder.getDeepenSince() != 0) {
                    throw new PackProtocolException(JGitText.get().deepenSinceWithDeepen);
                }
                if (fetchV2Request$Builder.hasDeepenNotRefs()) {
                    throw new PackProtocolException(JGitText.get().deepenNotWithDeepen);
                }
                fetchV2Request$Builder.setDepth(n2);
                continue;
            }
            if (string3.startsWith("deepen-not ")) {
                fetchV2Request$Builder.addDeepenNotRef(string3.substring(11));
                if (fetchV2Request$Builder.getDepth() == 0) continue;
                throw new PackProtocolException(JGitText.get().deepenNotWithDeepen);
            }
            if (string3.equals("deepen-relative")) {
                fetchV2Request$Builder.addClientCapability("deepen-relative");
                continue;
            }
            if (string3.startsWith("deepen-since ")) {
                int n3 = Integer.parseInt(string3.substring(13));
                if (n3 <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidTimestamp, string3));
                }
                if (fetchV2Request$Builder.getDepth() != 0) {
                    throw new PackProtocolException(JGitText.get().deepenSinceWithDeepen);
                }
                fetchV2Request$Builder.setDeepenSince(n3);
                continue;
            }
            if (this.transferConfig.isAllowFilter() && string3.startsWith("filter ")) {
                if (bl2) {
                    throw new PackProtocolException(JGitText.get().tooManyFilters);
                }
                bl2 = true;
                fetchV2Request$Builder.setFilterSpec(FilterSpec.fromFilterLine(string3.substring("filter".length() + 1)));
                continue;
            }
            if (this.transferConfig.isAllowSidebandAll() && string3.equals("sideband-all")) {
                fetchV2Request$Builder.setSidebandAll(true);
                continue;
            }
            if (string3.startsWith("packfile-uris ")) {
                for (String string4 : string3.substring(14).split(",")) {
                    fetchV2Request$Builder.addPackfileUriProtocol(string4);
                }
                continue;
            }
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, string3));
        }
        return fetchV2Request$Builder.build();
    }

    LsRefsV2Request parseLsRefsRequest(PacketLineIn packetLineIn) {
        LsRefsV2Request$Builder lsRefsV2Request$Builder = LsRefsV2Request.builder();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = ProtocolV2Parser.consumeCapabilities(packetLineIn, string -> lsRefsV2Request$Builder.addServerOption((String)string), string -> lsRefsV2Request$Builder.setAgent((String)string));
        if (PacketLineIn.isEnd(string2)) {
            return lsRefsV2Request$Builder.build();
        }
        if (!PacketLineIn.isDelimiter(string2)) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, string2));
        }
        for (String string3 : packetLineIn.readStrings()) {
            if (string3.equals("peel")) {
                lsRefsV2Request$Builder.setPeel(true);
                continue;
            }
            if (string3.equals("symrefs")) {
                lsRefsV2Request$Builder.setSymrefs(true);
                continue;
            }
            if (string3.startsWith("ref-prefix ")) {
                arrayList.add(string3.substring("ref-prefix ".length()));
                continue;
            }
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, string3));
        }
        return lsRefsV2Request$Builder.setRefPrefixes(arrayList).build();
    }

    ObjectInfoRequest parseObjectInfoRequest(PacketLineIn packetLineIn) {
        ObjectInfoRequest$Builder objectInfoRequest$Builder = ObjectInfoRequest.builder();
        ArrayList<ObjectId> arrayList = new ArrayList<ObjectId>();
        String string = packetLineIn.readString();
        if (PacketLineIn.isEnd(string)) {
            return objectInfoRequest$Builder.build();
        }
        if (!string.equals("size")) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, string));
        }
        for (String string2 : packetLineIn.readStrings()) {
            if (!string2.startsWith("oid ")) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, string2));
            }
            String string3 = string2.substring("oid ".length());
            try {
                arrayList.add(ObjectId.fromString(string3));
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidObject, string3), invalidObjectIdException);
            }
        }
        return objectInfoRequest$Builder.setObjectIDs(arrayList).build();
    }
}

