/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.transport.CapabilitiesV2Request;
import org.eclipse.jgit.transport.FetchV2Request;
import org.eclipse.jgit.transport.LsRefsV2Request;
import org.eclipse.jgit.transport.ObjectInfoRequest;
import org.eclipse.jgit.transport.ProtocolV2Hook;

public class ProtocolV2HookChain
implements ProtocolV2Hook {
    private final List hooks;

    public static ProtocolV2Hook newChain(List list) {
        List list2 = list.stream().filter(protocolV2Hook -> !protocolV2Hook.equals(ProtocolV2Hook.DEFAULT)).collect(Collectors.toList());
        if (list2.isEmpty()) {
            return ProtocolV2Hook.DEFAULT;
        }
        if (list2.size() == 1) {
            return (ProtocolV2Hook)list2.get(0);
        }
        return new ProtocolV2HookChain(list2);
    }

    @Override
    public void onCapabilities(CapabilitiesV2Request capabilitiesV2Request) {
        for (ProtocolV2Hook protocolV2Hook : this.hooks) {
            protocolV2Hook.onCapabilities(capabilitiesV2Request);
        }
    }

    @Override
    public void onLsRefs(LsRefsV2Request lsRefsV2Request) {
        for (ProtocolV2Hook protocolV2Hook : this.hooks) {
            protocolV2Hook.onLsRefs(lsRefsV2Request);
        }
    }

    @Override
    public void onFetch(FetchV2Request fetchV2Request) {
        for (ProtocolV2Hook protocolV2Hook : this.hooks) {
            protocolV2Hook.onFetch(fetchV2Request);
        }
    }

    @Override
    public void onObjectInfo(ObjectInfoRequest objectInfoRequest) {
        for (ProtocolV2Hook protocolV2Hook : this.hooks) {
            protocolV2Hook.onObjectInfo(objectInfoRequest);
        }
    }

    private ProtocolV2HookChain(List list) {
        this.hooks = Collections.unmodifiableList(list);
    }
}

