/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.transport.parser.FirstWant;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.FetchV0Request;
import org.eclipse.jgit.transport.FetchV0Request$Builder;
import org.eclipse.jgit.transport.FilterSpec;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.TransferConfig;

final class ProtocolV0Parser {
    private final TransferConfig transferConfig;

    ProtocolV0Parser(TransferConfig transferConfig) {
        this.transferConfig = transferConfig;
    }

    FetchV0Request recvWants(PacketLineIn packetLineIn) {
        FetchV0Request$Builder fetchV0Request$Builder = new FetchV0Request$Builder();
        boolean bl2 = true;
        boolean bl3 = false;
        while (true) {
            String string;
            try {
                string = packetLineIn.readString();
            }
            catch (EOFException eOFException) {
                if (bl2) break;
                throw eOFException;
            }
            if (PacketLineIn.isEnd(string)) break;
            if (string.startsWith("deepen ")) {
                int n2 = Integer.parseInt(string.substring(7));
                if (n2 <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidDepth, n2));
                }
                fetchV0Request$Builder.setDepth(n2);
                continue;
            }
            if (string.startsWith("shallow ")) {
                fetchV0Request$Builder.addClientShallowCommit(ObjectId.fromString(string.substring(8)));
                continue;
            }
            if (this.transferConfig.isAllowFilter() && string.startsWith("filter ")) {
                String string2 = string.substring("filter".length() + 1);
                if (bl3) {
                    throw new PackProtocolException(JGitText.get().tooManyFilters);
                }
                bl3 = true;
                fetchV0Request$Builder.setFilterSpec(FilterSpec.fromFilterLine(string2));
                continue;
            }
            if (!string.startsWith("want ") || string.length() < 45) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "want", string));
            }
            if (bl2 && string.length() > 45) {
                FirstWant firstWant = FirstWant.fromLine(string);
                fetchV0Request$Builder.addClientCapabilities(firstWant.getCapabilities());
                fetchV0Request$Builder.setAgent(firstWant.getAgent());
                string = firstWant.getLine();
            }
            fetchV0Request$Builder.addWantId(ObjectId.fromString(string.substring(5)));
            bl2 = false;
        }
        return fetchV0Request$Builder.build();
    }
}

