/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;

public class ProgressSpinner {
    private static final long MIN_REFRESH_MILLIS = 500L;
    private static final char[] STATES = new char[]{'-', '\\', '|', '/'};
    private final OutputStream out;
    private String msg;
    private int state;
    private boolean write;
    private boolean shown;
    private long nextUpdateMillis;

    public ProgressSpinner(OutputStream outputStream) {
        this.out = outputStream;
        this.write = true;
    }

    public void beginTask(String string, long l2, TimeUnit timeUnit) {
        this.msg = string;
        this.state = 0;
        this.shown = false;
        long l3 = System.currentTimeMillis();
        if (l2 > 0L) {
            this.nextUpdateMillis = l3 + timeUnit.toMillis(l2);
        } else {
            this.send(l3);
        }
    }

    public void update() {
        long l2 = System.currentTimeMillis();
        if (l2 >= this.nextUpdateMillis) {
            this.send(l2);
            this.state = (this.state + 1) % STATES.length;
        }
    }

    private void send(long l2) {
        StringBuilder stringBuilder = new StringBuilder(this.msg.length() + 16);
        stringBuilder.append('\r').append(this.msg).append("... (");
        stringBuilder.append(STATES[this.state]);
        stringBuilder.append(")  ");
        this.shown = true;
        this.write(stringBuilder.toString());
        this.nextUpdateMillis = l2 + 500L;
    }

    public void endTask(String string) {
        if (this.shown) {
            this.write('\r' + this.msg + "... " + string + "\n");
        }
    }

    private void write(String string) {
        if (this.write) {
            try {
                this.out.write(string.getBytes(StandardCharsets.UTF_8));
                this.out.flush();
            }
            catch (IOException iOException) {
                this.write = false;
            }
        }
    }
}

