/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketLineOut {
    private static final Logger log = LoggerFactory.getLogger(PacketLineOut.class);
    private final OutputStream out;
    private final byte[] lenbuffer;
    private final boolean logEnabled;
    private boolean flushOnEnd;
    private boolean usingSideband;
    private static final byte[] hexchar = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public PacketLineOut(OutputStream outputStream) {
        this(outputStream, true);
    }

    public PacketLineOut(OutputStream outputStream, boolean bl2) {
        this.out = outputStream;
        this.lenbuffer = new byte[5];
        this.flushOnEnd = true;
        this.logEnabled = bl2;
    }

    public void setFlushOnEnd(boolean bl2) {
        this.flushOnEnd = bl2;
    }

    public boolean isUsingSideband() {
        return this.usingSideband;
    }

    public void setUsingSideband(boolean bl2) {
        this.usingSideband = bl2;
    }

    public void writeString(String string) {
        this.writePacket(Constants.encode(string));
    }

    public void writePacket(byte[] byArray) {
        this.writePacket(byArray, 0, byArray.length);
    }

    public void writePacket(byte[] byArray, int n2, int n3) {
        if (this.usingSideband) {
            this.formatLength(n3 + 5);
            this.out.write(this.lenbuffer, 0, 4);
            this.out.write(1);
        } else {
            this.formatLength(n3 + 4);
            this.out.write(this.lenbuffer, 0, 4);
        }
        this.out.write(byArray, n2, n3);
        if (this.logEnabled && log.isDebugEnabled()) {
            if (n3 > 0 && byArray[n2 + n3 - 1] == 10) {
                log.debug("git> " + RawParseUtils.decode(StandardCharsets.UTF_8, byArray, n2, n3 - 1) + "\\n");
            } else {
                log.debug("git> " + RawParseUtils.decode(StandardCharsets.UTF_8, byArray, n2, n3));
            }
        }
    }

    public void writeDelim() {
        this.formatLength(1);
        this.out.write(this.lenbuffer, 0, 4);
        if (this.logEnabled && log.isDebugEnabled()) {
            log.debug("git> 0001");
        }
    }

    public void end() {
        this.formatLength(0);
        this.out.write(this.lenbuffer, 0, 4);
        if (this.logEnabled && log.isDebugEnabled()) {
            log.debug("git> 0000");
        }
        if (this.flushOnEnd) {
            this.flush();
        }
    }

    public void flush() {
        this.out.flush();
    }

    private void formatLength(int n2) {
        PacketLineOut.formatLength(this.lenbuffer, n2);
    }

    static void formatLength(byte[] byArray, int n2) {
        int n3 = 3;
        while (n3 >= 0 && n2 != 0) {
            byArray[n3--] = hexchar[n2 & 0xF];
            n2 >>>= 4;
        }
        while (n3 >= 0) {
            byArray[n3--] = 48;
        }
    }
}

