/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.transport.PacketLineIn$AckNackResult;
import org.eclipse.jgit.transport.PacketLineIn$InputOverLimitIOException;
import org.eclipse.jgit.transport.PacketLineIn$PacketLineInIterator;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketLineIn {
    private static final Logger log = LoggerFactory.getLogger(PacketLineIn.class);
    @Deprecated
    public static final String END = new String();
    @Deprecated
    public static final String DELIM = new String();
    private final byte[] lineBuffer = new byte[1000];
    private final InputStream in;
    private long limit;

    public PacketLineIn(InputStream inputStream) {
        this(inputStream, 0L);
    }

    public PacketLineIn(InputStream inputStream, long l2) {
        this.in = inputStream;
        this.limit = l2;
    }

    static PacketLineIn$AckNackResult parseACKv2(String string, MutableObjectId mutableObjectId) {
        if ("NAK".equals(string)) {
            return PacketLineIn$AckNackResult.NAK;
        }
        if (string.startsWith("ACK ") && string.length() == 44) {
            mutableObjectId.fromString(string.substring(4, 44));
            return PacketLineIn$AckNackResult.ACK_COMMON;
        }
        if ("ready".equals(string)) {
            return PacketLineIn$AckNackResult.ACK_READY;
        }
        if (string.startsWith("ERR ")) {
            throw new PackProtocolException(string.substring(4));
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedACKNAKGot, string));
    }

    PacketLineIn$AckNackResult readACK(MutableObjectId mutableObjectId) {
        String string = this.readString();
        if (string.length() == 0) {
            throw new PackProtocolException(JGitText.get().expectedACKNAKFoundEOF);
        }
        if ("NAK".equals(string)) {
            return PacketLineIn$AckNackResult.NAK;
        }
        if (string.startsWith("ACK ")) {
            String string2;
            mutableObjectId.fromString(string.substring(4, 44));
            if (string.length() == 44) {
                return PacketLineIn$AckNackResult.ACK;
            }
            switch (string2 = string.substring(44)) {
                case " continue": {
                    return PacketLineIn$AckNackResult.ACK_CONTINUE;
                }
                case " common": {
                    return PacketLineIn$AckNackResult.ACK_COMMON;
                }
                case " ready": {
                    return PacketLineIn$AckNackResult.ACK_READY;
                }
            }
        }
        if (string.startsWith("ERR ")) {
            throw new PackProtocolException(string.substring(4));
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedACKNAKGot, string));
    }

    public String readString() {
        int n2 = this.readLength();
        if (n2 == 0) {
            log.debug("git< 0000");
            return END;
        }
        if (n2 == 1) {
            log.debug("git< 0001");
            return DELIM;
        }
        if ((n2 -= 4) == 0) {
            log.debug("git< ");
            return "";
        }
        byte[] byArray = n2 <= this.lineBuffer.length ? this.lineBuffer : new byte[n2];
        IO.readFully(this.in, byArray, 0, n2);
        if (byArray[n2 - 1] == 10) {
            --n2;
        }
        String string = RawParseUtils.decode(StandardCharsets.UTF_8, byArray, 0, n2);
        log.debug("git< " + string);
        return string;
    }

    public PacketLineIn$PacketLineInIterator readStrings() {
        return new PacketLineIn$PacketLineInIterator(this);
    }

    public String readStringRaw() {
        int n2 = this.readLength();
        if (n2 == 0) {
            log.debug("git< 0000");
            return END;
        }
        byte[] byArray = (n2 -= 4) <= this.lineBuffer.length ? this.lineBuffer : new byte[n2];
        IO.readFully(this.in, byArray, 0, n2);
        String string = RawParseUtils.decode(StandardCharsets.UTF_8, byArray, 0, n2);
        log.debug("git< " + string);
        return string;
    }

    public static boolean isDelimiter(String string) {
        return string == DELIM;
    }

    static String delimiter() {
        return DELIM;
    }

    static String end() {
        return END;
    }

    public static boolean isEnd(String string) {
        return string == END;
    }

    void discardUntilEnd() {
        int n2;
        while ((n2 = this.readLength()) != 0) {
            IO.skipFully(this.in, n2 - 4);
        }
    }

    int readLength() {
        int n2;
        IO.readFully(this.in, this.lineBuffer, 0, 4);
        try {
            n2 = RawParseUtils.parseHexInt16(this.lineBuffer, 0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.invalidHeader(arrayIndexOutOfBoundsException);
        }
        if (n2 == 0) {
            return 0;
        }
        if (n2 == 1) {
            return 1;
        }
        if (n2 < 4) {
            throw this.invalidHeader();
        }
        if (this.limit != 0L) {
            int n3 = n2 - 4;
            if (this.limit < (long)n3) {
                this.limit = -1L;
                try {
                    IO.skipFully(this.in, n3);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new PacketLineIn$InputOverLimitIOException();
            }
            this.limit = (long)n3 < this.limit ? this.limit - (long)n3 : -1L;
        }
        return n2;
    }

    private IOException invalidHeader() {
        return new IOException(MessageFormat.format(JGitText.get().invalidPacketLineHeader, "" + (char)this.lineBuffer[0] + (char)this.lineBuffer[1] + (char)this.lineBuffer[2] + (char)this.lineBuffer[3]));
    }

    private IOException invalidHeader(Throwable throwable) {
        IOException iOException = this.invalidHeader();
        iOException.initCause(throwable);
        return iOException;
    }
}

