/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.TooLargeObjectInPackException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.internal.storage.pack.BinaryDelta;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.eclipse.jgit.lib.BlobObjectChecker;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.PackParser$DeltaChain;
import org.eclipse.jgit.transport.PackParser$DeltaVisit;
import org.eclipse.jgit.transport.PackParser$InflaterStream;
import org.eclipse.jgit.transport.PackParser$ObjectTypeAndSize;
import org.eclipse.jgit.transport.PackParser$Source;
import org.eclipse.jgit.transport.PackParser$UnresolvedDelta;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.transport.ReceivedPackStatistics;
import org.eclipse.jgit.transport.ReceivedPackStatistics$Builder;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.LongMap;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.sha1.SHA1;

public abstract class PackParser {
    private static final int BUFFER_SIZE = 8192;
    private final ObjectDatabase objectDatabase;
    private PackParser$InflaterStream inflater;
    private byte[] tempBuffer;
    private byte[] hdrBuf;
    private final SHA1 objectHasher = SHA1.newInstance();
    private final MutableObjectId tempObjectId;
    private InputStream in;
    byte[] buf;
    private long bBase;
    private int bOffset;
    int bAvail;
    private ObjectChecker objCheck;
    private boolean allowThin;
    private boolean checkObjectCollisions;
    private boolean needBaseObjectIds;
    private boolean checkEofAfterPackFooter;
    private boolean expectDataAfterPackFooter;
    private long expectedObjectCount;
    private PackedObjectInfo[] entries;
    private ObjectIdSubclassMap newObjectIds;
    private int deltaCount;
    private int entryCount;
    private ObjectIdOwnerMap baseById;
    private ObjectIdSubclassMap baseObjectIds;
    private LongMap baseByPos;
    private BlockList collisionCheckObjs;
    private MessageDigest packDigest;
    private ObjectReader readCurs;
    private String lockMessage;
    private long maxObjectSizeLimit;
    private final ReceivedPackStatistics$Builder stats = new ReceivedPackStatistics$Builder();

    protected PackParser(ObjectDatabase objectDatabase, InputStream inputStream) {
        this.objectDatabase = objectDatabase.newCachedDatabase();
        this.in = inputStream;
        this.inflater = new PackParser$InflaterStream(this);
        this.readCurs = this.objectDatabase.newReader();
        this.buf = new byte[8192];
        this.tempBuffer = new byte[8192];
        this.hdrBuf = new byte[64];
        this.tempObjectId = new MutableObjectId();
        this.packDigest = Constants.newMessageDigest();
        this.checkObjectCollisions = true;
    }

    public boolean isAllowThin() {
        return this.allowThin;
    }

    public void setAllowThin(boolean bl2) {
        this.allowThin = bl2;
    }

    protected boolean isCheckObjectCollisions() {
        return this.checkObjectCollisions;
    }

    protected void setCheckObjectCollisions(boolean bl2) {
        this.checkObjectCollisions = bl2;
    }

    public void setNeedNewObjectIds(boolean bl2) {
        this.newObjectIds = bl2 ? new ObjectIdSubclassMap() : null;
    }

    private boolean needNewObjectIds() {
        return this.newObjectIds != null;
    }

    public void setNeedBaseObjectIds(boolean bl2) {
        this.needBaseObjectIds = bl2;
    }

    public boolean isCheckEofAfterPackFooter() {
        return this.checkEofAfterPackFooter;
    }

    public void setCheckEofAfterPackFooter(boolean bl2) {
        this.checkEofAfterPackFooter = bl2;
    }

    public boolean isExpectDataAfterPackFooter() {
        return this.expectDataAfterPackFooter;
    }

    public void setExpectDataAfterPackFooter(boolean bl2) {
        this.expectDataAfterPackFooter = bl2;
    }

    public ObjectIdSubclassMap getNewObjectIds() {
        if (this.newObjectIds != null) {
            return this.newObjectIds;
        }
        return new ObjectIdSubclassMap();
    }

    public ObjectIdSubclassMap getBaseObjectIds() {
        if (this.baseObjectIds != null) {
            return this.baseObjectIds;
        }
        return new ObjectIdSubclassMap();
    }

    public void setObjectChecker(ObjectChecker objectChecker) {
        this.objCheck = objectChecker;
    }

    public void setObjectChecking(boolean bl2) {
        this.setObjectChecker(bl2 ? new ObjectChecker() : null);
    }

    public String getLockMessage() {
        return this.lockMessage;
    }

    public void setLockMessage(String string) {
        this.lockMessage = string;
    }

    public void setMaxObjectSizeLimit(long l2) {
        this.maxObjectSizeLimit = l2;
    }

    public int getObjectCount() {
        return this.entryCount;
    }

    public PackedObjectInfo getObject(int n2) {
        return this.entries[n2];
    }

    public List getSortedObjectList(Comparator comparator) {
        Arrays.sort(this.entries, 0, this.entryCount, comparator);
        List<PackedObjectInfo> list = Arrays.asList(this.entries);
        if (this.entryCount < this.entries.length) {
            list = list.subList(0, this.entryCount);
        }
        return list;
    }

    public long getPackSize() {
        return -1L;
    }

    public ReceivedPackStatistics getReceivedPackStatistics() {
        return this.stats.build();
    }

    public final PackLock parse(ProgressMonitor progressMonitor) {
        return this.parse(progressMonitor, progressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackLock parse(ProgressMonitor progressMonitor, ProgressMonitor progressMonitor2) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (progressMonitor2 == null) {
            progressMonitor2 = NullProgressMonitor.INSTANCE;
        }
        if (progressMonitor == progressMonitor2) {
            progressMonitor.start(2);
        }
        try {
            this.readPackHeader();
            this.entries = new PackedObjectInfo[(int)this.expectedObjectCount];
            this.baseById = new ObjectIdOwnerMap();
            this.baseByPos = new LongMap();
            this.collisionCheckObjs = new BlockList();
            progressMonitor.beginTask(JGitText.get().receivingObjects, (int)this.expectedObjectCount);
            try {
                int n2 = 0;
                while ((long)n2 < this.expectedObjectCount) {
                    this.indexOneObject();
                    progressMonitor.update(1);
                    if (progressMonitor.isCancelled()) {
                        throw new IOException(JGitText.get().downloadCancelled);
                    }
                    ++n2;
                }
                this.readPackFooter();
                this.endInput();
            }
            finally {
                progressMonitor.endTask();
            }
            if (!this.collisionCheckObjs.isEmpty()) {
                this.checkObjectCollision();
            }
            if (this.deltaCount > 0) {
                this.processDeltas(progressMonitor2);
            }
            this.packDigest = null;
            this.baseById = null;
            this.baseByPos = null;
        }
        finally {
            try {
                if (this.readCurs != null) {
                    this.readCurs.close();
                }
            }
            finally {
                this.readCurs = null;
            }
            try {
                this.inflater.release();
            }
            finally {
                this.inflater = null;
            }
        }
        return null;
    }

    private void processDeltas(ProgressMonitor progressMonitor) {
        if (progressMonitor instanceof BatchingProgressMonitor) {
            ((BatchingProgressMonitor)progressMonitor).setDelayStart(1000L, TimeUnit.MILLISECONDS);
        }
        progressMonitor.beginTask(JGitText.get().resolvingDeltas, this.deltaCount);
        this.resolveDeltas(progressMonitor);
        if ((long)this.entryCount < this.expectedObjectCount) {
            if (!this.isAllowThin()) {
                throw new IOException(MessageFormat.format(JGitText.get().packHasUnresolvedDeltas, this.expectedObjectCount - (long)this.entryCount));
            }
            this.resolveDeltasWithExternalBases(progressMonitor);
            if ((long)this.entryCount < this.expectedObjectCount) {
                throw new IOException(MessageFormat.format(JGitText.get().packHasUnresolvedDeltas, this.expectedObjectCount - (long)this.entryCount));
            }
        }
        progressMonitor.endTask();
    }

    private void resolveDeltas(ProgressMonitor progressMonitor) {
        int n2 = this.entryCount;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.resolveDeltas(this.entries[i2], progressMonitor);
            if (!progressMonitor.isCancelled()) continue;
            throw new IOException(JGitText.get().downloadCancelledDuringIndexing);
        }
    }

    private void resolveDeltas(PackedObjectInfo packedObjectInfo, ProgressMonitor progressMonitor) {
        PackParser$UnresolvedDelta packParser$UnresolvedDelta = this.firstChildOf(packedObjectInfo);
        if (packParser$UnresolvedDelta == null) {
            return;
        }
        PackParser$DeltaVisit packParser$DeltaVisit = new PackParser$DeltaVisit();
        packParser$DeltaVisit.nextChild = packParser$UnresolvedDelta;
        PackParser$ObjectTypeAndSize packParser$ObjectTypeAndSize = this.openDatabase(packedObjectInfo, new PackParser$ObjectTypeAndSize());
        switch (packParser$ObjectTypeAndSize.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                packParser$DeltaVisit.data = this.inflateAndReturn(PackParser$Source.DATABASE, packParser$ObjectTypeAndSize.size);
                packParser$DeltaVisit.id = packedObjectInfo;
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, packParser$ObjectTypeAndSize.type));
            }
        }
        if (!this.checkCRC(packedObjectInfo.getCRC())) {
            throw new IOException(MessageFormat.format(JGitText.get().corruptionDetectedReReadingAt, packedObjectInfo.getOffset()));
        }
        this.resolveDeltas(packParser$DeltaVisit.next(), packParser$ObjectTypeAndSize.type, packParser$ObjectTypeAndSize, progressMonitor);
    }

    private void resolveDeltas(PackParser$DeltaVisit packParser$DeltaVisit, int n2, PackParser$ObjectTypeAndSize packParser$ObjectTypeAndSize, ProgressMonitor progressMonitor) {
        this.stats.addDeltaObject(n2);
        do {
            progressMonitor.update(1);
            packParser$ObjectTypeAndSize = this.openDatabase(packParser$DeltaVisit.delta, packParser$ObjectTypeAndSize);
            switch (packParser$ObjectTypeAndSize.type) {
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, packParser$ObjectTypeAndSize.type));
                }
            }
            byte[] byArray = this.inflateAndReturn(PackParser$Source.DATABASE, packParser$ObjectTypeAndSize.size);
            this.checkIfTooLarge(n2, BinaryDelta.getResultSize(byArray));
            packParser$DeltaVisit.data = BinaryDelta.apply(packParser$DeltaVisit.parent.data, byArray);
            byArray = null;
            if (!this.checkCRC(packParser$DeltaVisit.delta.crc)) {
                throw new IOException(MessageFormat.format(JGitText.get().corruptionDetectedReReadingAt, packParser$DeltaVisit.delta.position));
            }
            SHA1 sHA1 = this.objectHasher.reset();
            sHA1.update(Constants.encodedTypeString(n2));
            sHA1.update((byte)32);
            sHA1.update(Constants.encodeASCII(packParser$DeltaVisit.data.length));
            sHA1.update((byte)0);
            sHA1.update(packParser$DeltaVisit.data);
            sHA1.digest(this.tempObjectId);
            this.verifySafeObject(this.tempObjectId, n2, packParser$DeltaVisit.data);
            if (this.isCheckObjectCollisions() && this.readCurs.has(this.tempObjectId)) {
                this.checkObjectCollision(this.tempObjectId, n2, packParser$DeltaVisit.data, packParser$DeltaVisit.delta.sizeBeforeInflating);
            }
            PackedObjectInfo packedObjectInfo = this.newInfo(this.tempObjectId, packParser$DeltaVisit.delta, packParser$DeltaVisit.parent.id);
            packedObjectInfo.setOffset(packParser$DeltaVisit.delta.position);
            packedObjectInfo.setType(n2);
            this.onInflatedObjectData(packedObjectInfo, n2, packParser$DeltaVisit.data);
            this.addObjectAndTrack(packedObjectInfo);
            packParser$DeltaVisit.id = packedObjectInfo;
            packParser$DeltaVisit.nextChild = this.firstChildOf(packedObjectInfo);
        } while ((packParser$DeltaVisit = packParser$DeltaVisit.next()) != null);
    }

    private final void checkIfTooLarge(int n2, long l2) {
        if (0L < this.maxObjectSizeLimit && this.maxObjectSizeLimit < l2) {
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    throw new TooLargeObjectInPackException(l2, this.maxObjectSizeLimit);
                }
                case 6: 
                case 7: {
                    throw new TooLargeObjectInPackException(l2, this.maxObjectSizeLimit);
                }
            }
            throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, n2));
        }
        if (l2 > 0x7FFFFFF7L) {
            throw new TooLargeObjectInPackException(l2, 0x7FFFFFF7L);
        }
    }

    protected PackParser$ObjectTypeAndSize readObjectHeader(PackParser$ObjectTypeAndSize packParser$ObjectTypeAndSize) {
        int n2 = 0;
        int n3 = this.readFrom(PackParser$Source.DATABASE);
        this.hdrBuf[n2++] = (byte)n3;
        packParser$ObjectTypeAndSize.type = n3 >> 4 & 7;
        long l2 = n3 & 0xF;
        int n4 = 4;
        while ((n3 & 0x80) != 0) {
            n3 = this.readFrom(PackParser$Source.DATABASE);
            this.hdrBuf[n2++] = (byte)n3;
            l2 += (long)(n3 & 0x7F) << n4;
            n4 += 7;
        }
        packParser$ObjectTypeAndSize.size = l2;
        switch (packParser$ObjectTypeAndSize.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.onObjectHeader(PackParser$Source.DATABASE, this.hdrBuf, 0, n2);
                break;
            }
            case 6: {
                n3 = this.readFrom(PackParser$Source.DATABASE);
                this.hdrBuf[n2++] = (byte)n3;
                while ((n3 & 0x80) != 0) {
                    n3 = this.readFrom(PackParser$Source.DATABASE);
                    this.hdrBuf[n2++] = (byte)n3;
                }
                this.onObjectHeader(PackParser$Source.DATABASE, this.hdrBuf, 0, n2);
                break;
            }
            case 7: {
                System.arraycopy(this.buf, this.fill(PackParser$Source.DATABASE, 20), this.hdrBuf, n2, 20);
                this.use(20);
                this.onObjectHeader(PackParser$Source.DATABASE, this.hdrBuf, 0, n2 += 20);
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, packParser$ObjectTypeAndSize.type));
            }
        }
        return packParser$ObjectTypeAndSize;
    }

    private PackParser$UnresolvedDelta removeBaseById(AnyObjectId anyObjectId) {
        PackParser$DeltaChain packParser$DeltaChain = (PackParser$DeltaChain)this.baseById.get(anyObjectId);
        return packParser$DeltaChain != null ? packParser$DeltaChain.remove() : null;
    }

    private static PackParser$UnresolvedDelta reverse(PackParser$UnresolvedDelta packParser$UnresolvedDelta) {
        PackParser$UnresolvedDelta packParser$UnresolvedDelta2 = null;
        while (packParser$UnresolvedDelta != null) {
            PackParser$UnresolvedDelta packParser$UnresolvedDelta3 = packParser$UnresolvedDelta.next;
            packParser$UnresolvedDelta.next = packParser$UnresolvedDelta2;
            packParser$UnresolvedDelta2 = packParser$UnresolvedDelta;
            packParser$UnresolvedDelta = packParser$UnresolvedDelta3;
        }
        return packParser$UnresolvedDelta2;
    }

    private PackParser$UnresolvedDelta firstChildOf(PackedObjectInfo packedObjectInfo) {
        PackParser$UnresolvedDelta packParser$UnresolvedDelta = PackParser.reverse(this.removeBaseById(packedObjectInfo));
        PackParser$UnresolvedDelta packParser$UnresolvedDelta2 = PackParser.reverse((PackParser$UnresolvedDelta)this.baseByPos.remove(packedObjectInfo.getOffset()));
        if (packParser$UnresolvedDelta == null) {
            return packParser$UnresolvedDelta2;
        }
        if (packParser$UnresolvedDelta2 == null) {
            return packParser$UnresolvedDelta;
        }
        PackParser$UnresolvedDelta packParser$UnresolvedDelta3 = null;
        PackParser$UnresolvedDelta packParser$UnresolvedDelta4 = null;
        while (packParser$UnresolvedDelta != null || packParser$UnresolvedDelta2 != null) {
            PackParser$UnresolvedDelta packParser$UnresolvedDelta5;
            if (packParser$UnresolvedDelta2 == null || packParser$UnresolvedDelta != null && packParser$UnresolvedDelta.position < packParser$UnresolvedDelta2.position) {
                packParser$UnresolvedDelta5 = packParser$UnresolvedDelta;
                packParser$UnresolvedDelta = packParser$UnresolvedDelta.next;
            } else {
                packParser$UnresolvedDelta5 = packParser$UnresolvedDelta2;
                packParser$UnresolvedDelta2 = packParser$UnresolvedDelta2.next;
            }
            if (packParser$UnresolvedDelta4 != null) {
                packParser$UnresolvedDelta4.next = packParser$UnresolvedDelta5;
            } else {
                packParser$UnresolvedDelta3 = packParser$UnresolvedDelta5;
            }
            packParser$UnresolvedDelta4 = packParser$UnresolvedDelta5;
            packParser$UnresolvedDelta5.next = null;
        }
        return packParser$UnresolvedDelta3;
    }

    private void resolveDeltasWithExternalBases(ProgressMonitor progressMonitor) {
        this.growEntries(this.baseById.size());
        if (this.needBaseObjectIds) {
            this.baseObjectIds = new ObjectIdSubclassMap();
        }
        ArrayList<PackParser$DeltaChain> arrayList = new ArrayList<PackParser$DeltaChain>(64);
        for (PackParser$DeltaChain packParser$DeltaChain : this.baseById) {
            ObjectLoader objectLoader;
            if (packParser$DeltaChain.head == null) continue;
            if (this.needBaseObjectIds) {
                this.baseObjectIds.add(packParser$DeltaChain);
            }
            try {
                objectLoader = this.readCurs.open(packParser$DeltaChain);
            }
            catch (MissingObjectException missingObjectException) {
                arrayList.add(packParser$DeltaChain);
                continue;
            }
            PackParser$DeltaVisit packParser$DeltaVisit = new PackParser$DeltaVisit();
            packParser$DeltaVisit.data = objectLoader.getCachedBytes(Integer.MAX_VALUE);
            packParser$DeltaVisit.id = packParser$DeltaChain;
            int n2 = objectLoader.getType();
            PackedObjectInfo packedObjectInfo = this.newInfo(packParser$DeltaChain, null, null);
            packedObjectInfo.setType(n2);
            if (this.onAppendBase(n2, packParser$DeltaVisit.data, packedObjectInfo)) {
                this.entries[this.entryCount++] = packedObjectInfo;
            }
            packParser$DeltaVisit.nextChild = this.firstChildOf(packedObjectInfo);
            this.resolveDeltas(packParser$DeltaVisit.next(), n2, new PackParser$ObjectTypeAndSize(), progressMonitor);
            if (!progressMonitor.isCancelled()) continue;
            throw new IOException(JGitText.get().downloadCancelledDuringIndexing);
        }
        for (PackParser$DeltaChain packParser$DeltaChain : arrayList) {
            if (packParser$DeltaChain.head == null) continue;
            throw new MissingObjectException((ObjectId)packParser$DeltaChain, "delta base");
        }
        this.onEndThinPack();
    }

    private void growEntries(int n2) {
        PackedObjectInfo[] packedObjectInfoArray = new PackedObjectInfo[(int)this.expectedObjectCount + n2];
        System.arraycopy(this.entries, 0, packedObjectInfoArray, 0, this.entryCount);
        this.entries = packedObjectInfoArray;
    }

    private void readPackHeader() {
        if (this.expectDataAfterPackFooter) {
            if (!this.in.markSupported()) {
                throw new IOException(JGitText.get().inputStreamMustSupportMark);
            }
            this.in.mark(this.buf.length);
        }
        int n2 = Constants.PACK_SIGNATURE.length + 4 + 4;
        int n3 = this.fill(PackParser$Source.INPUT, n2);
        for (int i2 = 0; i2 < Constants.PACK_SIGNATURE.length; ++i2) {
            if (this.buf[n3 + i2] == Constants.PACK_SIGNATURE[i2]) continue;
            throw new IOException(JGitText.get().notAPACKFile);
        }
        long l2 = NB.decodeUInt32(this.buf, n3 + 4);
        if (l2 != 2L && l2 != 3L) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedPackVersion, l2));
        }
        long l3 = NB.decodeUInt32(this.buf, n3 + 8);
        this.use(n2);
        this.setExpectedObjectCount(l3);
        this.onPackHeader(l3);
    }

    private void readPackFooter() {
        this.sync();
        byte[] byArray = this.packDigest.digest();
        int n2 = this.fill(PackParser$Source.INPUT, 20);
        byte[] byArray2 = new byte[20];
        System.arraycopy(this.buf, n2, byArray2, 0, 20);
        this.use(20);
        if (this.bAvail != 0 && !this.expectDataAfterPackFooter) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().expectedEOFReceived, "\\x" + Integer.toHexString(this.buf[this.bOffset] & 0xFF)));
        }
        if (this.isCheckEofAfterPackFooter()) {
            int n3 = this.in.read();
            if (0 <= n3) {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().expectedEOFReceived, "\\x" + Integer.toHexString(n3)));
            }
        } else if (this.bAvail > 0 && this.expectDataAfterPackFooter) {
            this.in.reset();
            IO.skipFully(this.in, this.bOffset);
        }
        if (!Arrays.equals(byArray, byArray2)) {
            throw new CorruptObjectException(JGitText.get().corruptObjectPackfileChecksumIncorrect);
        }
        this.onPackFooter(byArray2);
    }

    private void endInput() {
        this.stats.setNumBytesRead(this.streamPosition());
        this.in = null;
    }

    private void indexOneObject() {
        long l2 = this.streamPosition();
        int n2 = 0;
        int n3 = this.readFrom(PackParser$Source.INPUT);
        this.hdrBuf[n2++] = (byte)n3;
        int n4 = n3 >> 4 & 7;
        long l3 = n3 & 0xF;
        int n5 = 4;
        while ((n3 & 0x80) != 0) {
            n3 = this.readFrom(PackParser$Source.INPUT);
            this.hdrBuf[n2++] = (byte)n3;
            l3 += (long)(n3 & 0x7F) << n5;
            n5 += 7;
        }
        this.checkIfTooLarge(n4, l3);
        switch (n4) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.stats.addWholeObject(n4);
                this.onBeginWholeObject(l2, n4, l3);
                this.onObjectHeader(PackParser$Source.INPUT, this.hdrBuf, 0, n2);
                this.whole(l2, n4, l3);
                break;
            }
            case 6: {
                this.stats.addOffsetDelta();
                n3 = this.readFrom(PackParser$Source.INPUT);
                this.hdrBuf[n2++] = (byte)n3;
                long l4 = n3 & 0x7F;
                while ((n3 & 0x80) != 0) {
                    ++l4;
                    n3 = this.readFrom(PackParser$Source.INPUT);
                    this.hdrBuf[n2++] = (byte)n3;
                    l4 <<= 7;
                    l4 += (long)(n3 & 0x7F);
                }
                long l5 = l2 - l4;
                this.onBeginOfsDelta(l2, l5, l3);
                this.onObjectHeader(PackParser$Source.INPUT, this.hdrBuf, 0, n2);
                this.inflateAndSkip(PackParser$Source.INPUT, l3);
                PackParser$UnresolvedDelta packParser$UnresolvedDelta = this.onEndDelta();
                packParser$UnresolvedDelta.position = l2;
                packParser$UnresolvedDelta.next = (PackParser$UnresolvedDelta)this.baseByPos.put(l5, packParser$UnresolvedDelta);
                packParser$UnresolvedDelta.sizeBeforeInflating = this.streamPosition() - l2;
                ++this.deltaCount;
                break;
            }
            case 7: {
                this.stats.addRefDelta();
                n3 = this.fill(PackParser$Source.INPUT, 20);
                ObjectId objectId = ObjectId.fromRaw(this.buf, n3);
                System.arraycopy(this.buf, n3, this.hdrBuf, n2, 20);
                n2 += 20;
                this.use(20);
                PackParser$DeltaChain packParser$DeltaChain = (PackParser$DeltaChain)this.baseById.get(objectId);
                if (packParser$DeltaChain == null) {
                    packParser$DeltaChain = new PackParser$DeltaChain(objectId);
                    this.baseById.add(packParser$DeltaChain);
                }
                this.onBeginRefDelta(l2, objectId, l3);
                this.onObjectHeader(PackParser$Source.INPUT, this.hdrBuf, 0, n2);
                this.inflateAndSkip(PackParser$Source.INPUT, l3);
                PackParser$UnresolvedDelta packParser$UnresolvedDelta = this.onEndDelta();
                packParser$UnresolvedDelta.position = l2;
                packParser$UnresolvedDelta.sizeBeforeInflating = this.streamPosition() - l2;
                packParser$DeltaChain.add(packParser$UnresolvedDelta);
                ++this.deltaCount;
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, n4));
            }
        }
    }

    private void whole(long l2, int n2, long l3) {
        byte[] byArray;
        SHA1 sHA1 = this.objectHasher.reset();
        sHA1.update(Constants.encodedTypeString(n2));
        sHA1.update((byte)32);
        sHA1.update(Constants.encodeASCII(l3));
        sHA1.update((byte)0);
        if (n2 == 3) {
            byte[] byArray2 = this.buffer();
            BlobObjectChecker blobObjectChecker = null;
            if (this.objCheck != null) {
                blobObjectChecker = this.objCheck.newBlobObjectChecker();
            }
            if (blobObjectChecker == null) {
                blobObjectChecker = BlobObjectChecker.NULL_CHECKER;
            }
            try (InputStream inputStream = this.inflate(PackParser$Source.INPUT, l3);){
                int n3;
                for (long i2 = 0L; i2 < l3; i2 += (long)n3) {
                    n3 = inputStream.read(byArray2);
                    if (n3 <= 0) {
                        break;
                    }
                    sHA1.update(byArray2, 0, n3);
                    blobObjectChecker.update(byArray2, 0, n3);
                }
            }
            sHA1.digest(this.tempObjectId);
            blobObjectChecker.endBlob(this.tempObjectId);
            byArray = null;
        } else {
            byArray = this.inflateAndReturn(PackParser$Source.INPUT, l3);
            sHA1.update(byArray);
            sHA1.digest(this.tempObjectId);
            this.verifySafeObject(this.tempObjectId, n2, byArray);
        }
        long l4 = this.streamPosition() - l2;
        PackedObjectInfo packedObjectInfo = this.newInfo(this.tempObjectId, null, null);
        packedObjectInfo.setOffset(l2);
        packedObjectInfo.setType(n2);
        packedObjectInfo.setSize(l4);
        this.onEndWholeObject(packedObjectInfo);
        if (byArray != null) {
            this.onInflatedObjectData(packedObjectInfo, n2, byArray);
        }
        this.addObjectAndTrack(packedObjectInfo);
        if (this.isCheckObjectCollisions()) {
            this.collisionCheckObjs.add(packedObjectInfo);
        }
    }

    protected void verifySafeObject(AnyObjectId anyObjectId, int n2, byte[] byArray) {
        if (this.objCheck != null) {
            try {
                this.objCheck.check(anyObjectId, n2, byArray);
            }
            catch (CorruptObjectException corruptObjectException) {
                if (corruptObjectException.getErrorType() != null) {
                    throw corruptObjectException;
                }
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().invalidObject, Constants.typeString(n2), anyObjectId.name(), corruptObjectException.getMessage()), corruptObjectException);
            }
        }
    }

    private void checkObjectCollision() {
        for (PackedObjectInfo packedObjectInfo : this.collisionCheckObjs) {
            if (!this.readCurs.has(packedObjectInfo)) continue;
            this.checkObjectCollision(packedObjectInfo);
        }
    }

    private void checkObjectCollision(PackedObjectInfo packedObjectInfo) {
        PackParser$ObjectTypeAndSize packParser$ObjectTypeAndSize = this.openDatabase(packedObjectInfo, new PackParser$ObjectTypeAndSize());
        byte[] byArray = this.buffer();
        byte[] byArray2 = new byte[byArray.length];
        try (ObjectStream objectStream = this.readCurs.open(packedObjectInfo, packParser$ObjectTypeAndSize.type).openStream();){
            long l2;
            if (objectStream.getSize() != l2) {
                throw new IOException(MessageFormat.format(JGitText.get().collisionOn, packedObjectInfo.name()));
            }
            try (InputStream inputStream = this.inflate(PackParser$Source.DATABASE, l2);){
                int n2;
                for (l2 = packParser$ObjectTypeAndSize.size; 0L < l2; l2 -= (long)n2) {
                    n2 = (int)Math.min((long)byArray.length, l2);
                    IO.readFully(objectStream, byArray2, 0, n2);
                    IO.readFully(inputStream, byArray, 0, n2);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (byArray2[i2] == byArray[i2]) continue;
                        throw new IOException(MessageFormat.format(JGitText.get().collisionOn, packedObjectInfo.name()));
                    }
                }
            }
            this.stats.incrementObjectsDuplicated();
            this.stats.incrementNumBytesDuplicated(packedObjectInfo.getSize());
        }
        catch (MissingObjectException missingObjectException) {
            // empty catch block
        }
    }

    private void checkObjectCollision(AnyObjectId anyObjectId, int n2, byte[] byArray, long l2) {
        try {
            ObjectLoader objectLoader = this.readCurs.open(anyObjectId, n2);
            byte[] byArray2 = objectLoader.getCachedBytes(byArray.length);
            if (!Arrays.equals(byArray, byArray2)) {
                throw new IOException(MessageFormat.format(JGitText.get().collisionOn, anyObjectId.name()));
            }
            this.stats.incrementObjectsDuplicated();
            this.stats.incrementNumBytesDuplicated(l2);
        }
        catch (MissingObjectException missingObjectException) {
            // empty catch block
        }
    }

    private long streamPosition() {
        return this.bBase + (long)this.bOffset;
    }

    private PackParser$ObjectTypeAndSize openDatabase(PackedObjectInfo packedObjectInfo, PackParser$ObjectTypeAndSize packParser$ObjectTypeAndSize) {
        this.bOffset = 0;
        this.bAvail = 0;
        return this.seekDatabase(packedObjectInfo, packParser$ObjectTypeAndSize);
    }

    private PackParser$ObjectTypeAndSize openDatabase(PackParser$UnresolvedDelta packParser$UnresolvedDelta, PackParser$ObjectTypeAndSize packParser$ObjectTypeAndSize) {
        this.bOffset = 0;
        this.bAvail = 0;
        return this.seekDatabase(packParser$UnresolvedDelta, packParser$ObjectTypeAndSize);
    }

    private int readFrom(PackParser$Source packParser$Source) {
        if (this.bAvail == 0) {
            this.fill(packParser$Source, 1);
        }
        --this.bAvail;
        return this.buf[this.bOffset++] & 0xFF;
    }

    void use(int n2) {
        this.bOffset += n2;
        this.bAvail -= n2;
    }

    int fill(PackParser$Source packParser$Source, int n2) {
        while (this.bAvail < n2) {
            int n3 = this.bOffset + this.bAvail;
            int n4 = this.buf.length - n3;
            if (n4 + this.bAvail < n2) {
                switch (packParser$Source) {
                    case INPUT: {
                        this.sync();
                        break;
                    }
                    case DATABASE: {
                        if (this.bAvail > 0) {
                            System.arraycopy(this.buf, this.bOffset, this.buf, 0, this.bAvail);
                        }
                        this.bOffset = 0;
                    }
                }
                n3 = this.bAvail;
                n4 = this.buf.length - n3;
            }
            switch (packParser$Source) {
                case INPUT: {
                    n3 = this.in.read(this.buf, n3, n4);
                    break;
                }
                case DATABASE: {
                    n3 = this.readDatabase(this.buf, n3, n4);
                }
            }
            if (n3 <= 0) {
                throw new EOFException(JGitText.get().packfileIsTruncatedNoParam);
            }
            this.bAvail += n3;
        }
        return this.bOffset;
    }

    private void sync() {
        this.packDigest.update(this.buf, 0, this.bOffset);
        this.onStoreStream(this.buf, 0, this.bOffset);
        if (this.expectDataAfterPackFooter) {
            if (this.bAvail > 0) {
                this.in.reset();
                IO.skipFully(this.in, this.bOffset);
                this.bAvail = 0;
            }
            this.in.mark(this.buf.length);
        } else if (this.bAvail > 0) {
            System.arraycopy(this.buf, this.bOffset, this.buf, 0, this.bAvail);
        }
        this.bBase += (long)this.bOffset;
        this.bOffset = 0;
    }

    protected byte[] buffer() {
        return this.tempBuffer;
    }

    protected PackedObjectInfo newInfo(AnyObjectId anyObjectId, PackParser$UnresolvedDelta packParser$UnresolvedDelta, ObjectId objectId) {
        PackedObjectInfo packedObjectInfo = new PackedObjectInfo(anyObjectId);
        if (packParser$UnresolvedDelta != null) {
            packedObjectInfo.setCRC(packParser$UnresolvedDelta.crc);
        }
        return packedObjectInfo;
    }

    protected void setExpectedObjectCount(long l2) {
        this.expectedObjectCount = l2;
    }

    protected abstract void onStoreStream(byte[] var1, int var2, int var3);

    protected abstract void onObjectHeader(PackParser$Source var1, byte[] var2, int var3, int var4);

    protected abstract void onObjectData(PackParser$Source var1, byte[] var2, int var3, int var4);

    protected abstract void onInflatedObjectData(PackedObjectInfo var1, int var2, byte[] var3);

    protected abstract void onPackHeader(long var1);

    protected abstract void onPackFooter(byte[] var1);

    protected abstract boolean onAppendBase(int var1, byte[] var2, PackedObjectInfo var3);

    protected abstract void onEndThinPack();

    protected abstract PackParser$ObjectTypeAndSize seekDatabase(PackedObjectInfo var1, PackParser$ObjectTypeAndSize var2);

    protected abstract PackParser$ObjectTypeAndSize seekDatabase(PackParser$UnresolvedDelta var1, PackParser$ObjectTypeAndSize var2);

    protected abstract int readDatabase(byte[] var1, int var2, int var3);

    protected abstract boolean checkCRC(int var1);

    protected abstract void onBeginWholeObject(long var1, int var3, long var4);

    protected abstract void onEndWholeObject(PackedObjectInfo var1);

    protected abstract void onBeginOfsDelta(long var1, long var3, long var5);

    protected abstract void onBeginRefDelta(long var1, AnyObjectId var3, long var4);

    protected PackParser$UnresolvedDelta onEndDelta() {
        return new PackParser$UnresolvedDelta();
    }

    private void inflateAndSkip(PackParser$Source packParser$Source, long l2) {
        try (InputStream inputStream = this.inflate(packParser$Source, l2);){
            IO.skipFully(inputStream, l2);
        }
    }

    private byte[] inflateAndReturn(PackParser$Source packParser$Source, long l2) {
        byte[] byArray = new byte[(int)l2];
        try (InputStream inputStream = this.inflate(packParser$Source, l2);){
            IO.readFully(inputStream, byArray, 0, byArray.length);
        }
        return byArray;
    }

    private InputStream inflate(PackParser$Source packParser$Source, long l2) {
        this.inflater.open(packParser$Source, l2);
        return this.inflater;
    }

    private void addObjectAndTrack(PackedObjectInfo packedObjectInfo) {
        this.entries[this.entryCount++] = packedObjectInfo;
        if (this.needNewObjectIds()) {
            this.newObjectIds.add(packedObjectInfo);
        }
    }
}

