/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.transport.PackParser;

class PackParser$InflaterStream
extends InputStream {
    private final Inflater inf = InflaterCache.get();
    private final byte[] skipBuffer = new byte[512];
    private PackParser.Source src;
    private long expectedSize;
    private long actualSize;
    private int p;
    final /* synthetic */ PackParser this$0;

    PackParser$InflaterStream(PackParser packParser) {
        this.this$0 = packParser;
    }

    void release() {
        this.inf.reset();
        InflaterCache.release(this.inf);
    }

    void open(PackParser.Source source, long l2) {
        this.src = source;
        this.expectedSize = l2;
        this.actualSize = 0L;
        this.p = this.this$0.fill(this.src, 1);
        this.inf.setInput(this.this$0.buf, this.p, this.this$0.bAvail);
    }

    @Override
    public long skip(long l2) {
        int n2;
        long l3;
        int n3;
        for (l3 = 0L; l3 < l2 && (n3 = this.read(this.skipBuffer, 0, n2 = (int)Math.min((long)this.skipBuffer.length, l2 - l3))) > 0; l3 += (long)n3) {
        }
        return l3;
    }

    @Override
    public int read() {
        int n2 = this.read(this.skipBuffer, 0, 1);
        return n2 == 1 ? this.skipBuffer[0] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        try {
            int n4;
            int n5;
            for (n4 = 0; n4 < n3; n4 += n5) {
                n5 = this.inf.inflate(byArray, n2 + n4, n3 - n4);
                if (this.inf.finished()) break;
                if (!this.inf.needsInput()) continue;
                this.this$0.onObjectData(this.src, this.this$0.buf, this.p, this.this$0.bAvail);
                this.this$0.use(this.this$0.bAvail);
                this.p = this.this$0.fill(this.src, 1);
                this.inf.setInput(this.this$0.buf, this.p, this.this$0.bAvail);
            }
            this.actualSize += (long)n4;
            return 0 < n4 ? n4 : -1;
        }
        catch (DataFormatException dataFormatException) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().packfileCorruptionDetected, dataFormatException.getMessage()));
        }
    }

    @Override
    public void close() {
        if (this.read(this.skipBuffer) != -1 || this.actualSize != this.expectedSize) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().packfileCorruptionDetected, JGitText.get().wrongDecompressedLength));
        }
        int n2 = this.this$0.bAvail - this.inf.getRemaining();
        if (0 < n2) {
            this.this$0.onObjectData(this.src, this.this$0.buf, this.p, n2);
            this.this$0.use(n2);
        }
        this.inf.reset();
    }
}

