/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.URIish;

public abstract class OperationResult {
    Map advertisedRefs = Collections.emptyMap();
    URIish uri;
    final SortedMap updates = new TreeMap();
    StringBuilder messageBuffer;
    String peerUserAgent;

    public URIish getURI() {
        return this.uri;
    }

    public Collection getAdvertisedRefs() {
        return Collections.unmodifiableCollection(this.advertisedRefs.values());
    }

    public final Ref getAdvertisedRef(String string) {
        return (Ref)this.advertisedRefs.get(string);
    }

    public Collection getTrackingRefUpdates() {
        return Collections.unmodifiableCollection(this.updates.values());
    }

    public TrackingRefUpdate getTrackingRefUpdate(String string) {
        return (TrackingRefUpdate)this.updates.get(string);
    }

    void setAdvertisedRefs(URIish uRIish, Map map) {
        this.uri = uRIish;
        this.advertisedRefs = map;
    }

    void add(TrackingRefUpdate trackingRefUpdate) {
        this.updates.put(trackingRefUpdate.getLocalName(), trackingRefUpdate);
    }

    public String getMessages() {
        return this.messageBuffer != null ? this.messageBuffer.toString() : "";
    }

    void addMessages(String string) {
        if (string != null && string.length() > 0) {
            if (this.messageBuffer == null) {
                this.messageBuffer = new StringBuilder();
            }
            this.messageBuffer.append(string);
            if (!string.endsWith("\n")) {
                this.messageBuffer.append('\n');
            }
        }
    }

    public String getPeerUserAgent() {
        return this.peerUserAgent;
    }
}

