/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialItem$Password;
import org.eclipse.jgit.transport.CredentialItem$StringType;
import org.eclipse.jgit.transport.CredentialItem$Username;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.NetRC;
import org.eclipse.jgit.transport.NetRC$NetRCEntry;
import org.eclipse.jgit.transport.URIish;

public class NetRCCredentialsProvider
extends CredentialsProvider {
    NetRC netrc = new NetRC();

    public static void install() {
        CredentialsProvider.setDefault(new NetRCCredentialsProvider());
    }

    @Override
    public boolean supports(CredentialItem ... credentialItemArray) {
        for (CredentialItem credentialItem : credentialItemArray) {
            if (credentialItem instanceof CredentialItem$Username || credentialItem instanceof CredentialItem$Password) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean get(URIish uRIish, CredentialItem ... credentialItemArray) {
        NetRC$NetRCEntry netRC$NetRCEntry = this.netrc.getEntry(uRIish.getHost());
        if (netRC$NetRCEntry == null) {
            return false;
        }
        for (CredentialItem credentialItem : credentialItemArray) {
            if (credentialItem instanceof CredentialItem$Username) {
                ((CredentialItem$Username)credentialItem).setValue(netRC$NetRCEntry.login);
                continue;
            }
            if (credentialItem instanceof CredentialItem$Password) {
                ((CredentialItem$Password)credentialItem).setValue(netRC$NetRCEntry.password);
                continue;
            }
            if (credentialItem instanceof CredentialItem$StringType && credentialItem.getPromptText().equals("Password: ")) {
                ((CredentialItem$StringType)credentialItem).setValue(new String(netRC$NetRCEntry.password));
                continue;
            }
            throw new UnsupportedCredentialItem(uRIish, credentialItem.getClass().getName() + ":" + credentialItem.getPromptText());
        }
        return !NetRCCredentialsProvider.isAnyNull(credentialItemArray);
    }

    @Override
    public boolean isInteractive() {
        return false;
    }
}

