/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.transport.NetRC$1;
import org.eclipse.jgit.transport.NetRC$NetRCEntry;
import org.eclipse.jgit.transport.NetRC$State;
import org.eclipse.jgit.util.FS;

public class NetRC {
    static final Pattern NETRC = Pattern.compile("(\\S+)");
    static final String DEFAULT_ENTRY = "default";
    private File netrc;
    private Instant lastModified;
    private Map hosts = new HashMap();
    private static final TreeMap STATE = new NetRC$1();

    public NetRC() {
        this.netrc = NetRC.getDefaultFile();
        if (this.netrc != null) {
            this.parse();
        }
    }

    public NetRC(File file) {
        this.netrc = file;
        this.parse();
    }

    private static File getDefaultFile() {
        File file = FS.DETECTED.userHome();
        File file2 = new File(file, ".netrc");
        if (file2.exists()) {
            return file2;
        }
        file2 = new File(file, "_netrc");
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    public NetRC$NetRCEntry getEntry(String string) {
        NetRC$NetRCEntry netRC$NetRCEntry;
        if (this.netrc == null) {
            return null;
        }
        if (!this.lastModified.equals(FS.DETECTED.lastModifiedInstant(this.netrc))) {
            this.parse();
        }
        if ((netRC$NetRCEntry = (NetRC$NetRCEntry)this.hosts.get(string)) == null) {
            netRC$NetRCEntry = (NetRC$NetRCEntry)this.hosts.get(DEFAULT_ENTRY);
        }
        return netRC$NetRCEntry;
    }

    public Collection getEntries() {
        return this.hosts.values();
    }

    private void parse() {
        this.hosts.clear();
        this.lastModified = FS.DETECTED.lastModifiedInstant(this.netrc);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.netrc), StandardCharsets.UTF_8));){
            String string = null;
            NetRC$NetRCEntry netRC$NetRCEntry = new NetRC$NetRCEntry();
            NetRC$State netRC$State = NetRC$State.COMMAND;
            String string2 = "";
            Matcher matcher = NETRC.matcher("");
            while ((string = bufferedReader.readLine()) != null) {
                if (netRC$NetRCEntry.macdef != null && netRC$NetRCEntry.macbody == null) {
                    if (string.length() == 0) {
                        netRC$NetRCEntry.macbody = string2;
                        string2 = "";
                        continue;
                    }
                    string2 = string2 + string + "\n";
                    continue;
                }
                matcher.reset(string);
                while (matcher.find()) {
                    String string3 = matcher.group().toLowerCase(Locale.ROOT);
                    if (string3.startsWith("#")) {
                        matcher.reset("");
                        continue;
                    }
                    netRC$State = (NetRC$State)((Object)STATE.get(string3));
                    if (netRC$State == null) {
                        netRC$State = NetRC$State.COMMAND;
                    }
                    switch (netRC$State) {
                        case COMMAND: {
                            break;
                        }
                        case ACCOUNT: {
                            if (netRC$NetRCEntry.account != null && netRC$NetRCEntry.complete()) {
                                this.hosts.put(netRC$NetRCEntry.machine, netRC$NetRCEntry);
                                netRC$NetRCEntry = new NetRC$NetRCEntry();
                            }
                            if (matcher.find()) {
                                netRC$NetRCEntry.account = matcher.group();
                            }
                            netRC$State = NetRC$State.COMMAND;
                            break;
                        }
                        case LOGIN: {
                            if (netRC$NetRCEntry.login != null && netRC$NetRCEntry.complete()) {
                                this.hosts.put(netRC$NetRCEntry.machine, netRC$NetRCEntry);
                                netRC$NetRCEntry = new NetRC$NetRCEntry();
                            }
                            if (matcher.find()) {
                                netRC$NetRCEntry.login = matcher.group();
                            }
                            netRC$State = NetRC$State.COMMAND;
                            break;
                        }
                        case PASSWORD: {
                            if (netRC$NetRCEntry.password != null && netRC$NetRCEntry.complete()) {
                                this.hosts.put(netRC$NetRCEntry.machine, netRC$NetRCEntry);
                                netRC$NetRCEntry = new NetRC$NetRCEntry();
                            }
                            if (matcher.find()) {
                                netRC$NetRCEntry.password = matcher.group().toCharArray();
                            }
                            netRC$State = NetRC$State.COMMAND;
                            break;
                        }
                        case DEFAULT: {
                            if (netRC$NetRCEntry.machine != null && netRC$NetRCEntry.complete()) {
                                this.hosts.put(netRC$NetRCEntry.machine, netRC$NetRCEntry);
                                netRC$NetRCEntry = new NetRC$NetRCEntry();
                            }
                            netRC$NetRCEntry.machine = DEFAULT_ENTRY;
                            netRC$State = NetRC$State.COMMAND;
                            break;
                        }
                        case MACDEF: {
                            if (netRC$NetRCEntry.macdef != null && netRC$NetRCEntry.complete()) {
                                this.hosts.put(netRC$NetRCEntry.machine, netRC$NetRCEntry);
                                netRC$NetRCEntry = new NetRC$NetRCEntry();
                            }
                            if (matcher.find()) {
                                netRC$NetRCEntry.macdef = matcher.group();
                            }
                            netRC$State = NetRC$State.COMMAND;
                            break;
                        }
                        case MACHINE: {
                            if (netRC$NetRCEntry.machine != null && netRC$NetRCEntry.complete()) {
                                this.hosts.put(netRC$NetRCEntry.machine, netRC$NetRCEntry);
                                netRC$NetRCEntry = new NetRC$NetRCEntry();
                            }
                            if (matcher.find()) {
                                netRC$NetRCEntry.machine = matcher.group();
                            }
                            netRC$State = NetRC$State.COMMAND;
                        }
                    }
                }
            }
            if (netRC$NetRCEntry.macdef != null && netRC$NetRCEntry.macbody == null) {
                netRC$NetRCEntry.macbody = string2;
            }
            if (netRC$NetRCEntry.complete()) {
                this.hosts.put(netRC$NetRCEntry.machine, netRC$NetRCEntry);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

