/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.HttpConfig$1;
import org.eclipse.jgit.transport.HttpConfig$HttpRedirectMode;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UserAgent;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConfig {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConfig.class);
    private static final String FTP = "ftp";
    public static final String HTTP = "http";
    public static final String FOLLOW_REDIRECTS_KEY = "followRedirects";
    public static final String MAX_REDIRECTS_KEY = "maxRedirects";
    public static final String POST_BUFFER_KEY = "postBuffer";
    public static final String SSL_VERIFY_KEY = "sslVerify";
    public static final String USER_AGENT = "userAgent";
    public static final String EXTRA_HEADER = "extraHeader";
    public static final String COOKIE_FILE_KEY = "cookieFile";
    public static final String SAVE_COOKIES_KEY = "saveCookies";
    public static final String COOKIE_FILE_CACHE_LIMIT_KEY = "cookieFileCacheLimit";
    private static final int DEFAULT_COOKIE_FILE_CACHE_LIMIT = 10;
    private static final String MAX_REDIRECT_SYSTEM_PROPERTY = "http.maxRedirects";
    private static final int DEFAULT_MAX_REDIRECTS = 5;
    private static final int MAX_REDIRECTS = new HttpConfig$1().get();
    private static final String ENV_HTTP_USER_AGENT = "GIT_HTTP_USER_AGENT";
    private int postBuffer;
    private boolean sslVerify;
    private HttpConfig$HttpRedirectMode followRedirects;
    private int maxRedirects;
    private String userAgent;
    private List extraHeaders;
    private String cookieFile;
    private boolean saveCookies;
    private int cookieFileCacheLimit;

    public int getPostBuffer() {
        return this.postBuffer;
    }

    public boolean isSslVerify() {
        return this.sslVerify;
    }

    public HttpConfig$HttpRedirectMode getFollowRedirects() {
        return this.followRedirects;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    @NonNull
    public List getExtraHeaders() {
        return this.extraHeaders == null ? Collections.emptyList() : this.extraHeaders;
    }

    public String getCookieFile() {
        return this.cookieFile;
    }

    public boolean getSaveCookies() {
        return this.saveCookies;
    }

    public int getCookieFileCacheLimit() {
        return this.cookieFileCacheLimit;
    }

    public HttpConfig(Config config, URIish uRIish) {
        this.init(config, uRIish);
    }

    public HttpConfig(URIish uRIish) {
        StoredConfig storedConfig = null;
        try {
            storedConfig = SystemReader.getInstance().getUserConfig();
        }
        catch (IOException | ConfigInvalidException exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            this.init(new Config(), uRIish);
            return;
        }
        this.init(storedConfig, uRIish);
    }

    private void init(Config config, URIish uRIish) {
        String string;
        int n2 = config.getInt(HTTP, POST_BUFFER_KEY, 0x100000);
        boolean bl2 = config.getBoolean(HTTP, SSL_VERIFY_KEY, true);
        HttpConfig$HttpRedirectMode httpConfig$HttpRedirectMode = (HttpConfig$HttpRedirectMode)config.getEnum(HttpConfig$HttpRedirectMode.values(), HTTP, null, FOLLOW_REDIRECTS_KEY, HttpConfig$HttpRedirectMode.INITIAL);
        int n3 = config.getInt(HTTP, MAX_REDIRECTS_KEY, MAX_REDIRECTS);
        if (n3 < 0) {
            n3 = MAX_REDIRECTS;
        }
        if ((string = config.getString(HTTP, null, USER_AGENT)) != null) {
            string = UserAgent.clean(string);
        }
        this.userAgent = string;
        String[] stringArray = config.getStringList(HTTP, null, EXTRA_HEADER);
        int n4 = this.findLastEmpty(stringArray) + 1;
        if (n4 > 0) {
            stringArray = Arrays.copyOfRange(stringArray, n4, stringArray.length);
        }
        this.extraHeaders = Arrays.asList(stringArray);
        this.cookieFile = config.getString(HTTP, null, COOKIE_FILE_KEY);
        this.saveCookies = config.getBoolean(HTTP, SAVE_COOKIES_KEY, false);
        this.cookieFileCacheLimit = config.getInt(HTTP, COOKIE_FILE_CACHE_LIMIT_KEY, 10);
        String string2 = this.findMatch(config.getSubsections(HTTP), uRIish);
        if (string2 != null) {
            String string3;
            String[] stringArray2;
            String string4;
            n2 = config.getInt(HTTP, string2, POST_BUFFER_KEY, n2);
            bl2 = config.getBoolean(HTTP, string2, SSL_VERIFY_KEY, bl2);
            httpConfig$HttpRedirectMode = (HttpConfig$HttpRedirectMode)config.getEnum(HttpConfig$HttpRedirectMode.values(), HTTP, string2, FOLLOW_REDIRECTS_KEY, httpConfig$HttpRedirectMode);
            int n5 = config.getInt(HTTP, string2, MAX_REDIRECTS_KEY, n3);
            if (n5 >= 0) {
                n3 = n5;
            }
            if ((string4 = config.getString(HTTP, string2, USER_AGENT)) != null) {
                this.userAgent = UserAgent.clean(string4);
            }
            if ((stringArray2 = config.getStringList(HTTP, string2, EXTRA_HEADER)).length > 0) {
                n4 = this.findLastEmpty(stringArray2) + 1;
                if (n4 > 0) {
                    stringArray2 = Arrays.copyOfRange(stringArray2, n4, stringArray2.length);
                }
                this.extraHeaders = Arrays.asList(stringArray2);
            }
            if ((string3 = config.getString(HTTP, string2, COOKIE_FILE_KEY)) != null) {
                this.cookieFile = string3;
            }
            this.saveCookies = config.getBoolean(HTTP, string2, SAVE_COOKIES_KEY, this.saveCookies);
        }
        if (!StringUtils.isEmptyOrNull(string = SystemReader.getInstance().getenv(ENV_HTTP_USER_AGENT))) {
            this.userAgent = UserAgent.clean(string);
        }
        this.postBuffer = n2;
        this.sslVerify = bl2;
        this.followRedirects = httpConfig$HttpRedirectMode;
        this.maxRedirects = n3;
    }

    private int findLastEmpty(String[] stringArray) {
        for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
            if (stringArray[i2] != null) continue;
            return i2;
        }
        return -1;
    }

    private String findMatch(Set set, URIish uRIish) {
        boolean bl2;
        String string = null;
        int n2 = -1;
        boolean bl3 = false;
        String string2 = uRIish.getPath();
        boolean bl4 = bl2 = !StringUtils.isEmptyOrNull(string2);
        if (bl2 && (string2 = HttpConfig.normalize(string2)) == null) {
            return null;
        }
        for (String string3 : set) {
            try {
                URIish uRIish2 = new URIish(string3);
                if (!this.compare(uRIish.getScheme(), uRIish2.getScheme()) || !this.compare(uRIish.getHost(), uRIish2.getHost()) || this.defaultedPort(uRIish.getPort(), uRIish.getScheme()) != this.defaultedPort(uRIish2.getPort(), uRIish2.getScheme())) continue;
                boolean bl5 = false;
                if (uRIish2.getUser() != null) {
                    if (!uRIish2.getUser().equals(uRIish.getUser())) continue;
                    bl5 = true;
                }
                String string4 = uRIish2.getPath();
                int n3 = -1;
                if (StringUtils.isEmptyOrNull(string4)) {
                    n3 = 0;
                } else if (!bl2 || (n3 = HttpConfig.segmentCompare(string2, string4)) < 0) continue;
                if (n3 <= n2 && (bl3 || !bl5 || n3 < 0 || n3 != n2)) continue;
                string = string3;
                n2 = n3;
                bl3 = bl5;
            }
            catch (URISyntaxException uRISyntaxException) {
                LOG.warn(MessageFormat.format(JGitText.get().httpConfigInvalidURL, string3));
            }
        }
        return string;
    }

    private boolean compare(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equalsIgnoreCase(string2);
    }

    private int defaultedPort(int n2, String string) {
        if (n2 >= 0) {
            return n2;
        }
        if (FTP.equalsIgnoreCase(string)) {
            return 21;
        }
        if (HTTP.equalsIgnoreCase(string)) {
            return 80;
        }
        return 443;
    }

    static int segmentCompare(String string, String string2) {
        String string3 = HttpConfig.normalize(string2);
        if (string3 == null || !string.startsWith(string3)) {
            return -1;
        }
        int n2 = string.length();
        int n3 = string3.length();
        if (n3 == n2 || string3.charAt(n3 - 1) == '/' || n3 < n2 && string.charAt(n3) == '/') {
            return n3;
        }
        return -1;
    }

    static String normalize(String string) {
        int n2 = 0;
        int n3 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n3);
        stringBuilder.append('/');
        if (n3 > 0 && string.charAt(0) == '/') {
            n2 = 1;
        }
        while (n2 < n3) {
            int n4 = string.indexOf(47, n2);
            if (n4 < 0) {
                n4 = n3;
            }
            if (n4 != n2 && (n4 != n2 + 1 || string.charAt(n2) != '.')) {
                if (n4 == n2 + 2 && string.charAt(n2) == '.' && string.charAt(n2 + 1) == '.') {
                    int n5;
                    for (n5 = stringBuilder.length() - 2; n5 >= 0 && stringBuilder.charAt(n5) != '/'; --n5) {
                    }
                    if (n5 < 0) {
                        LOG.warn(MessageFormat.format(JGitText.get().httpConfigCannotNormalizeURL, string));
                        return null;
                    }
                    stringBuilder.setLength(n5 + 1);
                } else {
                    stringBuilder.append(string, n2, Math.min(n3, n4 + 1));
                }
            }
            n2 = n4 + 1;
        }
        if (stringBuilder.length() > 1 && stringBuilder.charAt(stringBuilder.length() - 1) == '/' && n3 > 0 && string.charAt(n3 - 1) != '/') {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

