/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jgit.transport.CredentialItem$Password;
import org.eclipse.jgit.transport.CredentialItem$Username;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.HttpAuthMethod$Type;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.http.HttpConnection;

abstract class HttpAuthMethod {
    static final String EMPTY_STRING = "";
    static final String SCHEMA_NAME_SEPARATOR = " ";
    protected final HttpAuthMethod$Type type;

    static HttpAuthMethod scanResponse(HttpConnection httpConnection, Collection collection) {
        Map map = httpConnection.getHeaderFields();
        HttpAuthMethod httpAuthMethod = HttpAuthMethod$Type.NONE.method(EMPTY_STRING);
        for (Map.Entry entry : map.entrySet()) {
            if (!"WWW-Authenticate".equalsIgnoreCase((String)entry.getKey())) continue;
            if (entry.getValue() == null) break;
            for (String string : (List)entry.getValue()) {
                if (string == null || string.length() == 0) continue;
                String[] stringArray = string.split(SCHEMA_NAME_SEPARATOR, 2);
                try {
                    HttpAuthMethod$Type httpAuthMethod$Type = HttpAuthMethod$Type.valueOf(stringArray[0].toUpperCase(Locale.ROOT));
                    if (collection != null && collection.contains((Object)httpAuthMethod$Type) || httpAuthMethod.getType().compareTo(httpAuthMethod$Type) >= 0) continue;
                    String string2 = stringArray.length == 1 ? EMPTY_STRING : stringArray[1];
                    httpAuthMethod = httpAuthMethod$Type.method(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return httpAuthMethod;
    }

    protected HttpAuthMethod(HttpAuthMethod$Type httpAuthMethod$Type) {
        this.type = httpAuthMethod$Type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean authorize(URIish uRIish, CredentialsProvider credentialsProvider) {
        String string;
        String string2;
        if (credentialsProvider != null) {
            CredentialItem$Username credentialItem$Username = new CredentialItem$Username();
            CredentialItem$Password credentialItem$Password = new CredentialItem$Password();
            if (!credentialsProvider.supports(credentialItem$Username, credentialItem$Password) || !credentialsProvider.get(uRIish, credentialItem$Username, credentialItem$Password)) return false;
            string2 = credentialItem$Username.getValue();
            char[] cArray = credentialItem$Password.getValue();
            string = cArray == null ? null : new String(credentialItem$Password.getValue());
            credentialItem$Password.clear();
        } else {
            string2 = uRIish.getUser();
            string = uRIish.getPass();
        }
        if (string2 == null) return false;
        this.authorize(string2, string);
        return true;
    }

    abstract void authorize(String var1, String var2);

    abstract void configureRequest(HttpConnection var1);

    public HttpAuthMethod$Type getType() {
        return this.type;
    }
}

