/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.util.Locale;
import org.eclipse.jgit.transport.HttpAuthMethod;
import org.eclipse.jgit.transport.HttpAuthMethod$Type;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.util.Base64;
import org.eclipse.jgit.util.GSSManagerFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class HttpAuthMethod$Negotiate
extends HttpAuthMethod {
    private static final GSSManagerFactory GSS_MANAGER_FACTORY = GSSManagerFactory.detect();
    private static final Oid OID;
    private final byte[] prevToken;

    public HttpAuthMethod$Negotiate(String string) {
        super(HttpAuthMethod$Type.NEGOTIATE);
        this.prevToken = Base64.decode(string);
    }

    @Override
    void authorize(String string, String string2) {
    }

    @Override
    void configureRequest(HttpConnection httpConnection) {
        GSSManager gSSManager = GSS_MANAGER_FACTORY.newInstance(httpConnection.getURL());
        String string = httpConnection.getURL().getHost();
        String string2 = "HTTP@" + string.toLowerCase(Locale.ROOT);
        try {
            GSSName gSSName = gSSManager.createName(string2, GSSName.NT_HOSTBASED_SERVICE);
            GSSContext gSSContext = gSSManager.createContext(gSSName, OID, null, 0);
            gSSContext.requestCredDeleg(true);
            byte[] byArray = gSSContext.initSecContext(this.prevToken, 0, this.prevToken.length);
            httpConnection.setRequestProperty("Authorization", this.getType().getSchemeName() + " " + Base64.encodeBytes(byArray));
        }
        catch (GSSException gSSException) {
            throw new IOException(gSSException);
        }
    }

    static {
        try {
            OID = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException gSSException) {
            throw new Error("Cannot create NEGOTIATE oid.", gSSException);
        }
    }
}

