/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jgit.transport.HttpAuthMethod;
import org.eclipse.jgit.transport.HttpAuthMethod$Type;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.util.Base64;

class HttpAuthMethod$Digest
extends HttpAuthMethod {
    private static final SecureRandom PRNG = new SecureRandom();
    private final Map params;
    private int requestCount;
    private String user;
    private String pass;
    private static final char[] LHEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    HttpAuthMethod$Digest(String string) {
        super(HttpAuthMethod$Type.DIGEST);
        this.params = HttpAuthMethod$Digest.parse(string);
        String string2 = (String)this.params.get("qop");
        if ("auth".equals(string2)) {
            byte[] byArray = new byte[8];
            PRNG.nextBytes(byArray);
            this.params.put("cnonce", Base64.encodeBytes(byArray));
        }
    }

    @Override
    void authorize(String string, String string2) {
        this.user = string;
        this.pass = string2;
    }

    @Override
    void configureRequest(HttpConnection httpConnection) {
        String string;
        String string2;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        String string3 = (String)this.params.get("realm");
        String string4 = (String)this.params.get("nonce");
        String string5 = (String)this.params.get("cnonce");
        String string6 = HttpAuthMethod$Digest.uri(httpConnection.getURL());
        String string7 = (String)this.params.get("qop");
        String string8 = httpConnection.getRequestMethod();
        String string9 = this.user + ":" + string3 + ":" + this.pass;
        String string10 = string8 + ":" + string6;
        linkedHashMap.put("username", this.user);
        linkedHashMap.put("realm", string3);
        linkedHashMap.put("nonce", string4);
        linkedHashMap.put("uri", string6);
        if ("auth".equals(string7)) {
            string2 = String.format("%08x", ++this.requestCount);
            string = HttpAuthMethod$Digest.KD(HttpAuthMethod$Digest.H(string9), string4 + ":" + string2 + ":" + string5 + ":" + string7 + ":" + HttpAuthMethod$Digest.H(string10));
        } else {
            string2 = null;
            string = HttpAuthMethod$Digest.KD(HttpAuthMethod$Digest.H(string9), string4 + ":" + HttpAuthMethod$Digest.H(string10));
        }
        linkedHashMap.put("response", string);
        if (this.params.containsKey("algorithm")) {
            linkedHashMap.put("algorithm", "MD5");
        }
        if (string5 != null && string7 != null) {
            linkedHashMap.put("cnonce", string5);
        }
        if (this.params.containsKey("opaque")) {
            linkedHashMap.put("opaque", (String)this.params.get("opaque"));
        }
        if (string7 != null) {
            linkedHashMap.put("qop", string7);
        }
        if (string2 != null) {
            linkedHashMap.put("nc", string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((String)entry.getKey());
            stringBuilder.append('=');
            stringBuilder.append('\"');
            stringBuilder.append((String)entry.getValue());
            stringBuilder.append('\"');
        }
        httpConnection.setRequestProperty("Authorization", this.type.getSchemeName() + " " + stringBuilder);
    }

    private static String uri(URL uRL) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(uRL.getProtocol());
        stringBuilder.append("://");
        stringBuilder.append(uRL.getHost());
        if (!(0 >= uRL.getPort() || uRL.getPort() == 80 && "http".equals(uRL.getProtocol()) || uRL.getPort() == 443 && "https".equals(uRL.getProtocol()))) {
            stringBuilder.append(':').append(uRL.getPort());
        }
        stringBuilder.append(uRL.getPath());
        if (uRL.getQuery() != null) {
            stringBuilder.append('?').append(uRL.getQuery());
        }
        return stringBuilder.toString();
    }

    private static String H(String string) {
        MessageDigest messageDigest = HttpAuthMethod$Digest.newMD5();
        messageDigest.update(string.getBytes(StandardCharsets.UTF_8));
        return HttpAuthMethod$Digest.LHEX(messageDigest.digest());
    }

    private static String KD(String string, String string2) {
        MessageDigest messageDigest = HttpAuthMethod$Digest.newMD5();
        messageDigest.update(string.getBytes(StandardCharsets.UTF_8));
        messageDigest.update((byte)58);
        messageDigest.update(string2.getBytes(StandardCharsets.UTF_8));
        return HttpAuthMethod$Digest.LHEX(messageDigest.digest());
    }

    private static MessageDigest newMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("No MD5 available", noSuchAlgorithmException);
        }
    }

    private static String LHEX(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            stringBuilder.append(LHEX[by >>> 4 & 0xF]);
            stringBuilder.append(LHEX[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    private static Map parse(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 0;
        while (n2 < string.length()) {
            String string2;
            int n3;
            if (n2 < string.length() && string.charAt(n2) == ',') {
                ++n2;
            }
            while (n2 < string.length() && Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            int n4 = string.indexOf(61, n2);
            if (n4 < 0 || n4 + 1 == string.length()) {
                return Collections.emptyMap();
            }
            String string3 = string.substring(n2, n4);
            if (string.charAt(n4 + 1) == '\"') {
                n3 = string.indexOf(34, n4 + 2);
                if (n3 < 0) {
                    return Collections.emptyMap();
                }
                string2 = string.substring(n4 + 2, n3);
                n2 = n3 + 1;
            } else {
                n3 = string.indexOf(32, n4 + 1);
                int n5 = string.indexOf(44, n4 + 1);
                if (n3 < 0) {
                    n3 = string.length();
                }
                if (n5 < 0) {
                    n5 = string.length();
                }
                int n6 = Math.min(n3, n5);
                string2 = string.substring(n4 + 1, n6);
                n2 = n6 + 1;
            }
            hashMap.put(string3, string2);
        }
        return hashMap;
    }
}

