/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.NonceGenerator;
import org.eclipse.jgit.transport.PushCertificate$NonceStatus;

public class HMACSHA1NonceGenerator
implements NonceGenerator {
    private Mac mac;
    private static final String HEX = "0123456789ABCDEF";

    public HMACSHA1NonceGenerator(String string) {
        try {
            byte[] byArray = string.getBytes(StandardCharsets.ISO_8859_1);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacSHA1");
            this.mac = Mac.getInstance("HmacSHA1");
            this.mac.init(secretKeySpec);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            throw new IllegalStateException(generalSecurityException);
        }
    }

    @Override
    public synchronized String createNonce(Repository repository, long l2) {
        String string = repository.getIdentifier() + ":" + String.valueOf(l2);
        byte[] byArray = this.mac.doFinal(string.getBytes(StandardCharsets.UTF_8));
        return Long.toString(l2) + "-" + HMACSHA1NonceGenerator.toHex(byArray);
    }

    @Override
    public PushCertificate$NonceStatus verify(String string, String string2, Repository repository, boolean bl2, int n2) {
        long l2;
        long l3;
        if (string.isEmpty()) {
            return PushCertificate$NonceStatus.MISSING;
        }
        if (string2.isEmpty()) {
            return PushCertificate$NonceStatus.UNSOLICITED;
        }
        if (string.equals(string2)) {
            return PushCertificate$NonceStatus.OK;
        }
        if (!bl2) {
            return PushCertificate$NonceStatus.BAD;
        }
        int n3 = string2.indexOf(45);
        int n4 = string.indexOf(45);
        if (n3 == -1 || n4 == -1) {
            return PushCertificate$NonceStatus.BAD;
        }
        String string3 = string.substring(0, n4);
        String string4 = string2.substring(0, n3);
        try {
            l3 = Long.parseLong(string3);
            l2 = Long.parseLong(string4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return PushCertificate$NonceStatus.BAD;
        }
        String string5 = this.createNonce(repository, l3);
        if (!string5.equals(string)) {
            return PushCertificate$NonceStatus.BAD;
        }
        long l4 = Math.abs(l2 - l3);
        if (l4 <= (long)n2) {
            return PushCertificate$NonceStatus.OK;
        }
        return PushCertificate$NonceStatus.SLOP;
    }

    private static String toHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (byte by : byArray) {
            stringBuilder.append(HEX.charAt((by & 0xF0) >> 4));
            stringBuilder.append(HEX.charAt(by & 0xF));
        }
        return stringBuilder.toString();
    }
}

