/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.FilterSpec$ObjectTypes;

public final class FilterSpec {
    private final FilterSpec$ObjectTypes types;
    private final long blobLimit;
    private final long treeDepthLimit;
    public static final FilterSpec NO_FILTER = new FilterSpec(FilterSpec$ObjectTypes.ALL, -1L, -1L);

    private FilterSpec(FilterSpec$ObjectTypes objectTypes, long l2, long l3) {
        this.types = Objects.requireNonNull(objectTypes);
        this.blobLimit = l2;
        this.treeDepthLimit = l3;
    }

    public static FilterSpec fromFilterLine(String string) {
        if (string.equals("blob:none")) {
            return FilterSpec.withObjectTypes(FilterSpec$ObjectTypes.allow(2, 1, 4));
        }
        if (string.startsWith("blob:limit=")) {
            long l2 = -1L;
            try {
                l2 = Long.parseLong(string.substring("blob:limit=".length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (l2 >= 0L) {
                return FilterSpec.withBlobLimit(l2);
            }
        } else if (string.startsWith("tree:")) {
            long l3 = -1L;
            try {
                l3 = Long.parseLong(string.substring("tree:".length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (l3 >= 0L) {
                return FilterSpec.withTreeDepthLimit(l3);
            }
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidFilter, string));
    }

    static FilterSpec withObjectTypes(FilterSpec$ObjectTypes filterSpec$ObjectTypes) {
        return new FilterSpec(filterSpec$ObjectTypes, -1L, -1L);
    }

    static FilterSpec withBlobLimit(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("blobLimit cannot be negative: " + l2);
        }
        return new FilterSpec(FilterSpec$ObjectTypes.ALL, l2, -1L);
    }

    static FilterSpec withTreeDepthLimit(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("treeDepthLimit cannot be negative: " + l2);
        }
        return new FilterSpec(FilterSpec$ObjectTypes.ALL, -1L, l2);
    }

    public boolean allowsType(int n2) {
        return this.types.contains(n2);
    }

    public long getBlobLimit() {
        return this.blobLimit;
    }

    public long getTreeDepthLimit() {
        return this.treeDepthLimit;
    }

    public boolean isNoOp() {
        return this.types.equals(FilterSpec$ObjectTypes.ALL) && this.blobLimit == -1L && this.treeDepthLimit == -1L;
    }

    @Nullable
    public String filterLine() {
        if (this.isNoOp()) {
            return null;
        }
        if (this.types.equals(FilterSpec$ObjectTypes.allow(2, 1, 4)) && this.blobLimit == -1L && this.treeDepthLimit == -1L) {
            return "filter blob:none";
        }
        if (this.types.equals(FilterSpec$ObjectTypes.ALL) && this.blobLimit >= 0L && this.treeDepthLimit == -1L) {
            return "filter blob:limit=" + this.blobLimit;
        }
        if (this.types.equals(FilterSpec$ObjectTypes.ALL) && this.blobLimit == -1L && this.treeDepthLimit >= 0L) {
            return "filter tree:" + this.treeDepthLimit;
        }
        throw new IllegalStateException();
    }
}

