/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.FetchV2Request;
import org.eclipse.jgit.transport.FilterSpec;

final class FetchV2Request$Builder {
    final List peerHas = new ArrayList();
    final List wantedRefs = new ArrayList();
    final Set wantIds = new HashSet();
    final Set clientShallowCommits = new HashSet();
    final List deepenNotRefs = new ArrayList();
    final Set clientCapabilities = new HashSet();
    int depth;
    int deepenSince;
    FilterSpec filterSpec = FilterSpec.NO_FILTER;
    boolean doneReceived;
    boolean waitForDone;
    @Nullable
    String agent;
    final List serverOptions = new ArrayList();
    boolean sidebandAll;
    final List packfileUriProtocols = new ArrayList();

    private FetchV2Request$Builder() {
    }

    FetchV2Request$Builder addPeerHas(ObjectId objectId) {
        this.peerHas.add(objectId);
        return this;
    }

    FetchV2Request$Builder addWantedRef(String string) {
        this.wantedRefs.add(string);
        return this;
    }

    FetchV2Request$Builder addClientCapability(String string) {
        this.clientCapabilities.add(string);
        return this;
    }

    FetchV2Request$Builder addWantId(ObjectId objectId) {
        this.wantIds.add(objectId);
        return this;
    }

    FetchV2Request$Builder addClientShallowCommit(ObjectId objectId) {
        this.clientShallowCommits.add(objectId);
        return this;
    }

    FetchV2Request$Builder setDepth(int n2) {
        this.depth = n2;
        return this;
    }

    int getDepth() {
        return this.depth;
    }

    boolean hasDeepenNotRefs() {
        return !this.deepenNotRefs.isEmpty();
    }

    FetchV2Request$Builder addDeepenNotRef(String string) {
        this.deepenNotRefs.add(string);
        return this;
    }

    FetchV2Request$Builder setDeepenSince(int n2) {
        this.deepenSince = n2;
        return this;
    }

    int getDeepenSince() {
        return this.deepenSince;
    }

    FetchV2Request$Builder setFilterSpec(@NonNull FilterSpec filterSpec) {
        this.filterSpec = Objects.requireNonNull(filterSpec);
        return this;
    }

    FetchV2Request$Builder setDoneReceived() {
        this.doneReceived = true;
        return this;
    }

    FetchV2Request$Builder setWaitForDone() {
        this.waitForDone = true;
        return this;
    }

    FetchV2Request$Builder setAgent(@Nullable String string) {
        this.agent = string;
        return this;
    }

    FetchV2Request$Builder addServerOption(@NonNull String string) {
        this.serverOptions.add(string);
        return this;
    }

    FetchV2Request$Builder setSidebandAll(boolean bl2) {
        this.sidebandAll = bl2;
        return this;
    }

    FetchV2Request$Builder addPackfileUriProtocol(@NonNull String string) {
        this.packfileUriProtocols.add(string);
        return this;
    }

    FetchV2Request build() {
        return new FetchV2Request(this.peerHas, this.wantedRefs, this.wantIds, this.clientShallowCommits, this.deepenSince, this.deepenNotRefs, this.depth, this.filterSpec, this.doneReceived, this.waitForDone, this.clientCapabilities, this.agent, Collections.unmodifiableList(this.serverOptions), this.sidebandAll, Collections.unmodifiableList(this.packfileUriProtocols));
    }
}

