/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.FetchHeadRecord;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceiveCommand$Result;
import org.eclipse.jgit.transport.ReceiveCommand$Type;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.TrackingRefUpdate$Command;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.util.StringUtils;

class FetchProcess {
    private final Transport transport;
    private final Collection toFetch;
    private final HashMap askFor = new HashMap();
    private final HashSet have = new HashSet();
    private final ArrayList localUpdates = new ArrayList();
    private final ArrayList fetchHeadUpdates = new ArrayList();
    private final ArrayList packLocks = new ArrayList();
    private FetchConnection conn;
    private Map localRefs;

    FetchProcess(Transport transport, Collection collection) {
        this.transport = transport;
        this.toFetch = collection;
    }

    void execute(ProgressMonitor progressMonitor, FetchResult fetchResult, String string) {
        this.askFor.clear();
        this.localUpdates.clear();
        this.fetchHeadUpdates.clear();
        this.packLocks.clear();
        this.localRefs = null;
        IOException iOException = null;
        try {
            this.executeImp(progressMonitor, fetchResult, string);
        }
        catch (NotSupportedException | TransportException iOException2) {
            iOException = iOException2;
            throw iOException2;
        }
        finally {
            try {
                for (PackLock packLock : this.packLocks) {
                    packLock.unlock();
                }
            }
            catch (IOException iOException3) {
                if (iOException != null) {
                    iOException3.addSuppressed(iOException);
                }
                throw new TransportException(iOException3.getMessage(), iOException3);
            }
        }
    }

    private boolean isInitialBranchMissing(Map map, String string) {
        if (StringUtils.isEmptyOrNull(string) || map.isEmpty()) {
            return false;
        }
        return !map.containsKey(string) && !map.containsKey("refs/heads/" + string) && !map.containsKey("refs/tags/" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeImp(ProgressMonitor progressMonitor, FetchResult fetchResult, String string) {
        Object object;
        Object object2;
        Object object3;
        TagOpt tagOpt = this.transport.getTagOpt();
        String string2 = tagOpt == TagOpt.NO_TAGS ? null : "refs/tags/";
        String string3 = null;
        try {
            object3 = this.transport.local.exactRef("HEAD");
            Object object4 = object2 = object3 != null ? object3.getObjectId() : null;
            if (object2 == null || ((AnyObjectId)object2).equals(ObjectId.zeroId())) {
                string3 = "HEAD";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.conn = this.transport.openFetch(this.toFetch, string2, string3);
        try {
            boolean bl2;
            object3 = this.conn.getRefsMap();
            if (this.isInitialBranchMissing((Map)object3, string)) {
                throw new TransportException(MessageFormat.format(JGitText.get().remoteBranchNotFound, string));
            }
            fetchResult.setAdvertisedRefs(this.transport.getURI(), (Map)object3);
            fetchResult.peerUserAgent = this.conn.getPeerUserAgent();
            object2 = new HashSet();
            for (RefSpec refSpec : this.toFetch) {
                if (refSpec.getSource() == null) {
                    throw new TransportException(MessageFormat.format(JGitText.get().sourceRefNotSpecifiedForRefspec, refSpec));
                }
                if (refSpec.isWildcard()) {
                    this.expandWildcard(refSpec, (Set)object2);
                    continue;
                }
                this.expandSingle(refSpec, (Set)object2);
            }
            object = Collections.emptyList();
            if (tagOpt == TagOpt.AUTO_FOLLOW) {
                object = this.expandAutoFollowTags();
            } else if (tagOpt == TagOpt.FETCH_TAGS) {
                this.expandFetchTags();
            }
            if (!this.askFor.isEmpty() && !this.askForIsComplete()) {
                this.fetchObjects(progressMonitor);
                bl2 = this.conn.didFetchIncludeTags();
                this.closeConnection(fetchResult);
            } else {
                bl2 = false;
            }
            if (tagOpt == TagOpt.AUTO_FOLLOW && !object.isEmpty()) {
                this.have.addAll(this.askFor.keySet());
                this.askFor.clear();
                Object object5 = object.iterator();
                while (object5.hasNext()) {
                    Ref ref = (Ref)object5.next();
                    ObjectId objectId = ref.getPeeledObjectId();
                    if (objectId == null) {
                        objectId = ref.getObjectId();
                    }
                    if (!this.localHasObject(objectId)) continue;
                    this.wantTag(ref);
                }
                if (!(this.askFor.isEmpty() || bl2 && this.askForIsComplete())) {
                    this.reopenConnection();
                    if (!this.askFor.isEmpty()) {
                        this.fetchObjects(progressMonitor);
                    }
                }
            }
        }
        finally {
            this.closeConnection(fetchResult);
        }
        object3 = this.transport.local.getRefDatabase().newBatchUpdate().setAllowNonFastForwards(true);
        if (string == null) {
            ((BatchRefUpdate)object3).setRefLogMessage("fetch", true);
        }
        try {
            object2 = new RevWalk(this.transport.local);
            object = null;
            try {
                ((RevWalk)object2).setRetainBody(false);
                if (progressMonitor instanceof BatchingProgressMonitor) {
                    ((BatchingProgressMonitor)progressMonitor).setDelayStart(250L, TimeUnit.MILLISECONDS);
                }
                if (this.transport.isRemoveDeletedRefs()) {
                    this.deleteStaleTrackingRefs(fetchResult, (BatchRefUpdate)object3);
                }
                this.addUpdateBatchCommands(fetchResult, (BatchRefUpdate)object3);
                for (Object object5 : ((BatchRefUpdate)object3).getCommands()) {
                    ((ReceiveCommand)object5).updateType((RevWalk)object2);
                    if (((ReceiveCommand)object5).getType() != ReceiveCommand$Type.UPDATE_NONFASTFORWARD || !(object5 instanceof TrackingRefUpdate$Command) || ((TrackingRefUpdate$Command)object5).canForceUpdate()) continue;
                    ((ReceiveCommand)object5).setResult(ReceiveCommand$Result.REJECTED_NONFASTFORWARD);
                }
                if (this.transport.isDryRun()) {
                    for (Object object5 : ((BatchRefUpdate)object3).getCommands()) {
                        if (((ReceiveCommand)object5).getResult() != ReceiveCommand$Result.NOT_ATTEMPTED) continue;
                        ((ReceiveCommand)object5).setResult(ReceiveCommand$Result.OK);
                    }
                } else {
                    ((BatchRefUpdate)object3).execute((RevWalk)object2, progressMonitor);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((RevWalk)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((RevWalk)object2).close();
                    }
                }
            }
        }
        catch (TransportException transportException) {
            throw transportException;
        }
        catch (IOException iOException) {
            throw new TransportException(MessageFormat.format(JGitText.get().failureUpdatingTrackingRef, FetchProcess.getFirstFailedRefName((BatchRefUpdate)object3), iOException.getMessage()), iOException);
        }
        if (!this.fetchHeadUpdates.isEmpty()) {
            try {
                this.updateFETCH_HEAD(fetchResult);
            }
            catch (IOException iOException) {
                throw new TransportException(MessageFormat.format(JGitText.get().failureUpdatingFETCH_HEAD, iOException.getMessage()), iOException);
            }
        }
    }

    private void addUpdateBatchCommands(FetchResult fetchResult, BatchRefUpdate batchRefUpdate) {
        HashMap<String, ObjectId> hashMap = new HashMap<String, ObjectId>();
        for (TrackingRefUpdate trackingRefUpdate : this.localUpdates) {
            ObjectId objectId = (ObjectId)hashMap.get(trackingRefUpdate.getLocalName());
            if (objectId == null) {
                hashMap.put(trackingRefUpdate.getLocalName(), trackingRefUpdate.getNewObjectId());
                fetchResult.add(trackingRefUpdate);
                batchRefUpdate.addCommand(trackingRefUpdate.asReceiveCommand());
                continue;
            }
            if (objectId.equals(trackingRefUpdate.getNewObjectId())) continue;
            throw new TransportException(MessageFormat.format(JGitText.get().duplicateRef, trackingRefUpdate.getLocalName()));
        }
    }

    private void fetchObjects(ProgressMonitor progressMonitor) {
        try {
            this.conn.setPackLockMessage("jgit fetch " + this.transport.uri);
            this.conn.fetch(progressMonitor, this.askFor.values(), this.have);
        }
        finally {
            this.packLocks.addAll(this.conn.getPackLocks());
        }
        if (this.transport.isCheckFetchedObjects() && !this.conn.didFetchTestConnectivity() && !this.askForIsComplete()) {
            throw new TransportException(this.transport.getURI(), JGitText.get().peerDidNotSupplyACompleteObjectGraph);
        }
    }

    private void closeConnection(FetchResult fetchResult) {
        if (this.conn != null) {
            this.conn.close();
            fetchResult.addMessages(this.conn.getMessages());
            this.conn = null;
        }
    }

    private void reopenConnection() {
        ArrayList arrayList2;
        if (this.conn != null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (ArrayList arrayList2 : this.askFor.values()) {
            Iterator iterator = arrayList2.getName();
            hashSet.add((String)((Object)iterator));
            hashSet.add("refs/" + (String)((Object)iterator));
            hashSet.add("refs/heads/" + (String)((Object)iterator));
            hashSet.add("refs/tags/" + iterator);
        }
        this.conn = this.transport.openFetch(Collections.emptyList(), hashSet.toArray(new String[0]));
        HashMap hashMap = new HashMap();
        for (Iterator iterator : this.conn.getRefs()) {
            hashMap.put(iterator.getObjectId(), iterator);
        }
        arrayList2 = new ArrayList(this.askFor.values());
        this.askFor.clear();
        for (Ref ref : arrayList2) {
            Ref ref2 = (Ref)hashMap.get(ref.getObjectId());
            if (ref2 != null) {
                this.askFor.put(ref2.getObjectId(), ref2);
                continue;
            }
            this.removeFetchHeadRecord(ref.getObjectId());
            this.removeTrackingRefUpdate(ref.getObjectId());
        }
    }

    private void removeTrackingRefUpdate(ObjectId objectId) {
        Iterator iterator = this.localUpdates.iterator();
        while (iterator.hasNext()) {
            TrackingRefUpdate trackingRefUpdate = (TrackingRefUpdate)iterator.next();
            if (!trackingRefUpdate.getNewObjectId().equals(objectId)) continue;
            iterator.remove();
        }
    }

    private void removeFetchHeadRecord(ObjectId objectId) {
        Iterator iterator = this.fetchHeadUpdates.iterator();
        while (iterator.hasNext()) {
            FetchHeadRecord fetchHeadRecord = (FetchHeadRecord)iterator.next();
            if (!fetchHeadRecord.newValue.equals(objectId)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFETCH_HEAD(FetchResult fetchResult) {
        block17: {
            File file = this.transport.local.getDirectory();
            if (file == null) {
                return;
            }
            LockFile lockFile = new LockFile(new File(file, "FETCH_HEAD"), this.transport.local.getFS());
            try {
                if (!lockFile.lock()) break block17;
                try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(lockFile.getOutputStream(), StandardCharsets.UTF_8);){
                    for (FetchHeadRecord fetchHeadRecord : this.fetchHeadUpdates) {
                        fetchHeadRecord.write(outputStreamWriter);
                        fetchResult.add(fetchHeadRecord);
                    }
                }
                lockFile.commit();
            }
            finally {
                lockFile.unlock();
            }
        }
    }

    private boolean askForIsComplete() {
        try {
            try (ObjectWalk objectWalk = new ObjectWalk(this.transport.local);){
                boolean bl2 = false;
                for (Object object : this.askFor.keySet()) {
                    RevObject revObject = objectWalk.parseAny((AnyObjectId)object);
                    objectWalk.markStart(revObject);
                    bl2 |= revObject.getType() == 1;
                }
                if (bl2) {
                    for (Object object : this.localRefs().values()) {
                        objectWalk.markUninteresting(objectWalk.parseAny(object.getObjectId()));
                    }
                    objectWalk.checkConnectivity();
                }
            }
            return true;
        }
        catch (MissingObjectException missingObjectException) {
            return false;
        }
        catch (IOException iOException) {
            throw new TransportException(JGitText.get().unableToCheckConnectivity, iOException);
        }
    }

    private void expandWildcard(RefSpec refSpec, Set set) {
        for (Ref ref : this.conn.getRefs()) {
            if (!refSpec.matchSource(ref) || !set.add(ref)) continue;
            this.want(ref, refSpec.expandFromSource(ref));
        }
    }

    private void expandSingle(RefSpec refSpec, Set set) {
        String string = refSpec.getSource();
        if (ObjectId.isId(string)) {
            this.want(ObjectId.fromString(string));
            return;
        }
        Ref ref = this.conn.getRef(string);
        if (ref == null) {
            throw new TransportException(MessageFormat.format(JGitText.get().remoteDoesNotHaveSpec, string));
        }
        if (set.add(ref)) {
            this.want(ref, refSpec);
        }
    }

    private boolean localHasObject(ObjectId objectId) {
        try {
            return this.transport.local.getObjectDatabase().has(objectId);
        }
        catch (IOException iOException) {
            throw new TransportException(MessageFormat.format(JGitText.get().readingObjectsFromLocalRepositoryFailed, iOException.getMessage()), iOException);
        }
    }

    private Collection expandAutoFollowTags() {
        ArrayList<Ref> arrayList = new ArrayList<Ref>();
        Map map = this.localRefs();
        for (Ref ref : this.conn.getRefs()) {
            Ref ref2;
            if (!FetchProcess.isTag(ref) || (ref2 = (Ref)map.get(ref.getName())) != null) continue;
            ObjectId objectId = ref.getPeeledObjectId();
            if (objectId == null) {
                objectId = ref.getObjectId();
            }
            if (this.askFor.containsKey(objectId) || this.localHasObject(objectId)) {
                this.wantTag(ref);
                continue;
            }
            arrayList.add(ref);
        }
        return arrayList;
    }

    private void expandFetchTags() {
        Map map = this.localRefs();
        for (Ref ref : this.conn.getRefs()) {
            Ref ref2;
            ObjectId objectId;
            if (!FetchProcess.isTag(ref) || (objectId = ref.getObjectId()) == null || (ref2 = (Ref)map.get(ref.getName())) != null && objectId.equals(ref2.getObjectId())) continue;
            this.wantTag(ref);
        }
    }

    private void wantTag(Ref ref) {
        this.want(ref, new RefSpec().setSource(ref.getName()).setDestination(ref.getName()).setForceUpdate(true));
    }

    private void want(Ref ref, RefSpec refSpec) {
        Object object;
        ObjectId objectId = ref.getObjectId();
        if (objectId == null) {
            throw new NullPointerException(MessageFormat.format(JGitText.get().transportProvidedRefWithNoObjectId, ref.getName()));
        }
        if (refSpec.getDestination() != null) {
            object = this.createUpdate(refSpec, objectId);
            if (objectId.equals(((TrackingRefUpdate)object).getOldObjectId())) {
                return;
            }
            this.localUpdates.add(object);
        }
        this.askFor.put(objectId, ref);
        object = new FetchHeadRecord();
        ((FetchHeadRecord)object).newValue = objectId;
        ((FetchHeadRecord)object).notForMerge = refSpec.getDestination() != null;
        ((FetchHeadRecord)object).sourceName = ref.getName();
        ((FetchHeadRecord)object).sourceURI = this.transport.getURI();
        this.fetchHeadUpdates.add(object);
    }

    private void want(ObjectId objectId) {
        this.askFor.put(objectId, new ObjectIdRef$Unpeeled(Ref$Storage.NETWORK, objectId.name(), objectId));
    }

    private TrackingRefUpdate createUpdate(RefSpec refSpec, ObjectId objectId) {
        Ref ref = (Ref)this.localRefs().get(refSpec.getDestination());
        ObjectId objectId2 = ref != null && ref.getObjectId() != null ? ref.getObjectId() : ObjectId.zeroId();
        return new TrackingRefUpdate(refSpec.isForceUpdate(), refSpec.getSource(), refSpec.getDestination(), objectId2, objectId);
    }

    private Map localRefs() {
        if (this.localRefs == null) {
            try {
                this.localRefs = this.transport.local.getRefDatabase().getRefs("");
            }
            catch (IOException iOException) {
                throw new TransportException(JGitText.get().cannotListRefs, iOException);
            }
        }
        return this.localRefs;
    }

    private void deleteStaleTrackingRefs(FetchResult fetchResult, BatchRefUpdate batchRefUpdate) {
        HashSet<Ref> hashSet = new HashSet<Ref>();
        for (Ref ref : this.localRefs().values()) {
            if (ref.isSymbolic()) continue;
            String string = ref.getName();
            for (RefSpec refSpec : this.toFetch) {
                RefSpec refSpec2;
                if (!refSpec.matchDestination(string) || fetchResult.getAdvertisedRef((refSpec2 = refSpec.expandFromDestination(string)).getSource()) != null || !hashSet.add(ref)) continue;
                this.deleteTrackingRef(fetchResult, batchRefUpdate, refSpec2, ref);
            }
        }
    }

    private void deleteTrackingRef(FetchResult fetchResult, BatchRefUpdate batchRefUpdate, RefSpec refSpec, Ref ref) {
        if (ref.getObjectId() == null) {
            return;
        }
        TrackingRefUpdate trackingRefUpdate = new TrackingRefUpdate(true, refSpec.getSource(), ref.getName(), ref.getObjectId(), ObjectId.zeroId());
        fetchResult.add(trackingRefUpdate);
        batchRefUpdate.addCommand(trackingRefUpdate.asReceiveCommand());
    }

    private static boolean isTag(Ref ref) {
        return FetchProcess.isTag(ref.getName());
    }

    private static boolean isTag(String string) {
        return string.startsWith("refs/tags/");
    }

    private static String getFirstFailedRefName(BatchRefUpdate batchRefUpdate) {
        for (ReceiveCommand receiveCommand : batchRefUpdate.getCommands()) {
            if (receiveCommand.getResult() == ReceiveCommand$Result.OK) continue;
            return receiveCommand.getRefName();
        }
        return "";
    }
}

