/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collection;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Config$SectionParser;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.DaemonClient;
import org.eclipse.jgit.transport.DaemonService$ServiceConfig;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;

public abstract class DaemonService {
    private final String command;
    private final Config$SectionParser configKey;
    private boolean enabled;
    private boolean overridable;

    DaemonService(String string, String string2) {
        this.command = string.startsWith("git-") ? string : "git-" + string;
        this.configKey = config -> new DaemonService$ServiceConfig(this, config, string2);
        this.overridable = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl2) {
        this.enabled = bl2;
    }

    public boolean isOverridable() {
        return this.overridable;
    }

    public void setOverridable(boolean bl2) {
        this.overridable = bl2;
    }

    public String getCommandName() {
        return this.command;
    }

    public boolean handles(String string) {
        return this.command.length() + 1 < string.length() && string.charAt(this.command.length()) == ' ' && string.startsWith(this.command);
    }

    void execute(DaemonClient daemonClient, String string, @Nullable Collection collection) {
        String string2 = string.substring(this.command.length() + 1);
        try (Repository repository = daemonClient.getDaemon().openRepository(daemonClient, string2);){
            if (this.isEnabledFor(repository)) {
                this.execute(daemonClient, repository, collection);
            }
        }
        catch (ServiceMayNotContinueException serviceMayNotContinueException) {
            PacketLineOut packetLineOut = new PacketLineOut(daemonClient.getOutputStream());
            packetLineOut.writeString("ERR " + serviceMayNotContinueException.getMessage() + "\n");
        }
    }

    private boolean isEnabledFor(Repository repository) {
        if (this.isOverridable()) {
            return ((DaemonService$ServiceConfig)repository.getConfig().get((Config$SectionParser)this.configKey)).enabled;
        }
        return this.isEnabled();
    }

    abstract void execute(DaemonClient var1, Repository var2, @Nullable Collection var3);
}

