/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.transport.Daemon;
import org.eclipse.jgit.transport.DaemonService;
import org.eclipse.jgit.transport.PacketLineIn;

public class DaemonClient {
    private final Daemon daemon;
    private InetAddress peer;
    private InputStream rawIn;
    private OutputStream rawOut;

    DaemonClient(Daemon daemon) {
        this.daemon = daemon;
    }

    void setRemoteAddress(InetAddress inetAddress) {
        this.peer = inetAddress;
    }

    public Daemon getDaemon() {
        return this.daemon;
    }

    public InetAddress getRemoteAddress() {
        return this.peer;
    }

    public InputStream getInputStream() {
        return this.rawIn;
    }

    public OutputStream getOutputStream() {
        return this.rawOut;
    }

    void execute(Socket socket) {
        DaemonService daemonService;
        int n2;
        this.rawIn = new BufferedInputStream(socket.getInputStream());
        this.rawOut = new BufferedOutputStream(socket.getOutputStream());
        if (0 < this.daemon.getTimeout()) {
            socket.setSoTimeout(this.daemon.getTimeout() * 1000);
        }
        String string = new PacketLineIn(this.rawIn).readStringRaw();
        List<String> list = null;
        int n3 = string.indexOf("\u0000\u0000");
        if (n3 != -1) {
            list = Arrays.asList(string.substring(n3 + 2).split("\u0000"));
        }
        if ((n2 = string.indexOf(0)) >= 0) {
            string = string.substring(0, n2);
        }
        if ((daemonService = this.getDaemon().matchService(string)) == null) {
            return;
        }
        socket.setSoTimeout(0);
        daemonService.execute(this, string, list);
    }
}

