/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.Daemon$1;
import org.eclipse.jgit.transport.Daemon$2;
import org.eclipse.jgit.transport.Daemon$3;
import org.eclipse.jgit.transport.Daemon$Acceptor;
import org.eclipse.jgit.transport.DaemonClient;
import org.eclipse.jgit.transport.DaemonService;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;

public class Daemon {
    public static final int DEFAULT_PORT = 9418;
    private static final int BACKLOG = 5;
    private InetSocketAddress myAddress;
    private final DaemonService[] services;
    private final ThreadGroup processors;
    private Daemon$Acceptor acceptThread;
    private int timeout;
    private PackConfig packConfig;
    private volatile RepositoryResolver repositoryResolver;
    volatile UploadPackFactory uploadPackFactory;
    volatile ReceivePackFactory receivePackFactory;

    public Daemon() {
        this(null);
    }

    public Daemon(InetSocketAddress inetSocketAddress) {
        this.myAddress = inetSocketAddress;
        this.processors = new ThreadGroup("Git-Daemon");
        this.repositoryResolver = RepositoryResolver.NONE;
        this.uploadPackFactory = (daemonClient, repository) -> {
            UploadPack uploadPack = new UploadPack(repository);
            uploadPack.setTimeout(this.getTimeout());
            uploadPack.setPackConfig(this.getPackConfig());
            return uploadPack;
        };
        this.receivePackFactory = (daemonClient, repository) -> {
            ReceivePack receivePack = new ReceivePack(repository);
            InetAddress inetAddress = daemonClient.getRemoteAddress();
            String string = inetAddress.getCanonicalHostName();
            if (string == null) {
                string = inetAddress.getHostAddress();
            }
            String string2 = "anonymous";
            String string3 = string2 + "@" + string;
            receivePack.setRefLogIdent(new PersonIdent(string2, string3));
            receivePack.setTimeout(this.getTimeout());
            return receivePack;
        };
        this.services = new DaemonService[]{new Daemon$1(this, "upload-pack", "uploadpack"), new Daemon$2(this, "receive-pack", "receivepack")};
    }

    public synchronized InetSocketAddress getAddress() {
        return this.myAddress;
    }

    public synchronized DaemonService getService(String string) {
        if (!string.startsWith("git-")) {
            string = "git-" + string;
        }
        for (DaemonService daemonService : this.services) {
            if (!daemonService.getCommandName().equals(string)) continue;
            return daemonService;
        }
        return null;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n2) {
        this.timeout = n2;
    }

    public PackConfig getPackConfig() {
        return this.packConfig;
    }

    public void setPackConfig(PackConfig packConfig) {
        this.packConfig = packConfig;
    }

    public void setRepositoryResolver(RepositoryResolver repositoryResolver) {
        this.repositoryResolver = repositoryResolver;
    }

    public void setUploadPackFactory(UploadPackFactory uploadPackFactory) {
        this.uploadPackFactory = uploadPackFactory != null ? uploadPackFactory : UploadPackFactory.DISABLED;
    }

    public ReceivePackFactory getReceivePackFactory() {
        return this.receivePackFactory;
    }

    public void setReceivePackFactory(ReceivePackFactory receivePackFactory) {
        this.receivePackFactory = receivePackFactory != null ? receivePackFactory : ReceivePackFactory.DISABLED;
    }

    public synchronized void start() {
        if (this.acceptThread != null) {
            throw new IllegalStateException(JGitText.get().daemonAlreadyRunning);
        }
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.setReuseAddress(true);
        if (this.myAddress != null) {
            serverSocket.bind(this.myAddress, 5);
        } else {
            serverSocket.bind(new InetSocketAddress((InetAddress)null, 0), 5);
        }
        this.myAddress = (InetSocketAddress)serverSocket.getLocalSocketAddress();
        this.acceptThread = new Daemon$Acceptor(this, this.processors, "Git-Daemon-Accept", serverSocket);
        this.acceptThread.start();
    }

    private synchronized void clearThread() {
        this.acceptThread = null;
    }

    public synchronized boolean isRunning() {
        return this.acceptThread != null && this.acceptThread.isRunning();
    }

    public synchronized void stop() {
        if (this.acceptThread != null) {
            this.acceptThread.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAndWait() {
        Daemon$Acceptor daemon$Acceptor = null;
        Daemon daemon = this;
        synchronized (daemon) {
            daemon$Acceptor = this.acceptThread;
            this.stop();
        }
        if (daemon$Acceptor != null) {
            daemon$Acceptor.join();
        }
    }

    void startClient(Socket socket) {
        DaemonClient daemonClient = new DaemonClient(this);
        SocketAddress socketAddress = socket.getRemoteSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            daemonClient.setRemoteAddress(((InetSocketAddress)socketAddress).getAddress());
        }
        new Daemon$3(this, this.processors, "Git-Daemon-Client " + socketAddress.toString(), daemonClient, socket).start();
    }

    synchronized DaemonService matchService(String string) {
        for (DaemonService daemonService : this.services) {
            if (!daemonService.handles(string)) continue;
            return daemonService;
        }
        return null;
    }

    Repository openRepository(DaemonClient daemonClient, String string) {
        if (!(string = string.replace('\\', '/')).startsWith("/")) {
            return null;
        }
        try {
            return this.repositoryResolver.open(daemonClient, string.substring(1));
        }
        catch (RepositoryNotFoundException repositoryNotFoundException) {
            return null;
        }
        catch (ServiceNotAuthorizedException serviceNotAuthorizedException) {
            return null;
        }
        catch (ServiceNotEnabledException serviceNotEnabledException) {
            return null;
        }
    }

    static /* synthetic */ void access$000(Daemon daemon) {
        daemon.clearThread();
    }
}

