/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class ChainingCredentialsProvider
extends CredentialsProvider {
    private List credentialProviders;

    public ChainingCredentialsProvider(CredentialsProvider ... credentialsProviderArray) {
        this.credentialProviders = new ArrayList<CredentialsProvider>(Arrays.asList(credentialsProviderArray));
    }

    @Override
    public boolean isInteractive() {
        for (CredentialsProvider credentialsProvider : this.credentialProviders) {
            if (!credentialsProvider.isInteractive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(CredentialItem ... credentialItemArray) {
        for (CredentialsProvider credentialsProvider : this.credentialProviders) {
            if (!credentialsProvider.supports(credentialItemArray)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean get(URIish uRIish, CredentialItem ... credentialItemArray) {
        for (CredentialsProvider credentialsProvider : this.credentialProviders) {
            if (!credentialsProvider.supports(credentialItemArray)) continue;
            if (!credentialsProvider.get(uRIish, credentialItemArray)) {
                if (!credentialsProvider.isInteractive()) continue;
                return false;
            }
            if (ChainingCredentialsProvider.isAnyNull(credentialItemArray)) continue;
            return true;
        }
        return false;
    }
}

