/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.ObjectCountCallback;

public class BundleWriter {
    private final Repository db;
    private final ObjectReader reader;
    private final Map include;
    private final Set assume;
    private final Set tagTargets;
    private final List cachedPacks = new ArrayList();
    private PackConfig packConfig;
    private ObjectCountCallback callback;

    public BundleWriter(Repository repository) {
        this.db = repository;
        this.reader = null;
        this.include = new TreeMap();
        this.assume = new HashSet();
        this.tagTargets = new HashSet();
    }

    public BundleWriter(ObjectReader objectReader) {
        this.db = null;
        this.reader = objectReader;
        this.include = new TreeMap();
        this.assume = new HashSet();
        this.tagTargets = new HashSet();
    }

    public void setPackConfig(PackConfig packConfig) {
        this.packConfig = packConfig;
    }

    public void include(String string, AnyObjectId anyObjectId) {
        boolean bl2;
        boolean bl3 = bl2 = Repository.isValidRefName(string) || "HEAD".equals(string);
        if (!bl2) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidRefName, string));
        }
        if (this.include.containsKey(string)) {
            throw new IllegalStateException(JGitText.get().duplicateRef + string);
        }
        this.include.put(string, anyObjectId.toObjectId());
    }

    public void include(Ref ref) {
        this.include(ref.getName(), ref.getObjectId());
        if (ref.getPeeledObjectId() != null) {
            this.tagTargets.add(ref.getPeeledObjectId());
        } else if (ref.getObjectId() != null && ref.getName().startsWith("refs/heads/")) {
            this.tagTargets.add(ref.getObjectId());
        }
    }

    public void addObjectsAsIs(Collection collection) {
        this.cachedPacks.addAll(collection);
    }

    public void assume(RevCommit revCommit) {
        if (revCommit != null) {
            this.assume.add(revCommit);
        }
    }

    public void writeBundle(ProgressMonitor progressMonitor, OutputStream outputStream) {
        try (PackWriter packWriter = this.newPackWriter();){
            Object object;
            Object object2;
            packWriter.setObjectCountCallback(this.callback);
            packWriter.setIndexDisabled(true);
            packWriter.setDeltaBaseAsOffset(true);
            packWriter.setReuseValidatingObjects(false);
            if (this.cachedPacks.isEmpty()) {
                object2 = new HashSet();
                object = new HashSet();
                ((AbstractCollection)object2).addAll(this.include.values());
                for (RevCommit object3 : this.assume) {
                    ((HashSet)object).add(object3.getId());
                }
                if (((HashSet)object).isEmpty()) {
                    packWriter.setTagTargets(this.tagTargets);
                }
                packWriter.setThin(!((HashSet)object).isEmpty());
                packWriter.preparePack(progressMonitor, (Set)object2, (Set)object);
            } else {
                packWriter.preparePack(this.cachedPacks);
            }
            object2 = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
            ((Writer)object2).write("# v2 git bundle");
            ((Writer)object2).write(10);
            object = new char[40];
            for (RevCommit revCommit : this.assume) {
                ((Writer)object2).write(45);
                revCommit.copyTo((char[])object, (Writer)object2);
                if (revCommit.getRawBuffer() != null) {
                    ((Writer)object2).write(32);
                    ((Writer)object2).write(revCommit.getShortMessage());
                }
                ((Writer)object2).write(10);
            }
            for (Map.Entry entry : this.include.entrySet()) {
                ((ObjectId)entry.getValue()).copyTo((char[])object, (Writer)object2);
                ((Writer)object2).write(32);
                ((Writer)object2).write((String)entry.getKey());
                ((Writer)object2).write(10);
            }
            ((Writer)object2).write(10);
            ((Writer)object2).flush();
            packWriter.writePack(progressMonitor, progressMonitor, outputStream);
        }
    }

    private PackWriter newPackWriter() {
        PackConfig packConfig = this.packConfig;
        if (packConfig == null) {
            packConfig = this.db != null ? new PackConfig(this.db) : new PackConfig();
        }
        return new PackWriter(packConfig, this.reader != null ? this.reader : this.db.newObjectReader());
    }

    public BundleWriter setObjectCountCallback(ObjectCountCallback objectCountCallback) {
        this.callback = objectCountCallback;
        return this;
    }
}

