/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.MissingBundlePrerequisiteException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.BaseFetchConnection;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

class BundleFetchConnection
extends BaseFetchConnection {
    private final Transport transport;
    InputStream bin;
    final Map prereqs = new HashMap();
    private String lockMessage;
    private PackLock packLock;

    BundleFetchConnection(Transport transport, InputStream inputStream) {
        this.transport = transport;
        this.bin = new BufferedInputStream(inputStream);
        try {
            switch (this.readSignature()) {
                case 2: {
                    this.readBundleV2();
                    break;
                }
                default: {
                    throw new TransportException(this.transport.uri, JGitText.get().notABundle);
                }
            }
        }
        catch (TransportException transportException) {
            this.close();
            throw transportException;
        }
        catch (IOException | RuntimeException exception) {
            this.close();
            throw new TransportException(this.transport.uri, exception.getMessage(), exception);
        }
    }

    private int readSignature() {
        String string = this.readLine(new byte[1024]);
        if ("# v2 git bundle".equals(string)) {
            return 2;
        }
        throw new TransportException(this.transport.uri, JGitText.get().notABundle);
    }

    private void readBundleV2() {
        String string;
        byte[] byArray = new byte[1024];
        LinkedHashMap<Object, ObjectIdRef$Unpeeled> linkedHashMap = new LinkedHashMap<Object, ObjectIdRef$Unpeeled>();
        while ((string = this.readLine(byArray)).length() != 0) {
            Object object;
            Object object2;
            if (string.charAt(0) == '-') {
                object2 = ObjectId.fromString(string.substring(1, 41));
                object = null;
                if (string.length() > 42) {
                    object = string.substring(42);
                }
                this.prereqs.put(object2, object);
                continue;
            }
            object2 = string.substring(41, string.length());
            Ref ref = linkedHashMap.put(object2, new ObjectIdRef$Unpeeled(Ref$Storage.NETWORK, (String)object2, (ObjectId)(object = ObjectId.fromString(string.substring(0, 40)))));
            if (ref == null) continue;
            throw this.duplicateAdvertisement((String)object2);
        }
        this.available(linkedHashMap);
    }

    private PackProtocolException duplicateAdvertisement(String string) {
        return new PackProtocolException(this.transport.uri, MessageFormat.format(JGitText.get().duplicateAdvertisementsOf, string));
    }

    private String readLine(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        while (!bl2) {
            int n2;
            this.bin.mark(byArray.length);
            int n3 = this.bin.read(byArray);
            if (n3 < 0) {
                throw new EOFException(JGitText.get().shortReadOfBlock);
            }
            for (n2 = 0; n2 < n3 && byArray[n2] != 10; ++n2) {
            }
            this.bin.reset();
            IO.skipFully(this.bin, n2);
            if (n2 < n3 && byArray[n2] == 10) {
                IO.skipFully(this.bin, 1L);
                bl2 = true;
            }
            stringBuilder.append(RawParseUtils.decode(StandardCharsets.UTF_8, byArray, 0, n2));
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean didFetchTestConnectivity() {
        return false;
    }

    @Override
    protected void doFetch(ProgressMonitor progressMonitor, Collection collection, Set set) {
        this.verifyPrerequisites();
        try (ObjectInserter objectInserter = this.transport.local.newObjectInserter();){
            PackParser packParser = objectInserter.newPackParser(this.bin);
            packParser.setAllowThin(true);
            packParser.setObjectChecker(this.transport.getObjectChecker());
            packParser.setLockMessage(this.lockMessage);
            this.packLock = packParser.parse(NullProgressMonitor.INSTANCE);
            objectInserter.flush();
        }
        catch (IOException | RuntimeException exception) {
            this.close();
            throw new TransportException(this.transport.uri, exception.getMessage(), exception);
        }
    }

    @Override
    public void setPackLockMessage(String string) {
        this.lockMessage = string;
    }

    @Override
    public Collection getPackLocks() {
        if (this.packLock != null) {
            return Collections.singleton(this.packLock);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private void verifyPrerequisites() {
        if (this.prereqs.isEmpty()) {
            return;
        }
        try (RevWalk revWalk = new RevWalk(this.transport.local);){
            void var8_14;
            List list;
            Iterator iterator;
            RevFlag revFlag = revWalk.newFlag("PREREQ");
            RevFlag revFlag2 = revWalk.newFlag("SEEN");
            HashMap hashMap = new HashMap();
            ArrayList<RevCommit> arrayList = new ArrayList<RevCommit>();
            for (Map.Entry object2 : this.prereqs.entrySet()) {
                iterator = (ObjectId)object2.getKey();
                try {
                    RevCommit iOException = revWalk.parseCommit((AnyObjectId)((Object)iterator));
                    if (iOException.has(revFlag)) continue;
                    iOException.add(revFlag);
                    arrayList.add(iOException);
                }
                catch (MissingObjectException missingObjectException) {
                    hashMap.put((ObjectId)((Object)iterator), object2.getValue());
                }
                catch (IOException iOException) {
                    throw new TransportException(this.transport.uri, MessageFormat.format(JGitText.get().cannotReadCommit, ((AnyObjectId)((Object)iterator)).name()), iOException);
                }
            }
            if (!hashMap.isEmpty()) {
                throw new MissingBundlePrerequisiteException(this.transport.uri, hashMap);
            }
            try {
                list = this.transport.local.getRefDatabase().getRefs();
            }
            catch (IOException iOException) {
                throw new TransportException(this.transport.uri, iOException.getMessage(), iOException);
            }
            Iterator n2 = list.iterator();
            while (n2.hasNext()) {
                iterator = (Ref)n2.next();
                try {
                    revWalk.markStart(revWalk.parseCommit(iterator.getObjectId()));
                }
                catch (IOException iOException) {}
            }
            int n3 = arrayList.size();
            try {
                while ((iterator = revWalk.next()) != null) {
                    if (!((RevObject)((Object)iterator)).has(revFlag)) continue;
                    ((RevObject)((Object)iterator)).add(revFlag2);
                    if (--var8_14 != false) continue;
                    break;
                }
            }
            catch (IOException iOException) {
                throw new TransportException(this.transport.uri, JGitText.get().cannotReadObject, iOException);
            }
            if (var8_14 > 0) {
                for (RevObject revObject : arrayList) {
                    if (revObject.has(revFlag2)) continue;
                    hashMap.put(revObject, this.prereqs.get(revObject));
                }
                throw new MissingBundlePrerequisiteException(this.transport.uri, hashMap);
            }
        }
    }

    @Override
    public void close() {
        if (this.bin != null) {
            try {
                this.bin.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.bin = null;
            }
        }
    }
}

