/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TooLargeObjectInPackException;
import org.eclipse.jgit.errors.TooLargePackException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.BasePackConnection;
import org.eclipse.jgit.transport.BasePackPushConnection$CheckingSideBandOutputStream;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.RemoteRefUpdate$Status;
import org.eclipse.jgit.transport.SideBandInputStream;

public abstract class BasePackPushConnection
extends BasePackConnection
implements PushConnection {
    public static final String CAPABILITY_REPORT_STATUS = "report-status";
    public static final String CAPABILITY_DELETE_REFS = "delete-refs";
    public static final String CAPABILITY_OFS_DELTA = "ofs-delta";
    public static final String CAPABILITY_SIDE_BAND_64K = "side-band-64k";
    public static final String CAPABILITY_PUSH_OPTIONS = "push-options";
    private final boolean thinPack;
    private final boolean atomic;
    private List pushOptions;
    private boolean capableAtomic;
    private boolean capableDeleteRefs;
    private boolean capableReport;
    private boolean capableSideBand;
    private boolean capableOfsDelta;
    private boolean capablePushOptions;
    private boolean sentCommand;
    private boolean writePack;
    private long packTransferTime;

    public BasePackPushConnection(PackTransport packTransport) {
        super(packTransport);
        this.thinPack = this.transport.isPushThin();
        this.atomic = this.transport.isPushAtomic();
        this.pushOptions = this.transport.getPushOptions();
    }

    @Override
    public void push(ProgressMonitor progressMonitor, Map map) {
        this.push(progressMonitor, map, null);
    }

    @Override
    public void push(ProgressMonitor progressMonitor, Map map, OutputStream outputStream) {
        this.markStartedOperation();
        this.doPush(progressMonitor, map, outputStream);
    }

    @Override
    protected TransportException noRepository(Throwable throwable) {
        TransportException transportException;
        try {
            this.transport.openFetch().close();
            transportException = new TransportException(this.uri, JGitText.get().pushNotPermitted);
        }
        catch (NoRemoteRepositoryException noRemoteRepositoryException) {
            transportException = noRemoteRepositoryException;
        }
        catch (NotSupportedException | TransportException iOException) {
            transportException = new TransportException(this.uri, JGitText.get().pushNotPermitted, iOException);
        }
        transportException.addSuppressed(throwable);
        return transportException;
    }

    protected void doPush(ProgressMonitor progressMonitor, Map map, OutputStream outputStream) {
        try {
            this.writeCommands(map.values(), progressMonitor, outputStream);
            if (this.pushOptions != null && this.capablePushOptions) {
                this.transmitOptions();
            }
            if (this.writePack) {
                this.writePack(map, progressMonitor);
            }
            if (this.sentCommand) {
                int n2;
                if (this.capableReport) {
                    this.readStatusReport(map);
                }
                if (this.capableSideBand && 0 <= (n2 = this.in.read())) {
                    throw new TransportException(this.uri, MessageFormat.format(JGitText.get().expectedEOFReceived, Character.valueOf((char)n2)));
                }
            }
        }
        catch (TransportException transportException) {
            throw transportException;
        }
        catch (Exception exception) {
            throw new TransportException(this.uri, exception.getMessage(), exception);
        }
        finally {
            this.close();
        }
    }

    private void writeCommands(Collection collection, ProgressMonitor progressMonitor, OutputStream outputStream) {
        String string = this.enableCapabilities(progressMonitor, outputStream);
        if (this.atomic && !this.capableAtomic) {
            throw new TransportException(this.uri, JGitText.get().atomicPushNotSupported);
        }
        if (this.pushOptions != null && !this.capablePushOptions) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().pushOptionsNotSupported, this.pushOptions.toString()));
        }
        for (RemoteRefUpdate remoteRefUpdate : collection) {
            if (!this.capableDeleteRefs && remoteRefUpdate.isDelete()) {
                remoteRefUpdate.setStatus(RemoteRefUpdate$Status.REJECTED_NODELETE);
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            ObjectId objectId = remoteRefUpdate.getExpectedOldObjectId();
            if (objectId == null) {
                Ref ref = this.getRef(remoteRefUpdate.getRemoteName());
                ObjectId objectId2 = objectId = ref != null ? ref.getObjectId() : null;
                if (objectId == null) {
                    objectId = ObjectId.zeroId();
                }
            }
            stringBuilder.append(objectId.name());
            stringBuilder.append(' ');
            stringBuilder.append(remoteRefUpdate.getNewObjectId().name());
            stringBuilder.append(' ');
            stringBuilder.append(remoteRefUpdate.getRemoteName());
            if (!this.sentCommand) {
                this.sentCommand = true;
                stringBuilder.append(string);
            }
            this.pckOut.writeString(stringBuilder.toString());
            remoteRefUpdate.setStatus(RemoteRefUpdate$Status.AWAITING_REPORT);
            if (remoteRefUpdate.isDelete()) continue;
            this.writePack = true;
        }
        if (progressMonitor.isCancelled()) {
            throw new TransportException(this.uri, JGitText.get().pushCancelled);
        }
        this.pckOut.end();
        this.outNeedsEnd = false;
    }

    private void transmitOptions() {
        for (String string : this.pushOptions) {
            this.pckOut.writeString(string);
        }
        this.pckOut.end();
    }

    private String enableCapabilities(ProgressMonitor progressMonitor, OutputStream outputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.atomic) {
            this.capableAtomic = this.wantCapability(stringBuilder, "atomic");
        }
        this.capableReport = this.wantCapability(stringBuilder, CAPABILITY_REPORT_STATUS);
        this.capableDeleteRefs = this.wantCapability(stringBuilder, CAPABILITY_DELETE_REFS);
        this.capableOfsDelta = this.wantCapability(stringBuilder, CAPABILITY_OFS_DELTA);
        if (this.pushOptions != null) {
            this.capablePushOptions = this.wantCapability(stringBuilder, CAPABILITY_PUSH_OPTIONS);
        }
        this.capableSideBand = this.wantCapability(stringBuilder, CAPABILITY_SIDE_BAND_64K);
        if (this.capableSideBand) {
            this.in = new SideBandInputStream(this.in, progressMonitor, this.getMessageWriter(), outputStream);
            this.pckIn = new PacketLineIn(this.in);
        }
        this.addUserAgentCapability(stringBuilder);
        if (stringBuilder.length() > 0) {
            stringBuilder.setCharAt(0, '\u0000');
        }
        return stringBuilder.toString();
    }

    private void writePack(Map map, ProgressMonitor progressMonitor) {
        HashSet<ObjectId> hashSet = new HashSet<ObjectId>();
        HashSet<ObjectId> hashSet2 = new HashSet<ObjectId>();
        try (PackWriter packWriter = new PackWriter(this.transport.getPackConfig(), this.local.newObjectReader());){
            for (Object object : this.getRefs()) {
                ObjectId objectId = object.getObjectId();
                if (!this.local.getObjectDatabase().has(objectId)) continue;
                hashSet.add(objectId);
            }
            hashSet.addAll(this.additionalHaves);
            for (Object object : map.values()) {
                if (ObjectId.zeroId().equals(((RemoteRefUpdate)object).getNewObjectId())) continue;
                hashSet2.add(((RemoteRefUpdate)object).getNewObjectId());
            }
            packWriter.setIndexDisabled(true);
            packWriter.setUseCachedPacks(true);
            packWriter.setUseBitmaps(true);
            packWriter.setThin(this.thinPack);
            packWriter.setReuseValidatingObjects(false);
            packWriter.setDeltaBaseAsOffset(this.capableOfsDelta);
            packWriter.preparePack(progressMonitor, hashSet2, hashSet);
            Object object = this.out;
            if (this.capableSideBand) {
                object = new BasePackPushConnection$CheckingSideBandOutputStream(this.in, this.out);
            }
            packWriter.writePack(progressMonitor, progressMonitor, (OutputStream)object);
            this.packTransferTime = packWriter.getStatistics().getTimeWriting();
        }
    }

    private void readStatusReport(Map map) {
        String string = this.readStringLongTimeout();
        if (!string.startsWith("unpack ")) {
            throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().unexpectedReportLine, string));
        }
        String string2 = string.substring("unpack ".length());
        if (string2.startsWith("error Pack exceeds the limit of")) {
            throw new TooLargePackException(this.uri, string2.substring("error ".length()));
        }
        if (string2.startsWith("error Object too large")) {
            throw new TooLargeObjectInPackException(this.uri, string2.substring("error ".length()));
        }
        if (!string2.equals("ok")) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().errorOccurredDuringUnpackingOnTheRemoteEnd, string2));
        }
        for (Object object : this.pckIn.readStrings()) {
            boolean bl2 = false;
            int n2 = -1;
            if (((String)object).startsWith("ok ")) {
                bl2 = true;
                n2 = ((String)object).length();
            } else if (((String)object).startsWith("ng ")) {
                bl2 = false;
                n2 = ((String)object).indexOf(32, 3);
            }
            if (n2 == -1) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedReportLine2, this.uri, object));
            }
            String string3 = ((String)object).substring(3, n2);
            String string4 = bl2 ? null : ((String)object).substring(n2 + 1);
            RemoteRefUpdate remoteRefUpdate = (RemoteRefUpdate)map.get(string3);
            if (remoteRefUpdate == null) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedRefReport, this.uri, string3));
            }
            if (bl2) {
                remoteRefUpdate.setStatus(RemoteRefUpdate$Status.OK);
                continue;
            }
            remoteRefUpdate.setStatus(RemoteRefUpdate$Status.REJECTED_OTHER_REASON);
            remoteRefUpdate.setMessage(string4);
        }
        for (Object object : map.values()) {
            if (((RemoteRefUpdate)object).getStatus() != RemoteRefUpdate$Status.AWAITING_REPORT) continue;
            throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedReportForRefNotReceived, this.uri, ((RemoteRefUpdate)object).getRemoteName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStringLongTimeout() {
        if (this.timeoutIn == null) {
            return this.pckIn.readString();
        }
        int n2 = this.timeoutIn.getTimeout();
        int n3 = (int)Math.min(this.packTransferTime, 28800000L);
        try {
            int n4 = 10 * Math.max(n3, n2);
            this.timeoutIn.setTimeout(n4 < 0 ? Integer.MAX_VALUE : n4);
            String string = this.pckIn.readString();
            return string;
        }
        finally {
            this.timeoutIn.setTimeout(n2);
        }
    }

    public List getPushOptions() {
        return this.pushOptions;
    }
}

