/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.RemoteRepositoryException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevCommitList;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.transport.BasePackConnection;
import org.eclipse.jgit.transport.BasePackFetchConnection$1;
import org.eclipse.jgit.transport.BasePackFetchConnection$2;
import org.eclipse.jgit.transport.BasePackFetchConnection$CancelledException;
import org.eclipse.jgit.transport.BasePackFetchConnection$FetchConfig;
import org.eclipse.jgit.transport.BasePackFetchConnection$FetchStateV2;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.FilterSpec;
import org.eclipse.jgit.transport.GitProtocolConstants$MultiAck;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineIn$AckNackResult;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.SideBandInputStream;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.TransferConfig$ProtocolVersion;
import org.eclipse.jgit.transport.UserAgent;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.TemporaryBuffer$Heap;

public abstract class BasePackFetchConnection
extends BasePackConnection
implements FetchConnection {
    private static final int MAX_HAVES = 256;
    protected static final int MIN_CLIENT_BUFFER = 2952;
    public static final String OPTION_INCLUDE_TAG = "include-tag";
    public static final String OPTION_MULTI_ACK = "multi_ack";
    public static final String OPTION_MULTI_ACK_DETAILED = "multi_ack_detailed";
    public static final String OPTION_THIN_PACK = "thin-pack";
    public static final String OPTION_SIDE_BAND = "side-band";
    public static final String OPTION_SIDE_BAND_64K = "side-band-64k";
    public static final String OPTION_OFS_DELTA = "ofs-delta";
    public static final String OPTION_SHALLOW = "shallow";
    public static final String OPTION_NO_PROGRESS = "no-progress";
    public static final String OPTION_NO_DONE = "no-done";
    public static final String OPTION_ALLOW_TIP_SHA1_IN_WANT = "allow-tip-sha1-in-want";
    public static final String OPTION_ALLOW_REACHABLE_SHA1_IN_WANT = "allow-reachable-sha1-in-want";
    public static final String OPTION_FILTER = "filter";
    private final RevWalk walk;
    private RevCommitList reachableCommits;
    final RevFlag REACHABLE;
    final RevFlag COMMON;
    private final RevFlag STATE;
    final RevFlag ADVERTISED;
    private GitProtocolConstants$MultiAck multiAck = GitProtocolConstants$MultiAck.OFF;
    private boolean thinPack;
    private boolean sideband;
    private boolean includeTags;
    private boolean allowOfsDelta;
    private boolean noDone;
    private boolean noProgress;
    private String lockMessage;
    private PackLock packLock;
    private int maxHaves;
    private TemporaryBuffer$Heap state;
    private PacketLineOut pckState;
    private final FilterSpec filterSpec;

    public BasePackFetchConnection(PackTransport packTransport) {
        super(packTransport);
        if (this.local != null) {
            BasePackFetchConnection$FetchConfig basePackFetchConnection$FetchConfig = this.getFetchConfig();
            this.allowOfsDelta = basePackFetchConnection$FetchConfig.allowOfsDelta;
            this.maxHaves = basePackFetchConnection$FetchConfig.maxHaves;
        } else {
            this.allowOfsDelta = true;
            this.maxHaves = Integer.MAX_VALUE;
        }
        this.includeTags = this.transport.getTagOpt() != TagOpt.NO_TAGS;
        this.thinPack = this.transport.isFetchThin();
        this.filterSpec = this.transport.getFilterSpec();
        if (this.local != null) {
            this.walk = new RevWalk(this.local);
            this.walk.setRetainBody(false);
            this.reachableCommits = new RevCommitList();
            this.REACHABLE = this.walk.newFlag("REACHABLE");
            this.COMMON = this.walk.newFlag("COMMON");
            this.STATE = this.walk.newFlag("STATE");
            this.ADVERTISED = this.walk.newFlag("ADVERTISED");
            this.walk.carry(this.COMMON);
            this.walk.carry(this.REACHABLE);
            this.walk.carry(this.ADVERTISED);
        } else {
            this.walk = null;
            this.REACHABLE = null;
            this.COMMON = null;
            this.STATE = null;
            this.ADVERTISED = null;
        }
    }

    @Override
    public final void fetch(ProgressMonitor progressMonitor, Collection collection, Set set) {
        this.fetch(progressMonitor, collection, set, null);
    }

    @Override
    public final void fetch(ProgressMonitor progressMonitor, Collection collection, Set set, OutputStream outputStream) {
        this.markStartedOperation();
        this.doFetch(progressMonitor, collection, set, outputStream);
    }

    @Override
    public boolean didFetchIncludeTags() {
        return false;
    }

    @Override
    public boolean didFetchTestConnectivity() {
        return false;
    }

    @Override
    public void setPackLockMessage(String string) {
        this.lockMessage = string;
    }

    @Override
    public Collection getPackLocks() {
        if (this.packLock != null) {
            return Collections.singleton(this.packLock);
        }
        return Collections.emptyList();
    }

    private void clearState() {
        this.walk.dispose();
        this.reachableCommits = null;
        this.state = null;
        this.pckState = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFetch(ProgressMonitor progressMonitor, Collection collection, Set set, OutputStream outputStream) {
        try {
            PacketLineOut packetLineOut;
            this.noProgress = progressMonitor == NullProgressMonitor.INSTANCE;
            this.markRefsAdvertised();
            this.markReachable(set, this.maxTimeWanted(collection));
            if (TransferConfig$ProtocolVersion.V2.equals((Object)this.getProtocolVersion())) {
                this.state = new TemporaryBuffer$Heap(Integer.MAX_VALUE);
                this.pckState = new PacketLineOut(this.state);
                try {
                    this.doFetchV2(progressMonitor, collection, outputStream);
                }
                finally {
                    this.clearState();
                }
                return;
            }
            if (this.statelessRPC) {
                this.state = new TemporaryBuffer$Heap(Integer.MAX_VALUE);
                this.pckState = new PacketLineOut(this.state);
            }
            PacketLineOut packetLineOut2 = packetLineOut = this.statelessRPC ? this.pckState : this.pckOut;
            if (this.sendWants(collection, packetLineOut)) {
                packetLineOut.end();
                this.outNeedsEnd = false;
                this.negotiate(progressMonitor);
                this.clearState();
                this.receivePack(progressMonitor, outputStream);
            }
        }
        catch (BasePackFetchConnection$CancelledException basePackFetchConnection$CancelledException) {
            this.close();
            return;
        }
        catch (IOException | RuntimeException exception) {
            this.close();
            throw new TransportException(exception.getMessage(), exception);
        }
    }

    private void doFetchV2(ProgressMonitor progressMonitor, Collection collection, OutputStream outputStream) {
        this.sideband = true;
        this.negotiateBegin();
        this.pckState.writeString("command=fetch");
        String string = UserAgent.get();
        if (string != null && this.isCapableOf("agent")) {
            this.pckState.writeString("agent=" + string);
        }
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = this.getCapability("fetch");
        if (!StringUtils.isEmptyOrNull(string2)) {
            hashSet.addAll(Arrays.asList(string2.split("\\s+")));
        }
        this.pckState.writeDelim();
        for (String string3 : this.getCapabilitiesV2(hashSet)) {
            this.pckState.writeString(string3);
        }
        if (!this.sendWants(collection, this.pckState)) {
            return;
        }
        this.outNeedsEnd = false;
        BasePackFetchConnection$FetchStateV2 basePackFetchConnection$FetchStateV2 = new BasePackFetchConnection$FetchStateV2(null);
        boolean bl2 = false;
        do {
            this.state.writeTo(this.out, progressMonitor);
        } while (!(bl2 = this.sendNextHaveBatch(basePackFetchConnection$FetchStateV2, this.pckOut, progressMonitor)) && !this.readAcknowledgments(basePackFetchConnection$FetchStateV2, this.pckIn, progressMonitor));
        this.clearState();
        String string4 = this.pckIn.readString();
        if (bl2 && string4.startsWith("ERR ")) {
            throw new RemoteRepositoryException(this.uri, string4.substring(4));
        }
        if (!"packfile".equals(string4)) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "packfile", string4));
        }
        this.receivePack(progressMonitor, outputStream);
    }

    private boolean sendNextHaveBatch(BasePackFetchConnection$FetchStateV2 basePackFetchConnection$FetchStateV2, PacketLineOut packetLineOut, ProgressMonitor progressMonitor) {
        RevCommit revCommit;
        long l2 = 0L;
        while (l2 < basePackFetchConnection$FetchStateV2.havesToSend && (revCommit = this.walk.next()) != null) {
            packetLineOut.writeString("have " + revCommit.getId().name() + '\n');
            if (++l2 % 10L != 0L || !progressMonitor.isCancelled()) continue;
            throw new BasePackFetchConnection$CancelledException(null);
        }
        basePackFetchConnection$FetchStateV2.havesTotal += l2;
        if (l2 == 0L || basePackFetchConnection$FetchStateV2.hadAcks && basePackFetchConnection$FetchStateV2.havesWithoutAck > 256L || basePackFetchConnection$FetchStateV2.havesTotal > (long)this.maxHaves) {
            packetLineOut.writeString("done\n");
            packetLineOut.end();
            return true;
        }
        basePackFetchConnection$FetchStateV2.havesWithoutAck += l2;
        packetLineOut.end();
        basePackFetchConnection$FetchStateV2.incHavesToSend(this.statelessRPC);
        return false;
    }

    private boolean readAcknowledgments(BasePackFetchConnection$FetchStateV2 basePackFetchConnection$FetchStateV2, PacketLineIn packetLineIn, ProgressMonitor progressMonitor) {
        String string = packetLineIn.readString();
        if (!"acknowledgments".equals(string)) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "acknowledgments", string));
        }
        MutableObjectId mutableObjectId = new MutableObjectId();
        string = packetLineIn.readString();
        boolean bl2 = false;
        long l2 = 0L;
        while (!PacketLineIn.isEnd(string) && !PacketLineIn.isDelimiter(string)) {
            PacketLineIn$AckNackResult packetLineIn$AckNackResult = PacketLineIn.parseACKv2(string, mutableObjectId);
            if (!bl2) {
                if (packetLineIn$AckNackResult == PacketLineIn$AckNackResult.ACK_COMMON) {
                    this.markCommon(this.walk.parseAny(mutableObjectId), packetLineIn$AckNackResult, true);
                    basePackFetchConnection$FetchStateV2.havesWithoutAck = 0L;
                    basePackFetchConnection$FetchStateV2.hadAcks = true;
                } else if (packetLineIn$AckNackResult == PacketLineIn$AckNackResult.ACK_READY) {
                    bl2 = true;
                }
            }
            if (++l2 % 10L == 0L && progressMonitor.isCancelled()) {
                throw new BasePackFetchConnection$CancelledException(null);
            }
            string = packetLineIn.readString();
        }
        if (bl2) {
            if (!PacketLineIn.isDelimiter(string)) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "0001", string));
            }
        } else if (!PacketLineIn.isEnd(string)) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "0000", string));
        }
        return bl2;
    }

    @Override
    public void close() {
        if (this.walk != null) {
            this.walk.close();
        }
        super.close();
    }

    BasePackFetchConnection$FetchConfig getFetchConfig() {
        return (BasePackFetchConnection$FetchConfig)this.local.getConfig().get(BasePackFetchConnection$FetchConfig::new);
    }

    private int maxTimeWanted(Collection collection) {
        int n2 = 0;
        for (Ref ref : collection) {
            try {
                int n3;
                RevObject revObject = this.walk.parseAny(ref.getObjectId());
                if (!(revObject instanceof RevCommit) || n2 >= (n3 = ((RevCommit)revObject).getCommitTime())) continue;
                n2 = n3;
            }
            catch (IOException iOException) {}
        }
        return n2;
    }

    private void markReachable(Set set, int n2) {
        for (Object object : this.local.getRefDatabase().getRefs()) {
            ObjectId objectId = object.getPeeledObjectId();
            if (objectId == null) {
                objectId = object.getObjectId();
            }
            if (objectId == null) continue;
            this.parseReachable(objectId);
        }
        for (Object object : this.local.getAdditionalHaves()) {
            this.parseReachable((ObjectId)object);
        }
        for (Object object : set) {
            this.parseReachable((ObjectId)object);
        }
        if (n2 > 0) {
            Object object;
            Date date = new Date((long)n2 * 1000L);
            this.walk.sort(RevSort.COMMIT_TIME_DESC);
            this.walk.markStart(this.reachableCommits);
            this.walk.setRevFilter(CommitTimeRevFilter.after(date));
            while ((object = this.walk.next()) != null) {
                if (!((RevObject)object).has(this.ADVERTISED) || ((RevObject)object).has(this.COMMON)) continue;
                ((RevObject)object).add(this.COMMON);
                ((RevCommit)object).carry(this.COMMON);
                this.reachableCommits.add(object);
            }
        }
    }

    private void parseReachable(ObjectId objectId) {
        try {
            RevCommit revCommit = this.walk.parseCommit(objectId);
            if (!revCommit.has(this.REACHABLE)) {
                revCommit.add(this.REACHABLE);
                this.reachableCommits.add(revCommit);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean sendWants(Collection collection, PacketLineOut packetLineOut) {
        boolean bl2 = true;
        for (Ref ref : collection) {
            ObjectId objectId = ref.getObjectId();
            if (objectId == null) continue;
            try {
                if (this.walk.parseAny(objectId).has(this.REACHABLE)) {
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            StringBuilder stringBuilder = new StringBuilder(46);
            stringBuilder.append("want ");
            stringBuilder.append(objectId.name());
            if (bl2 && TransferConfig$ProtocolVersion.V0.equals((Object)this.getProtocolVersion())) {
                stringBuilder.append(this.enableCapabilities());
            }
            bl2 = false;
            stringBuilder.append('\n');
            packetLineOut.writeString(stringBuilder.toString());
        }
        if (bl2) {
            return false;
        }
        if (!this.filterSpec.isNoOp()) {
            packetLineOut.writeString(this.filterSpec.filterLine());
        }
        return true;
    }

    private Set getCapabilitiesV2(Set set) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (this.noProgress) {
            linkedHashSet.add(OPTION_NO_PROGRESS);
        }
        if (this.includeTags) {
            linkedHashSet.add(OPTION_INCLUDE_TAG);
        }
        if (this.allowOfsDelta) {
            linkedHashSet.add(OPTION_OFS_DELTA);
        }
        if (this.thinPack) {
            linkedHashSet.add(OPTION_THIN_PACK);
        }
        if (!this.filterSpec.isNoOp() && !set.contains(OPTION_FILTER)) {
            throw new PackProtocolException(this.uri, JGitText.get().filterRequiresCapability);
        }
        return linkedHashSet;
    }

    private String enableCapabilities() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.noProgress) {
            this.wantCapability(stringBuilder, OPTION_NO_PROGRESS);
        }
        if (this.includeTags) {
            this.includeTags = this.wantCapability(stringBuilder, OPTION_INCLUDE_TAG);
        }
        if (this.allowOfsDelta) {
            this.wantCapability(stringBuilder, OPTION_OFS_DELTA);
        }
        if (this.wantCapability(stringBuilder, OPTION_MULTI_ACK_DETAILED)) {
            this.multiAck = GitProtocolConstants$MultiAck.DETAILED;
            if (this.statelessRPC) {
                this.noDone = this.wantCapability(stringBuilder, OPTION_NO_DONE);
            }
        } else {
            this.multiAck = this.wantCapability(stringBuilder, OPTION_MULTI_ACK) ? GitProtocolConstants$MultiAck.CONTINUE : GitProtocolConstants$MultiAck.OFF;
        }
        if (this.thinPack) {
            this.thinPack = this.wantCapability(stringBuilder, OPTION_THIN_PACK);
        }
        if (this.wantCapability(stringBuilder, OPTION_SIDE_BAND_64K)) {
            this.sideband = true;
        } else if (this.wantCapability(stringBuilder, OPTION_SIDE_BAND)) {
            this.sideband = true;
        }
        if (this.statelessRPC && this.multiAck != GitProtocolConstants$MultiAck.DETAILED) {
            throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().statelessRPCRequiresOptionToBeEnabled, OPTION_MULTI_ACK_DETAILED));
        }
        if (!this.filterSpec.isNoOp() && !this.wantCapability(stringBuilder, OPTION_FILTER)) {
            throw new PackProtocolException(this.uri, JGitText.get().filterRequiresCapability);
        }
        this.addUserAgentCapability(stringBuilder);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void negotiate(ProgressMonitor progressMonitor) {
        Object object;
        MutableObjectId mutableObjectId = new MutableObjectId();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.statelessRPC) {
            this.state.writeTo(this.out, null);
        }
        this.negotiateBegin();
        block10: while ((object = this.walk.next()) != null) {
            ObjectId objectId = ((RevObject)object).getId();
            this.pckOut.writeString("have " + objectId.name() + "\n");
            ++n4;
            if ((0x1F & ++n3) != 0) continue;
            if (progressMonitor.isCancelled()) {
                throw new BasePackFetchConnection$CancelledException(null);
            }
            this.pckOut.end();
            ++n2;
            if (n3 == 32 && !this.statelessRPC) continue;
            block11: while (true) {
                PacketLineIn$AckNackResult packetLineIn$AckNackResult = this.pckIn.readACK(mutableObjectId);
                switch (packetLineIn$AckNackResult) {
                    case NAK: {
                        --n2;
                        break block11;
                    }
                    case ACK: {
                        this.multiAck = GitProtocolConstants$MultiAck.OFF;
                        n2 = 0;
                        bl3 = true;
                        if (!this.statelessRPC) break block10;
                        this.state.writeTo(this.out, null);
                        break block10;
                    }
                    case ACK_CONTINUE: 
                    case ACK_COMMON: 
                    case ACK_READY: {
                        this.markCommon(this.walk.parseAny(mutableObjectId), packetLineIn$AckNackResult, this.statelessRPC);
                        bl3 = true;
                        bl2 = true;
                        n4 = 0;
                        if (packetLineIn$AckNackResult == PacketLineIn$AckNackResult.ACK_READY) {
                            bl4 = true;
                        }
                    }
                    default: {
                        if (!progressMonitor.isCancelled()) continue block11;
                        throw new BasePackFetchConnection$CancelledException(null);
                    }
                }
                break;
            }
            if (this.noDone && bl4) break;
            if (this.statelessRPC) {
                this.state.writeTo(this.out, null);
            }
            if ((!bl2 || n4 <= 256) && n3 < this.maxHaves) continue;
        }
        if (progressMonitor.isCancelled()) {
            throw new BasePackFetchConnection$CancelledException(null);
        }
        if (!bl4 || !this.noDone) {
            this.pckOut.writeString("done\n");
            this.pckOut.flush();
        }
        if (!bl3) {
            this.multiAck = GitProtocolConstants$MultiAck.OFF;
            ++n2;
        }
        do {
            if (n2 <= 0) {
                if (this.multiAck == GitProtocolConstants$MultiAck.OFF) return;
            }
            object = this.pckIn.readACK(mutableObjectId);
            --n2;
            switch (BasePackFetchConnection$2.$SwitchMap$org$eclipse$jgit$transport$PacketLineIn$AckNackResult[((Enum)object).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.multiAck = GitProtocolConstants$MultiAck.CONTINUE;
                }
            }
        } while (!progressMonitor.isCancelled());
        throw new BasePackFetchConnection$CancelledException(null);
    }

    private void negotiateBegin() {
        this.walk.resetRetain(this.REACHABLE, this.ADVERTISED);
        this.walk.markStart(this.reachableCommits);
        this.walk.sort(RevSort.COMMIT_TIME_DESC);
        this.walk.setRevFilter(new BasePackFetchConnection$1(this));
    }

    private void markRefsAdvertised() {
        for (Ref ref : this.getRefs()) {
            this.markAdvertised(ref.getObjectId());
            if (ref.getPeeledObjectId() == null) continue;
            this.markAdvertised(ref.getPeeledObjectId());
        }
    }

    private void markAdvertised(AnyObjectId anyObjectId) {
        try {
            this.walk.parseAny(anyObjectId).add(this.ADVERTISED);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void markCommon(RevObject revObject, PacketLineIn$AckNackResult packetLineIn$AckNackResult, boolean bl2) {
        if (bl2 && packetLineIn$AckNackResult == PacketLineIn$AckNackResult.ACK_COMMON && !revObject.has(this.STATE)) {
            this.pckState.writeString("have " + revObject.name() + '\n');
            revObject.add(this.STATE);
        }
        revObject.add(this.COMMON);
        if (revObject instanceof RevCommit) {
            ((RevCommit)revObject).carry(this.COMMON);
        }
    }

    private void receivePack(ProgressMonitor progressMonitor, OutputStream outputStream) {
        this.onReceivePack();
        InputStream inputStream = this.in;
        if (this.sideband) {
            inputStream = new SideBandInputStream(inputStream, progressMonitor, this.getMessageWriter(), outputStream);
        }
        try (ObjectInserter objectInserter = this.local.newObjectInserter();){
            PackParser packParser = objectInserter.newPackParser(inputStream);
            packParser.setAllowThin(this.thinPack);
            packParser.setObjectChecker(this.transport.getObjectChecker());
            packParser.setLockMessage(this.lockMessage);
            this.packLock = packParser.parse(progressMonitor);
            objectInserter.flush();
        }
    }

    protected void onReceivePack() {
    }
}

