/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.RemoteRepositoryException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledNonTag;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledTag;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.transport.BaseConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TransferConfig$ProtocolVersion;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UserAgent;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.io.InterruptTimer;
import org.eclipse.jgit.util.io.TimeoutInputStream;
import org.eclipse.jgit.util.io.TimeoutOutputStream;

abstract class BasePackConnection
extends BaseConnection {
    protected static final String CAPABILITY_SYMREF_PREFIX = "symref=";
    protected final Repository local;
    protected final URIish uri;
    protected final Transport transport;
    protected TimeoutInputStream timeoutIn;
    protected TimeoutOutputStream timeoutOut;
    private InterruptTimer myTimer;
    protected InputStream in;
    protected OutputStream out;
    protected PacketLineIn pckIn;
    protected PacketLineOut pckOut;
    protected boolean outNeedsEnd;
    protected boolean statelessRPC;
    private final Map remoteCapabilities = new HashMap();
    protected final Set additionalHaves = new HashSet();
    private TransferConfig$ProtocolVersion protocol = TransferConfig$ProtocolVersion.V0;

    BasePackConnection(PackTransport packTransport) {
        this.transport = (Transport)((Object)packTransport);
        this.local = this.transport.local;
        this.uri = this.transport.uri;
    }

    TransferConfig$ProtocolVersion getProtocolVersion() {
        return this.protocol;
    }

    void setProtocolVersion(@NonNull TransferConfig$ProtocolVersion transferConfig$ProtocolVersion) {
        this.protocol = transferConfig$ProtocolVersion;
    }

    protected final void init(InputStream inputStream, OutputStream outputStream) {
        int n2 = this.transport.getTimeout();
        if (n2 > 0) {
            Thread thread = Thread.currentThread();
            if (this.myTimer == null) {
                this.myTimer = new InterruptTimer(thread.getName() + "-Timer");
            }
            this.timeoutIn = new TimeoutInputStream(inputStream, this.myTimer);
            this.timeoutOut = new TimeoutOutputStream(outputStream, this.myTimer);
            this.timeoutIn.setTimeout(n2 * 1000);
            this.timeoutOut.setTimeout(n2 * 1000);
            inputStream = this.timeoutIn;
            outputStream = this.timeoutOut;
        }
        this.in = inputStream;
        this.out = outputStream;
        this.pckIn = new PacketLineIn(this.in);
        this.pckOut = new PacketLineOut(this.out);
        this.outNeedsEnd = true;
    }

    protected boolean readAdvertisedRefs() {
        try {
            return this.readAdvertisedRefsImpl();
        }
        catch (TransportException transportException) {
            this.close();
            throw transportException;
        }
        catch (IOException | RuntimeException exception) {
            this.close();
            throw new TransportException(exception.getMessage(), exception);
        }
    }

    private String readLine() {
        String string = this.pckIn.readString();
        if (PacketLineIn.isEnd(string)) {
            return null;
        }
        if (string.startsWith("ERR ")) {
            throw new RemoteRepositoryException(this.uri, string.substring(4));
        }
        return string;
    }

    private boolean readAdvertisedRefsImpl() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        boolean bl2 = true;
        while (true) {
            String string;
            if (bl2) {
                boolean bl3 = false;
                try {
                    string = this.readLine();
                }
                catch (EOFException eOFException) {
                    throw this.noRepository(eOFException);
                }
                if (string != null && "version 1".equals(string)) {
                    this.setProtocolVersion(TransferConfig$ProtocolVersion.V0);
                    bl3 = true;
                    string = this.readLine();
                }
                if (string == null) break;
                int n2 = string.indexOf(0);
                if (n2 >= 0) {
                    for (String string2 : string.substring(n2 + 1).split(" ")) {
                        if (string2.startsWith(CAPABILITY_SYMREF_PREFIX)) {
                            String[] stringArray = string2.substring(CAPABILITY_SYMREF_PREFIX.length()).split(":", 2);
                            if (stringArray.length != 2) continue;
                            linkedHashMap2.put(stringArray[0], stringArray[1]);
                            continue;
                        }
                        this.addCapability(string2);
                    }
                    string = string.substring(0, n2);
                    this.setProtocolVersion(TransferConfig$ProtocolVersion.V0);
                } else {
                    if (!bl3 && "version 2".equals(string)) {
                        this.setProtocolVersion(TransferConfig$ProtocolVersion.V2);
                        this.readCapabilitiesV2();
                        return false;
                    }
                    this.setProtocolVersion(TransferConfig$ProtocolVersion.V0);
                }
            } else {
                string = this.readLine();
                if (string == null) break;
            }
            if (string.length() < 41 || string.charAt(40) != ' ') {
                throw this.invalidRefAdvertisementLine(string);
            }
            String string3 = string.substring(41, string.length());
            if (!bl2 || !string3.equals("capabilities^{}")) {
                ObjectId objectId = this.toId(string, string.substring(0, 40));
                if (string3.equals(".have")) {
                    this.additionalHaves.add(objectId);
                } else {
                    this.processLineV1(string3, objectId, linkedHashMap);
                }
            }
            bl2 = false;
        }
        BasePackConnection.updateWithSymRefs(linkedHashMap, linkedHashMap2);
        this.available(linkedHashMap);
        return true;
    }

    protected void lsRefs(Collection collection, String ... stringArray) {
        try {
            this.lsRefsImpl(collection, stringArray);
        }
        catch (TransportException transportException) {
            this.close();
            throw transportException;
        }
        catch (IOException | RuntimeException exception) {
            this.close();
            throw new TransportException(exception.getMessage(), exception);
        }
    }

    private void lsRefsImpl(Collection collection, String ... stringArray) {
        String string;
        Object object2;
        this.pckOut.writeString("command=ls-refs");
        String string2 = UserAgent.get();
        if (string2 != null && this.isCapableOf("agent")) {
            this.pckOut.writeString("agent=" + string2);
        }
        this.pckOut.writeDelim();
        this.pckOut.writeString("peel");
        this.pckOut.writeString("symrefs");
        for (Object object2 : this.getRefPrefixes(collection, stringArray)) {
            this.pckOut.writeString("ref-prefix " + (String)object2);
        }
        this.pckOut.end();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        object2 = new LinkedHashMap();
        while ((string = this.readLine()) != null) {
            if (string.length() < 41 || string.charAt(40) != ' ') {
                throw this.invalidRefAdvertisementLine(string);
            }
            String string3 = string.substring(41, string.length());
            ObjectId objectId = this.toId(string, string.substring(0, 40));
            if (string3.equals(".have")) {
                this.additionalHaves.add(objectId);
                continue;
            }
            this.processLineV2(string, objectId, string3, linkedHashMap, (Map)object2);
        }
        BasePackConnection.updateWithSymRefs(linkedHashMap, (Map)object2);
        this.available(linkedHashMap);
    }

    private Collection getRefPrefixes(Collection collection, String ... stringArray) {
        if (collection.isEmpty() && (stringArray == null || stringArray.length == 0)) {
            return Collections.emptyList();
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray != null) {
            Arrays.stream(stringArray).filter(Objects::nonNull).forEach(hashSet::add);
        }
        for (RefSpec refSpec : collection) {
            String string = refSpec.getSource();
            if (ObjectId.isId(string)) continue;
            if (refSpec.isWildcard()) {
                hashSet.add(string.substring(0, string.indexOf(42)));
                continue;
            }
            hashSet.add(string);
            hashSet.add("refs/" + string);
            hashSet.add("refs/heads/" + string);
            hashSet.add("refs/tags/" + string);
        }
        return hashSet;
    }

    private void readCapabilitiesV2() {
        String string;
        while ((string = this.readLine()) != null) {
            this.addCapability(string);
        }
    }

    private void addCapability(String string) {
        String[] stringArray = string.split("=", 2);
        if (stringArray.length == 2) {
            this.remoteCapabilities.put(stringArray[0], stringArray[1]);
        }
        this.remoteCapabilities.put(string, null);
    }

    private ObjectId toId(String string, String string2) {
        try {
            return ObjectId.fromString(string2);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            PackProtocolException packProtocolException = this.invalidRefAdvertisementLine(string);
            packProtocolException.initCause(invalidObjectIdException);
            throw packProtocolException;
        }
    }

    private void processLineV1(String string, ObjectId objectId, Map map) {
        if (string.endsWith("^{}")) {
            Ref ref = (Ref)map.get(string = string.substring(0, string.length() - 3));
            if (ref == null) {
                throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().advertisementCameBefore, string, string));
            }
            if (ref.getPeeledObjectId() != null) {
                throw this.duplicateAdvertisement(string + "^{}");
            }
            map.put(string, new ObjectIdRef$PeeledTag(Ref$Storage.NETWORK, string, ref.getObjectId(), objectId));
        } else {
            Ref ref = map.put(string, new ObjectIdRef$PeeledNonTag(Ref$Storage.NETWORK, string, objectId));
            if (ref != null) {
                throw this.duplicateAdvertisement(string);
            }
        }
    }

    private void processLineV2(String string, ObjectId objectId, String string2, Map map, Map map2) {
        ObjectIdRef objectIdRef;
        Ref ref;
        String[] stringArray = string2.split(" ");
        String string3 = stringArray[0];
        String string4 = null;
        String string5 = null;
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].startsWith("symref-target:")) {
                if (string4 != null) {
                    throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().duplicateRefAttribute, string));
                }
                string4 = stringArray[i2].substring("symref-target:".length());
            } else if (stringArray[i2].startsWith("peeled:")) {
                if (string5 != null) {
                    throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().duplicateRefAttribute, string));
                }
                string5 = stringArray[i2].substring("peeled:".length());
            }
            if (string5 != null && string4 != null) break;
        }
        if ((ref = (Ref)map.put(string3, objectIdRef = string5 != null ? new ObjectIdRef$PeeledTag(Ref$Storage.NETWORK, string3, objectId, this.toId(string, string5)) : new ObjectIdRef$PeeledNonTag(Ref$Storage.NETWORK, string3, objectId))) != null) {
            throw this.duplicateAdvertisement(string3);
        }
        if (!StringUtils.isEmptyOrNull(string4)) {
            map2.put(string3, string4);
        }
    }

    static void updateWithSymRefs(Map map, Map map2) {
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        boolean bl3 = bl2 = !map.isEmpty();
        while (!map2.isEmpty() && bl2) {
            bl2 = false;
            object3 = map2.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                if (map2.containsKey(object2.getValue()) || (object = (Ref)map.get(object2.getValue())) == null) continue;
                map.put(object2.getKey(), new SymbolicRef((String)object2.getKey(), (Ref)object));
                bl2 = true;
                object3.remove();
            }
        }
        object3 = (String)map2.get("HEAD");
        if (object3 != null && !map.containsKey(object3) && (object2 = (Ref)map.get("HEAD")) != null) {
            object = object2.getObjectId();
            object2 = new ObjectIdRef$PeeledNonTag(Ref$Storage.NETWORK, (String)object3, (ObjectId)object);
            map.put(object3, object2);
            object2 = new SymbolicRef("HEAD", (Ref)object2);
            map.put("HEAD", object2);
            map2.remove("HEAD");
        }
    }

    protected TransportException noRepository(Throwable throwable) {
        return new NoRemoteRepositoryException(this.uri, JGitText.get().notFound, throwable);
    }

    protected boolean isCapableOf(String string) {
        return this.remoteCapabilities.containsKey(string);
    }

    protected boolean wantCapability(StringBuilder stringBuilder, String string) {
        if (!this.isCapableOf(string)) {
            return false;
        }
        stringBuilder.append(' ');
        stringBuilder.append(string);
        return true;
    }

    protected String getCapability(String string) {
        return (String)this.remoteCapabilities.get(string);
    }

    protected void addUserAgentCapability(StringBuilder stringBuilder) {
        String string = UserAgent.get();
        if (string != null && this.remoteCapabilities.get("agent") != null) {
            stringBuilder.append(' ').append("agent").append('=').append(string);
        }
    }

    @Override
    public String getPeerUserAgent() {
        String string = (String)this.remoteCapabilities.get("agent");
        return string != null ? string : super.getPeerUserAgent();
    }

    private PackProtocolException duplicateAdvertisement(String string) {
        return new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().duplicateAdvertisementsOf, string));
    }

    private PackProtocolException invalidRefAdvertisementLine(String string) {
        return new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().invalidRefAdvertisementLine, string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.out != null) {
            try {
                if (this.outNeedsEnd) {
                    this.outNeedsEnd = false;
                    this.pckOut.end();
                }
                this.out.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.out = null;
                this.pckOut = null;
            }
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.in = null;
                this.pckIn = null;
            }
        }
        if (this.myTimer != null) {
            try {
                this.myTimer.terminate();
            }
            finally {
                this.myTimer = null;
                this.timeoutIn = null;
                this.timeoutOut = null;
            }
        }
    }

    protected void endOut() {
        if (this.outNeedsEnd && this.out != null) {
            try {
                this.outNeedsEnd = false;
                this.pckOut.end();
            }
            catch (IOException iOException) {
                try {
                    this.out.close();
                }
                catch (IOException iOException2) {
                }
                finally {
                    this.out = null;
                    this.pckOut = null;
                }
            }
        }
    }
}

