/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.Connection;

public abstract class BaseConnection
implements Connection {
    private Map advertisedRefs = Collections.emptyMap();
    private String peerUserAgent;
    private boolean startedOperation;
    private Writer messageWriter;

    @Override
    public Map getRefsMap() {
        return this.advertisedRefs;
    }

    @Override
    public final Collection getRefs() {
        return this.advertisedRefs.values();
    }

    @Override
    public final Ref getRef(String string) {
        return (Ref)this.advertisedRefs.get(string);
    }

    @Override
    public String getMessages() {
        return this.messageWriter != null ? this.messageWriter.toString() : "";
    }

    @Override
    public String getPeerUserAgent() {
        return this.peerUserAgent;
    }

    protected void setPeerUserAgent(String string) {
        this.peerUserAgent = string;
    }

    @Override
    public abstract void close();

    protected void available(Map map) {
        this.advertisedRefs = Collections.unmodifiableMap(map);
    }

    protected void markStartedOperation() {
        if (this.startedOperation) {
            throw new TransportException(JGitText.get().onlyOneOperationCallPerConnectionIsSupported);
        }
        this.startedOperation = true;
    }

    protected Writer getMessageWriter() {
        if (this.messageWriter == null) {
            this.setMessageWriter(new StringWriter());
        }
        return this.messageWriter;
    }

    protected void setMessageWriter(Writer writer) {
        if (this.messageWriter != null) {
            throw new IllegalStateException(JGitText.get().writerAlreadyInitialized);
        }
        this.messageWriter = writer;
    }
}

