/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.Hex;
import org.eclipse.jgit.util.HttpSupport;

public final class AwsRequestSignerV4 {
    private static final String ALGORITHM = "HMAC-SHA256";
    private static final String MAC_ALGORITHM = "HmacSHA256";
    private static final String SCHEME = "AWS4";
    private static final String TERMINATOR = "aws4_request";
    private static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    private static final DateTimeFormatter AMZ_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'");
    private static final DateTimeFormatter SCOPE_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd");

    private AwsRequestSignerV4() {
    }

    public static void sign(HttpURLConnection httpURLConnection, Map map, long l2, String string2, String string3, String string4, String string5, char[] cArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        httpURLConnection.getRequestProperties().forEach((string, list) -> hashMap.put((String)string, String.join((CharSequence)",", list)));
        if (l2 > 0L) {
            hashMap.put("Content-Length", String.valueOf(l2));
        } else {
            string2 = EMPTY_BODY_SHA256;
        }
        hashMap.put("x-amz-content-sha256", string2);
        OffsetDateTime offsetDateTime = Instant.now().atOffset(ZoneOffset.UTC);
        String string6 = offsetDateTime.format(AMZ_DATE_FORMAT);
        hashMap.put("x-amz-date", string6);
        URL uRL = httpURLConnection.getURL();
        int n2 = uRL.getPort();
        String string7 = n2 > -1 ? uRL.getHost().concat(":" + n2) : uRL.getHost();
        hashMap.put("Host", string7);
        String string8 = AwsRequestSignerV4.getCanonicalizeHeaderNames(hashMap);
        String string9 = AwsRequestSignerV4.getCanonicalizedHeaderString(hashMap);
        String string10 = AwsRequestSignerV4.getCanonicalizedQueryString(map);
        String string11 = httpURLConnection.getRequestMethod();
        String string12 = string11 + '\n' + AwsRequestSignerV4.getCanonicalizedResourcePath(uRL) + '\n' + string10 + '\n' + string9 + '\n' + string8 + '\n' + string2;
        String string13 = offsetDateTime.format(SCOPE_DATE_FORMAT);
        String string14 = string13 + '/' + string4 + '/' + string3 + '/' + TERMINATOR;
        String string15 = "AWS4-HMAC-SHA256\n" + string6 + '\n' + string14 + '\n' + Hex.toHexString(AwsRequestSignerV4.hash(string12.getBytes(StandardCharsets.UTF_8)));
        byte[] byArray = (SCHEME + new String(cArray)).getBytes();
        byte[] byArray2 = AwsRequestSignerV4.signStringWithKey(string13, byArray);
        byte[] byArray3 = AwsRequestSignerV4.signStringWithKey(string4, byArray2);
        byte[] byArray4 = AwsRequestSignerV4.signStringWithKey(string3, byArray3);
        byte[] byArray5 = AwsRequestSignerV4.signStringWithKey(TERMINATOR, byArray4);
        byte[] byArray6 = AwsRequestSignerV4.signStringWithKey(string15, byArray5);
        String string16 = "Credential=" + string5 + '/' + string14;
        String string17 = "SignedHeaders=" + string8;
        String string18 = "Signature=" + Hex.toHexString(byArray6);
        String string19 = "AWS4-HMAC-SHA256 " + string16 + ", " + string17 + ", " + string18;
        hashMap.forEach(httpURLConnection::setRequestProperty);
        httpURLConnection.setRequestProperty("Authorization", string19);
    }

    public static String calculateBodyHash(byte[] byArray) {
        return byArray == null || byArray.length < 1 ? EMPTY_BODY_SHA256 : Hex.toHexString(AwsRequestSignerV4.hash(byArray));
    }

    private static String getCanonicalizeHeaderNames(Map map) {
        return map.keySet().stream().map(String::toLowerCase).sorted().collect(Collectors.joining(";"));
    }

    private static String getCanonicalizedHeaderString(Map map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        map.keySet().stream().sorted(String.CASE_INSENSITIVE_ORDER).forEach(string -> {
            String string2 = string.toLowerCase().replaceAll("\\s+", " ");
            String string3 = ((String)map.get(string)).replaceAll("\\s+", " ");
            stringBuilder.append(string2).append(':').append(string3).append('\n');
        });
        return stringBuilder.toString();
    }

    private static String getCanonicalizedResourcePath(URL uRL) {
        if (uRL == null) {
            return "/";
        }
        String string = uRL.getPath();
        if (string == null || string.isEmpty()) {
            return "/";
        }
        String string2 = HttpSupport.urlEncode(string, true);
        if (string2.startsWith("/")) {
            return string2;
        }
        return "/".concat(string2);
    }

    public static String getCanonicalizedQueryString(Map map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        return map.keySet().stream().sorted().map(string -> HttpSupport.urlEncode(string, false) + '=' + HttpSupport.urlEncode((String)map.get(string), false)).collect(Collectors.joining("&"));
    }

    public static byte[] hash(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (Exception exception) {
            throw new RuntimeException(JGitText.get().couldNotHashByteArrayWithSha256, exception);
        }
    }

    private static byte[] signStringWithKey(String string, byte[] byArray) {
        try {
            byte[] byArray2 = string.getBytes(StandardCharsets.UTF_8);
            Mac mac = Mac.getInstance(MAC_ALGORITHM);
            mac.init(new SecretKeySpec(byArray, MAC_ALGORITHM));
            return mac.doFinal(byArray2);
        }
        catch (Exception exception) {
            throw new RuntimeException(JGitText.get().couldNotSignStringWithKey, exception);
        }
    }
}

