/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.AmazonS3$1;
import org.eclipse.jgit.transport.AmazonS3$KeyInfo;
import org.eclipse.jgit.transport.AmazonS3$ListParser;
import org.eclipse.jgit.transport.AwsRequestSignerV4;
import org.eclipse.jgit.transport.WalkEncryption;
import org.eclipse.jgit.util.Base64;
import org.eclipse.jgit.util.HttpSupport;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.TemporaryBuffer;

public class AmazonS3 {
    private static final Set SIGNED_HEADERS = new HashSet();
    private static final String AWS_API_V2 = "2";
    private static final String AWS_API_V4 = "4";
    private static final String AWS_S3_SERVICE_NAME = "s3";
    private static final String HMAC = "HmacSHA1";
    private static final String X_AMZ_ACL = "x-amz-acl";
    private static final String X_AMZ_META = "x-amz-meta-";
    private final String awsApiSignatureVersion;
    private final String publicKey;
    private final SecretKeySpec secretKeySpec;
    private final char[] secretKey;
    private final ProxySelector proxySelector;
    private final String acl;
    final int maxAttempts;
    private final WalkEncryption encryption;
    private final File tmpDir;
    private final String domain;
    private final String region;

    private static boolean isSignedHeader(String string) {
        String string2 = StringUtils.toLowerCase(string);
        return SIGNED_HEADERS.contains(string2) || string2.startsWith("x-amz-");
    }

    private static String toCleanString(List list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string.replaceAll("\n", "").trim());
        }
        return stringBuilder.toString();
    }

    private static String remove(Map map, String string) {
        String string2 = (String)map.remove(string);
        return string2 != null ? string2 : "";
    }

    private static String httpNow() {
        String string = "GMT";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date()) + " " + "GMT";
    }

    private static MessageDigest newMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(JGitText.get().JRELacksMD5Implementation, noSuchAlgorithmException);
        }
    }

    public AmazonS3(Properties properties) {
        this.awsApiSignatureVersion = properties.getProperty("aws.api.signature.version", AWS_API_V2);
        if (this.awsApiSignatureVersion.equals(AWS_API_V4)) {
            this.region = properties.getProperty("region");
            if (this.region == null) {
                throw new IllegalArgumentException(JGitText.get().missingAwsRegion);
            }
        } else if (this.awsApiSignatureVersion.equals(AWS_API_V2)) {
            this.region = null;
        } else {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidAwsApiSignatureVersion, this.awsApiSignatureVersion));
        }
        this.domain = properties.getProperty("domain", "s3.amazonaws.com");
        this.publicKey = properties.getProperty("accesskey");
        if (this.publicKey == null) {
            throw new IllegalArgumentException(JGitText.get().missingAccesskey);
        }
        String string = properties.getProperty("secretkey");
        if (string == null) {
            throw new IllegalArgumentException(JGitText.get().missingSecretkey);
        }
        this.secretKeySpec = new SecretKeySpec(Constants.encodeASCII(string), HMAC);
        this.secretKey = string.toCharArray();
        String string2 = properties.getProperty("acl", "PRIVATE");
        if (StringUtils.equalsIgnoreCase("PRIVATE", string2)) {
            this.acl = "private";
        } else if (StringUtils.equalsIgnoreCase("PUBLIC", string2)) {
            this.acl = "public-read";
        } else if (StringUtils.equalsIgnoreCase("PUBLIC-READ", string2)) {
            this.acl = "public-read";
        } else if (StringUtils.equalsIgnoreCase("PUBLIC_READ", string2)) {
            this.acl = "public-read";
        } else {
            throw new IllegalArgumentException("Invalid acl: " + string2);
        }
        try {
            this.encryption = WalkEncryption.instance(properties);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalArgumentException(JGitText.get().invalidEncryption, generalSecurityException);
        }
        this.maxAttempts = Integer.parseInt(properties.getProperty("httpclient.retry-max", "3"));
        this.proxySelector = ProxySelector.getDefault();
        String string3 = properties.getProperty("tmpdir");
        this.tmpDir = string3 != null && string3.length() > 0 ? new File(string3) : null;
    }

    public URLConnection get(String string, String string2) {
        block5: for (int i2 = 0; i2 < this.maxAttempts; ++i2) {
            HttpURLConnection httpURLConnection = this.open("GET", string, string2);
            this.authorize(httpURLConnection, Collections.emptyMap(), 0L, null);
            switch (HttpSupport.response(httpURLConnection)) {
                case 200: {
                    this.encryption.validate(httpURLConnection, X_AMZ_META);
                    return httpURLConnection;
                }
                case 404: {
                    throw new FileNotFoundException(string2);
                }
                case 500: {
                    continue block5;
                }
                default: {
                    throw this.error(JGitText.get().s3ActionReading, string2, httpURLConnection);
                }
            }
        }
        throw this.maxAttempts(JGitText.get().s3ActionReading, string2);
    }

    public InputStream decrypt(URLConnection uRLConnection) {
        return this.encryption.decrypt(uRLConnection.getInputStream());
    }

    public List list(String string, String string2) {
        if (string2.length() > 0 && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        AmazonS3$ListParser amazonS3$ListParser = new AmazonS3$ListParser(this, string, string2);
        do {
            amazonS3$ListParser.list();
        } while (amazonS3$ListParser.truncated);
        Comparator<AmazonS3$KeyInfo> comparator = Comparator.comparingLong(AmazonS3$KeyInfo::getLastModifiedSecs);
        return amazonS3$ListParser.entries.stream().sorted(comparator.reversed()).map(AmazonS3$KeyInfo::getName).collect(Collectors.toList());
    }

    public void delete(String string, String string2) {
        block4: for (int i2 = 0; i2 < this.maxAttempts; ++i2) {
            HttpURLConnection httpURLConnection = this.open("DELETE", string, string2);
            this.authorize(httpURLConnection, Collections.emptyMap(), 0L, null);
            switch (HttpSupport.response(httpURLConnection)) {
                case 204: {
                    return;
                }
                case 500: {
                    continue block4;
                }
                default: {
                    throw this.error(JGitText.get().s3ActionDeletion, string2, httpURLConnection);
                }
            }
        }
        throw this.maxAttempts(JGitText.get().s3ActionDeletion, string2);
    }

    public void put(String string, String string2, byte[] byArray) {
        if (this.encryption != WalkEncryption.NONE) {
            try (OutputStream outputStream = this.beginPut(string, string2, null, null);){
                outputStream.write(byArray);
            }
            return;
        }
        String string3 = Base64.encodeBytes(AmazonS3.newMD5().digest(byArray));
        String string4 = this.awsApiSignatureVersion.equals(AWS_API_V4) ? AwsRequestSignerV4.calculateBodyHash(byArray) : null;
        String string5 = String.valueOf(byArray.length);
        block22: for (int i2 = 0; i2 < this.maxAttempts; ++i2) {
            HttpURLConnection httpURLConnection = this.open("PUT", string, string2);
            httpURLConnection.setRequestProperty("Content-Length", string5);
            httpURLConnection.setRequestProperty("Content-MD5", string3);
            httpURLConnection.setRequestProperty(X_AMZ_ACL, this.acl);
            this.authorize(httpURLConnection, Collections.emptyMap(), byArray.length, string4);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setFixedLengthStreamingMode(byArray.length);
            try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                outputStream.write(byArray);
            }
            switch (HttpSupport.response(httpURLConnection)) {
                case 200: {
                    return;
                }
                case 500: {
                    continue block22;
                }
                default: {
                    throw this.error(JGitText.get().s3ActionWriting, string2, httpURLConnection);
                }
            }
        }
        throw this.maxAttempts(JGitText.get().s3ActionWriting, string2);
    }

    public OutputStream beginPut(String string, String string2, ProgressMonitor progressMonitor, String string3) {
        MessageDigest messageDigest = AmazonS3.newMD5();
        AmazonS3$1 amazonS3$1 = new AmazonS3$1(this, this.tmpDir, string, string2, messageDigest, progressMonitor, string3);
        return this.encryption.encrypt(new DigestOutputStream(amazonS3$1, messageDigest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putImpl(String string, String string2, byte[] byArray, TemporaryBuffer temporaryBuffer, ProgressMonitor progressMonitor, String string3) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (string3 == null) {
            string3 = MessageFormat.format(JGitText.get().progressMonUploading, string2);
        }
        String string4 = Base64.encodeBytes(byArray);
        String string5 = this.awsApiSignatureVersion.equals(AWS_API_V4) ? AwsRequestSignerV4.calculateBodyHash(temporaryBuffer.toByteArray()) : null;
        long l2 = temporaryBuffer.length();
        block16: for (int i2 = 0; i2 < this.maxAttempts; ++i2) {
            HttpURLConnection httpURLConnection = this.open("PUT", string, string2);
            httpURLConnection.setFixedLengthStreamingMode(l2);
            httpURLConnection.setRequestProperty("Content-MD5", string4);
            httpURLConnection.setRequestProperty(X_AMZ_ACL, this.acl);
            this.encryption.request(httpURLConnection, X_AMZ_META);
            this.authorize(httpURLConnection, Collections.emptyMap(), l2, string5);
            httpURLConnection.setDoOutput(true);
            progressMonitor.beginTask(string3, (int)(l2 / 1024L));
            try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                temporaryBuffer.writeTo(outputStream, progressMonitor);
            }
            finally {
                progressMonitor.endTask();
            }
            switch (HttpSupport.response(httpURLConnection)) {
                case 200: {
                    return;
                }
                case 500: {
                    continue block16;
                }
                default: {
                    throw this.error(JGitText.get().s3ActionWriting, string2, httpURLConnection);
                }
            }
        }
        throw this.maxAttempts(JGitText.get().s3ActionWriting, string2);
    }

    IOException error(String string, String string2, HttpURLConnection httpURLConnection) {
        IOException iOException = new IOException(MessageFormat.format(JGitText.get().amazonS3ActionFailed, string, string2, HttpSupport.response(httpURLConnection), httpURLConnection.getResponseMessage()));
        if (httpURLConnection.getErrorStream() == null) {
            return iOException;
        }
        try (InputStream inputStream = httpURLConnection.getErrorStream();){
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[2048];
            while ((n2 = inputStream.read(byArray)) >= 0) {
                if (n2 <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length > 0) {
                iOException.initCause(new IOException("\n" + new String(byArray, StandardCharsets.UTF_8)));
            }
        }
        return iOException;
    }

    IOException maxAttempts(String string, String string2) {
        return new IOException(MessageFormat.format(JGitText.get().amazonS3ActionFailedGivingUp, string, string2, this.maxAttempts));
    }

    private HttpURLConnection open(String string, String string2, String string3) {
        Map map = Collections.emptyMap();
        return this.open(string, string2, string3, map);
    }

    HttpURLConnection open(String string, String string2, String string3, Map map) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("http://");
        stringBuilder.append(string2);
        stringBuilder.append('.');
        stringBuilder.append(this.domain);
        stringBuilder.append('/');
        if (string3.length() > 0) {
            if (this.awsApiSignatureVersion.equals(AWS_API_V2)) {
                HttpSupport.encode(stringBuilder, string3);
            } else if (this.awsApiSignatureVersion.equals(AWS_API_V4)) {
                stringBuilder.append(string3);
            }
        }
        if (!map.isEmpty()) {
            stringBuilder.append('?');
            object2 = map.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                stringBuilder.append((String)object.getKey());
                stringBuilder.append('=');
                HttpSupport.encode(stringBuilder, (String)object.getValue());
                if (!object2.hasNext()) continue;
                stringBuilder.append('&');
            }
        }
        object2 = new URL(stringBuilder.toString());
        object = HttpSupport.proxyFor(this.proxySelector, (URL)object2);
        HttpURLConnection httpURLConnection = (HttpURLConnection)((URL)object2).openConnection((Proxy)object);
        httpURLConnection.setRequestMethod(string);
        httpURLConnection.setRequestProperty("User-Agent", "jgit/1.0");
        httpURLConnection.setRequestProperty("Date", AmazonS3.httpNow());
        return httpURLConnection;
    }

    void authorize(HttpURLConnection httpURLConnection, Map map, long l2, String string) {
        if (this.awsApiSignatureVersion.equals(AWS_API_V2)) {
            this.authorizeV2(httpURLConnection);
        } else if (this.awsApiSignatureVersion.equals(AWS_API_V4)) {
            AwsRequestSignerV4.sign(httpURLConnection, map, l2, string, AWS_S3_SERVICE_NAME, this.region, this.publicKey, this.secretKey);
        }
    }

    void authorizeV2(HttpURLConnection httpURLConnection) {
        String string;
        Map.Entry<String, List<String>> entry22;
        Map<String, List<String>> map = httpURLConnection.getRequestProperties();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, List<String>> entry22 : map.entrySet()) {
            String object2 = entry22.getKey();
            if (!AmazonS3.isSignedHeader(object2)) continue;
            treeMap.put(StringUtils.toLowerCase(object2), AmazonS3.toCleanString(entry22.getValue()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(httpURLConnection.getRequestMethod());
        stringBuilder.append('\n');
        stringBuilder.append(AmazonS3.remove(treeMap, "content-md5"));
        stringBuilder.append('\n');
        stringBuilder.append(AmazonS3.remove(treeMap, "content-type"));
        stringBuilder.append('\n');
        stringBuilder.append(AmazonS3.remove(treeMap, "date"));
        stringBuilder.append('\n');
        for (Map.Entry entry : treeMap.entrySet()) {
            stringBuilder.append((String)entry.getKey());
            stringBuilder.append(':');
            stringBuilder.append((String)entry.getValue());
            stringBuilder.append('\n');
        }
        entry22 = httpURLConnection.getURL().getHost();
        stringBuilder.append('/');
        stringBuilder.append(((String)((Object)entry22)).substring(0, ((String)((Object)entry22)).length() - this.domain.length() - 1));
        stringBuilder.append(httpURLConnection.getURL().getPath());
        try {
            Mac mac = Mac.getInstance(HMAC);
            mac.init(this.secretKeySpec);
            string = Base64.encodeBytes(mac.doFinal(stringBuilder.toString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(MessageFormat.format(JGitText.get().noHMACsupport, HMAC, noSuchAlgorithmException.getMessage()));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException(MessageFormat.format(JGitText.get().invalidKey, invalidKeyException.getMessage()));
        }
        httpURLConnection.setRequestProperty("Authorization", "AWS " + this.publicKey + ":" + string);
    }

    static Properties properties(File file) {
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            properties.load(fileInputStream);
        }
        return properties;
    }

    static {
        SIGNED_HEADERS.add("content-type");
        SIGNED_HEADERS.add("content-md5");
        SIGNED_HEADERS.add("date");
    }
}

