/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.AmazonS3;
import org.eclipse.jgit.transport.AmazonS3$KeyInfo;
import org.eclipse.jgit.util.HttpSupport;
import org.eclipse.jgit.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

final class AmazonS3$ListParser
extends DefaultHandler {
    final List entries = new ArrayList();
    private final String bucket;
    private final String prefix;
    boolean truncated;
    private StringBuilder data;
    private String keyName;
    private Instant keyLastModified;
    final /* synthetic */ AmazonS3 this$0;

    AmazonS3$ListParser(AmazonS3 amazonS3, String string, String string2) {
        this.this$0 = amazonS3;
        this.bucket = string;
        this.prefix = string2;
    }

    void list() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (this.prefix.length() > 0) {
            treeMap.put("prefix", this.prefix);
        }
        if (!this.entries.isEmpty()) {
            treeMap.put("marker", this.prefix + ((AmazonS3$KeyInfo)this.entries.get(this.entries.size() - 1)).getName());
        }
        block17: for (int i2 = 0; i2 < this.this$0.maxAttempts; ++i2) {
            HttpURLConnection httpURLConnection = this.this$0.open("GET", this.bucket, "", treeMap);
            this.this$0.authorize(httpURLConnection, treeMap, 0L, null);
            switch (HttpSupport.response(httpURLConnection)) {
                case 200: {
                    XMLReader xMLReader;
                    this.truncated = false;
                    this.data = null;
                    this.keyName = null;
                    this.keyLastModified = null;
                    try {
                        xMLReader = XMLReaderFactory.createXMLReader();
                    }
                    catch (SAXException sAXException) {
                        throw new IOException(JGitText.get().noXMLParserAvailable, sAXException);
                    }
                    xMLReader.setContentHandler(this);
                    try (InputStream inputStream = httpURLConnection.getInputStream();){
                        xMLReader.parse(new InputSource(inputStream));
                    }
                    catch (SAXException sAXException) {
                        throw new IOException(MessageFormat.format(JGitText.get().errorListing, this.prefix), sAXException);
                    }
                    return;
                }
                case 500: {
                    continue block17;
                }
                default: {
                    throw this.this$0.error("Listing", this.prefix, httpURLConnection);
                }
            }
        }
        throw this.this$0.maxAttempts("Listing", this.prefix);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if ("Key".equals(string2) || "IsTruncated".equals(string2) || "LastModified".equals(string2)) {
            this.data = new StringBuilder();
        }
        if ("Contents".equals(string2)) {
            this.keyName = null;
            this.keyLastModified = null;
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) {
        if (this.data != null) {
            this.data.append(cArray, n2, n3);
        }
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        if (this.data != null) {
            this.data.append(cArray, n2, n3);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if ("Key".equals(string2)) {
            this.keyName = this.data.toString().substring(this.prefix.length());
        } else if ("IsTruncated".equals(string2)) {
            this.truncated = StringUtils.equalsIgnoreCase("true", this.data.toString());
        } else if ("LastModified".equals(string2)) {
            this.keyLastModified = Instant.parse(this.data.toString());
        } else if ("Contents".equals(string2)) {
            this.entries.add(new AmazonS3$KeyInfo(this.keyName, this.keyLastModified.getEpochSecond()));
        }
        this.data = null;
    }
}

