/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.List;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.UploadPack;

public class AdvertiseRefsHookChain
implements AdvertiseRefsHook {
    private final AdvertiseRefsHook[] hooks;
    private final int count;

    public static AdvertiseRefsHook newChain(List list) {
        AdvertiseRefsHook[] advertiseRefsHookArray = new AdvertiseRefsHook[list.size()];
        int n2 = 0;
        for (AdvertiseRefsHook advertiseRefsHook : list) {
            if (advertiseRefsHook == AdvertiseRefsHook.DEFAULT) continue;
            advertiseRefsHookArray[n2++] = advertiseRefsHook;
        }
        switch (n2) {
            case 0: {
                return AdvertiseRefsHook.DEFAULT;
            }
            case 1: {
                return advertiseRefsHookArray[0];
            }
        }
        return new AdvertiseRefsHookChain(advertiseRefsHookArray, n2);
    }

    @Override
    public void advertiseRefs(ReceivePack receivePack) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            this.hooks[i2].advertiseRefs(receivePack);
        }
    }

    @Override
    public void advertiseRefs(UploadPack uploadPack) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            this.hooks[i2].advertiseRefs(uploadPack);
        }
    }

    private AdvertiseRefsHookChain(AdvertiseRefsHook[] advertiseRefsHookArray, int n2) {
        this.hooks = advertiseRefsHookArray;
        this.count = n2;
    }
}

