/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.submodule;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.BlobBasedConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.RepositoryBuilderFactory;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.submodule.SubmoduleWalk$IgnoreSubmoduleMode;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;

public class SubmoduleWalk
implements AutoCloseable {
    private final Repository repository;
    private final TreeWalk walk;
    private StoredConfig repoConfig;
    private AbstractTreeIterator rootTree;
    private Config modulesConfig;
    private String path;
    private Map pathToName;
    private RepositoryBuilderFactory factory;

    public static SubmoduleWalk forIndex(Repository repository) {
        SubmoduleWalk submoduleWalk = new SubmoduleWalk(repository);
        try {
            DirCache dirCache = repository.readDirCache();
            submoduleWalk.setTree(new DirCacheIterator(dirCache));
        }
        catch (IOException iOException) {
            submoduleWalk.close();
            throw iOException;
        }
        return submoduleWalk;
    }

    public static SubmoduleWalk forPath(Repository repository, AnyObjectId anyObjectId, String string) {
        SubmoduleWalk submoduleWalk = new SubmoduleWalk(repository);
        try {
            submoduleWalk.setTree(anyObjectId);
            PathFilter pathFilter = PathFilter.create(string);
            submoduleWalk.setFilter(pathFilter);
            submoduleWalk.setRootTree(anyObjectId);
            while (submoduleWalk.next()) {
                if (!pathFilter.isDone(submoduleWalk.walk)) continue;
                return submoduleWalk;
            }
        }
        catch (IOException iOException) {
            submoduleWalk.close();
            throw iOException;
        }
        submoduleWalk.close();
        return null;
    }

    public static SubmoduleWalk forPath(Repository repository, AbstractTreeIterator abstractTreeIterator, String string) {
        SubmoduleWalk submoduleWalk = new SubmoduleWalk(repository);
        try {
            submoduleWalk.setTree(abstractTreeIterator);
            PathFilter pathFilter = PathFilter.create(string);
            submoduleWalk.setFilter(pathFilter);
            submoduleWalk.setRootTree(abstractTreeIterator);
            while (submoduleWalk.next()) {
                if (!pathFilter.isDone(submoduleWalk.walk)) continue;
                return submoduleWalk;
            }
        }
        catch (IOException iOException) {
            submoduleWalk.close();
            throw iOException;
        }
        submoduleWalk.close();
        return null;
    }

    public static File getSubmoduleDirectory(Repository repository, String string) {
        return new File(repository.getWorkTree(), string);
    }

    public static Repository getSubmoduleRepository(Repository repository, String string) {
        return SubmoduleWalk.getSubmoduleRepository(repository.getWorkTree(), string, repository.getFS());
    }

    public static Repository getSubmoduleRepository(File file, String string) {
        return SubmoduleWalk.getSubmoduleRepository(file, string, FS.DETECTED);
    }

    public static Repository getSubmoduleRepository(File file, String string, FS fS) {
        return SubmoduleWalk.getSubmoduleRepository(file, string, fS, new RepositoryBuilder());
    }

    public static Repository getSubmoduleRepository(File file, String string, FS fS, BaseRepositoryBuilder baseRepositoryBuilder) {
        File file2 = new File(file, string);
        if (!file2.isDirectory()) {
            return null;
        }
        try {
            return baseRepositoryBuilder.setMustExist(true).setFS(fS).setWorkTree(file2).build();
        }
        catch (RepositoryNotFoundException repositoryNotFoundException) {
            return null;
        }
    }

    public static String getSubmoduleRemoteUrl(Repository repository, String string) {
        String string2;
        if (!string.startsWith("./") && !string.startsWith("../")) {
            return string;
        }
        String string3 = null;
        Ref ref = repository.exactRef("HEAD");
        if (ref != null) {
            if (ref.isSymbolic()) {
                ref = ref.getLeaf();
            }
            string3 = repository.getConfig().getString("branch", Repository.shortenRefName(ref.getName()), "remote");
        }
        if (string3 == null) {
            string3 = "origin";
        }
        if ((string2 = repository.getConfig().getString("remote", string3, "url")) == null) {
            string2 = repository.getWorkTree().getAbsolutePath();
            if ('\\' == File.separatorChar) {
                string2 = string2.replace('\\', '/');
            }
        }
        if (string2.charAt(string2.length() - 1) == '/') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n2 = 47;
        String string4 = string;
        while (string4.length() > 0) {
            if (string4.startsWith("./")) {
                string4 = string4.substring(2);
                continue;
            }
            if (!string4.startsWith("../")) break;
            int n3 = string2.lastIndexOf(47);
            if (n3 < 1) {
                n3 = string2.lastIndexOf(58);
                n2 = 58;
            }
            if (n3 < 1) {
                throw new IOException(MessageFormat.format(JGitText.get().submoduleParentRemoteUrlInvalid, string2));
            }
            string2 = string2.substring(0, n3);
            string4 = string4.substring(3);
        }
        return string2 + (char)n2 + string4;
    }

    public SubmoduleWalk(Repository repository) {
        this.repository = repository;
        this.repoConfig = repository.getConfig();
        this.walk = new TreeWalk(repository);
        this.walk.setRecursive(true);
    }

    public SubmoduleWalk setModulesConfig(Config config) {
        this.modulesConfig = config;
        this.loadPathNames();
        return this;
    }

    public SubmoduleWalk setRootTree(AbstractTreeIterator abstractTreeIterator) {
        this.rootTree = abstractTreeIterator;
        this.modulesConfig = null;
        this.pathToName = null;
        return this;
    }

    public SubmoduleWalk setRootTree(AnyObjectId anyObjectId) {
        CanonicalTreeParser canonicalTreeParser = new CanonicalTreeParser();
        canonicalTreeParser.reset(this.walk.getObjectReader(), anyObjectId);
        this.rootTree = canonicalTreeParser;
        this.modulesConfig = null;
        this.pathToName = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubmoduleWalk loadModulesConfig() {
        if (this.rootTree == null) {
            File file = new File(this.repository.getWorkTree(), ".gitmodules");
            FileBasedConfig fileBasedConfig = new FileBasedConfig(file, this.repository.getFS());
            fileBasedConfig.load();
            this.modulesConfig = fileBasedConfig;
            this.loadPathNames();
        } else {
            try (TreeWalk treeWalk = new TreeWalk(this.repository);){
                treeWalk.addTree(this.rootTree);
                int n2 = 0;
                while (!this.rootTree.first()) {
                    this.rootTree.back(1);
                    ++n2;
                }
                try {
                    treeWalk.setRecursive(false);
                    PathFilter pathFilter = PathFilter.create(".gitmodules");
                    treeWalk.setFilter(pathFilter);
                    while (treeWalk.next()) {
                        if (!pathFilter.isDone(treeWalk)) continue;
                        this.modulesConfig = new BlobBasedConfig(null, this.repository, treeWalk.getObjectId(0));
                        this.loadPathNames();
                        SubmoduleWalk submoduleWalk = this;
                        return submoduleWalk;
                    }
                    this.modulesConfig = new Config();
                    this.pathToName = null;
                }
                finally {
                    if (n2 > 0) {
                        this.rootTree.next(n2);
                    }
                }
            }
        }
        return this;
    }

    private void loadPathNames() {
        this.pathToName = null;
        if (this.modulesConfig != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : this.modulesConfig.getSubsections("submodule")) {
                hashMap.put(this.modulesConfig.getString("submodule", string, "path"), string);
            }
            this.pathToName = hashMap;
        }
    }

    public static boolean containsGitModulesFile(Repository repository) {
        if (repository.isBare()) {
            return false;
        }
        File file = new File(repository.getWorkTree(), ".gitmodules");
        return file.exists();
    }

    private void lazyLoadModulesConfig() {
        if (this.modulesConfig == null) {
            this.loadModulesConfig();
        }
    }

    private String getModuleName(String string) {
        String string2 = this.pathToName != null ? (String)this.pathToName.get(string) : null;
        return string2 != null ? string2 : string;
    }

    public SubmoduleWalk setFilter(TreeFilter treeFilter) {
        this.walk.setFilter(treeFilter);
        return this;
    }

    public SubmoduleWalk setTree(AbstractTreeIterator abstractTreeIterator) {
        this.walk.addTree(abstractTreeIterator);
        return this;
    }

    public SubmoduleWalk setTree(AnyObjectId anyObjectId) {
        this.walk.addTree(anyObjectId);
        return this;
    }

    public SubmoduleWalk reset() {
        this.repoConfig = this.repository.getConfig();
        this.modulesConfig = null;
        this.pathToName = null;
        this.walk.reset();
        return this;
    }

    public File getDirectory() {
        return SubmoduleWalk.getSubmoduleDirectory(this.repository, this.path);
    }

    public boolean next() {
        while (this.walk.next()) {
            if (FileMode.GITLINK != this.walk.getFileMode(0)) continue;
            this.path = this.walk.getPathString();
            return true;
        }
        this.path = null;
        return false;
    }

    public String getPath() {
        return this.path;
    }

    public void setBuilderFactory(RepositoryBuilderFactory repositoryBuilderFactory) {
        this.factory = repositoryBuilderFactory;
    }

    private BaseRepositoryBuilder getBuilder() {
        return this.factory != null ? (BaseRepositoryBuilder)this.factory.get() : new RepositoryBuilder();
    }

    public String getModuleName() {
        this.lazyLoadModulesConfig();
        return this.getModuleName(this.path);
    }

    public ObjectId getObjectId() {
        return this.walk.getObjectId(0);
    }

    public String getModulesPath() {
        this.lazyLoadModulesConfig();
        return this.modulesConfig.getString("submodule", this.getModuleName(), "path");
    }

    public String getConfigUrl() {
        return this.repoConfig.getString("submodule", this.getModuleName(), "url");
    }

    public String getModulesUrl() {
        this.lazyLoadModulesConfig();
        return this.modulesConfig.getString("submodule", this.getModuleName(), "url");
    }

    public String getConfigUpdate() {
        return this.repoConfig.getString("submodule", this.getModuleName(), "update");
    }

    public String getModulesUpdate() {
        this.lazyLoadModulesConfig();
        return this.modulesConfig.getString("submodule", this.getModuleName(), "update");
    }

    public SubmoduleWalk$IgnoreSubmoduleMode getModulesIgnore() {
        SubmoduleWalk$IgnoreSubmoduleMode submoduleWalk$IgnoreSubmoduleMode = (SubmoduleWalk$IgnoreSubmoduleMode)this.repoConfig.getEnum(SubmoduleWalk$IgnoreSubmoduleMode.values(), "submodule", this.getModuleName(), "ignore", null);
        if (submoduleWalk$IgnoreSubmoduleMode != null) {
            return submoduleWalk$IgnoreSubmoduleMode;
        }
        this.lazyLoadModulesConfig();
        return (SubmoduleWalk$IgnoreSubmoduleMode)this.modulesConfig.getEnum(SubmoduleWalk$IgnoreSubmoduleMode.values(), "submodule", this.getModuleName(), "ignore", SubmoduleWalk$IgnoreSubmoduleMode.NONE);
    }

    public Repository getRepository() {
        return SubmoduleWalk.getSubmoduleRepository(this.repository.getWorkTree(), this.path, this.repository.getFS(), this.getBuilder());
    }

    public ObjectId getHead() {
        try (Repository repository = this.getRepository();){
            if (repository == null) {
                ObjectId objectId = null;
                return objectId;
            }
            ObjectId objectId = repository.resolve("HEAD");
            return objectId;
        }
    }

    public String getHeadRef() {
        try (Repository repository = this.getRepository();){
            if (repository == null) {
                String string = null;
                return string;
            }
            Ref ref = repository.exactRef("HEAD");
            String string = ref != null ? ref.getLeaf().getName() : null;
            return string;
        }
    }

    public String getRemoteUrl() {
        String string = this.getModulesUrl();
        return string != null ? SubmoduleWalk.getSubmoduleRemoteUrl(this.repository, string) : null;
    }

    @Override
    public void close() {
        this.walk.close();
    }
}

