/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.pack;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.storage.pack.PackStatistics$Accumulator;
import org.eclipse.jgit.storage.pack.PackStatistics$ObjectType;

public class PackStatistics {
    private PackStatistics$Accumulator statistics;

    public PackStatistics(PackStatistics$Accumulator packStatistics$Accumulator) {
        this.statistics = packStatistics$Accumulator;
    }

    public long getAdvertised() {
        return this.statistics.advertised;
    }

    public long getWants() {
        return this.statistics.wants;
    }

    public long getHaves() {
        return this.statistics.haves;
    }

    public long getNotAdvertisedWants() {
        return this.statistics.notAdvertisedWants;
    }

    public long getTimeNegotiating() {
        return this.statistics.timeNegotiating;
    }

    public Set getInterestingObjects() {
        return this.statistics.interestingObjects;
    }

    public Set getUninterestingObjects() {
        return this.statistics.uninterestingObjects;
    }

    public Set getClientShallowCommits() {
        return this.statistics.clientShallowCommits;
    }

    public List getReusedPacks() {
        return this.statistics.reusedPacks;
    }

    public Set getRootCommits() {
        return this.statistics.rootCommits;
    }

    public int getDeltaSearchNonEdgeObjects() {
        return this.statistics.deltaSearchNonEdgeObjects;
    }

    public int getDeltasFound() {
        return this.statistics.deltasFound;
    }

    public long getTotalObjects() {
        return this.statistics.totalObjects;
    }

    public long getBitmapIndexMisses() {
        return this.statistics.bitmapIndexMisses;
    }

    public long getTotalDeltas() {
        return this.statistics.totalDeltas;
    }

    public long getReusedObjects() {
        return this.statistics.reusedObjects;
    }

    public long getReusedDeltas() {
        return this.statistics.reusedDeltas;
    }

    public long getTotalBytes() {
        return this.statistics.totalBytes;
    }

    public long getThinPackBytes() {
        return this.statistics.thinPackBytes;
    }

    public PackStatistics$ObjectType byObjectType(int n2) {
        return new PackStatistics$ObjectType(this.statistics.objectTypes[n2]);
    }

    public boolean isShallow() {
        return this.statistics.depth > 0;
    }

    public int getDepth() {
        return this.statistics.depth;
    }

    public long getTimeCounting() {
        return this.statistics.timeCounting;
    }

    public long getTimeSearchingForReuse() {
        return this.statistics.timeSearchingForReuse;
    }

    public long getTimeSearchingForSizes() {
        return this.statistics.timeSearchingForSizes;
    }

    public long getTimeCompressing() {
        return this.statistics.timeCompressing;
    }

    public long getTimeWriting() {
        return this.statistics.timeWriting;
    }

    public long getReachabilityCheckDuration() {
        return this.statistics.reachabilityCheckDuration;
    }

    public long getTreesTraversed() {
        return this.statistics.treesTraversed;
    }

    public long getOffloadedPackfiles() {
        return this.statistics.offloadedPackfiles;
    }

    public long getOffloadedPackfilesSize() {
        return this.statistics.offloadedPackfileSize;
    }

    public long getTimeTotal() {
        return this.statistics.timeCounting + this.statistics.timeSearchingForReuse + this.statistics.timeSearchingForSizes + this.statistics.timeCompressing + this.statistics.timeWriting;
    }

    public double getTransferRate() {
        return (double)this.getTotalBytes() / ((double)this.getTimeWriting() / 1000.0);
    }

    public String getMessage() {
        return MessageFormat.format(JGitText.get().packWriterStatistics, this.statistics.totalObjects, this.statistics.totalDeltas, this.statistics.reusedObjects, this.statistics.reusedDeltas);
    }

    public Map getObjectTypes() {
        HashMap<Integer, PackStatistics$ObjectType> hashMap = new HashMap<Integer, PackStatistics$ObjectType>();
        hashMap.put(3, new PackStatistics$ObjectType(this.statistics.objectTypes[3]));
        hashMap.put(1, new PackStatistics$ObjectType(this.statistics.objectTypes[1]));
        hashMap.put(4, new PackStatistics$ObjectType(this.statistics.objectTypes[4]));
        hashMap.put(2, new PackStatistics$ObjectType(this.statistics.objectTypes[2]));
        return hashMap;
    }
}

