/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.pack;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;

public class PackConfig {
    public static final boolean DEFAULT_REUSE_DELTAS = true;
    public static final boolean DEFAULT_REUSE_OBJECTS = true;
    public static final boolean DEFAULT_PRESERVE_OLD_PACKS = false;
    public static final boolean DEFAULT_PRUNE_PRESERVED = false;
    public static final boolean DEFAULT_DELTA_COMPRESS = true;
    public static final boolean DEFAULT_DELTA_BASE_AS_OFFSET = false;
    public static final int DEFAULT_MAX_DELTA_DEPTH = 50;
    public static final int DEFAULT_DELTA_SEARCH_WINDOW_SIZE = 10;
    private static final int MB = 0x100000;
    public static final int DEFAULT_BIG_FILE_THRESHOLD = 0x3200000;
    public static final boolean DEFAULT_WAIT_PREVENT_RACY_PACK = false;
    public static final long DEFAULT_MINSIZE_PREVENT_RACY_PACK = 0x6400000L;
    public static final long DEFAULT_DELTA_CACHE_SIZE = 0x3200000L;
    public static final int DEFAULT_DELTA_CACHE_LIMIT = 100;
    public static final int DEFAULT_INDEX_VERSION = 2;
    public static final boolean DEFAULT_BUILD_BITMAPS = true;
    public static final boolean DEFAULT_PACK_KEPT_OBJECTS = false;
    public static final int DEFAULT_BITMAP_CONTIGUOUS_COMMIT_COUNT = 100;
    public static final int DEFAULT_BITMAP_RECENT_COMMIT_COUNT = 20000;
    public static final int DEFAULT_BITMAP_RECENT_COMMIT_SPAN = 100;
    public static final int DEFAULT_BITMAP_DISTANT_COMMIT_SPAN = 5000;
    public static final int DEFAULT_BITMAP_EXCESSIVE_BRANCH_COUNT = 100;
    public static final int DEFAULT_BITMAP_INACTIVE_BRANCH_AGE_IN_DAYS = 90;
    public static final String[] DEFAULT_BITMAP_EXCLUDED_REFS_PREFIXES = new String[0];
    public static final Duration DEFAULT_SEARCH_FOR_REUSE_TIMEOUT = Duration.ofSeconds(Integer.MAX_VALUE);
    private int compressionLevel = -1;
    private boolean reuseDeltas = true;
    private boolean reuseObjects = true;
    private boolean preserveOldPacks = false;
    private boolean prunePreserved = false;
    private boolean deltaBaseAsOffset = false;
    private boolean deltaCompress = true;
    private int maxDeltaDepth = 50;
    private int deltaSearchWindowSize = 10;
    private long deltaSearchMemoryLimit;
    private long deltaCacheSize = 0x3200000L;
    private int deltaCacheLimit = 100;
    private int bigFileThreshold = 0x3200000;
    private boolean waitPreventRacyPack = false;
    private long minSizePreventRacyPack = 0x6400000L;
    private int threads;
    private Executor executor;
    private int indexVersion = 2;
    private boolean buildBitmaps = true;
    private boolean packKeptObjects = false;
    private int bitmapContiguousCommitCount = 100;
    private int bitmapRecentCommitCount = 20000;
    private int bitmapRecentCommitSpan = 100;
    private int bitmapDistantCommitSpan = 5000;
    private int bitmapExcessiveBranchCount = 100;
    private int bitmapInactiveBranchAgeInDays = 90;
    private String[] bitmapExcludedRefsPrefixes = DEFAULT_BITMAP_EXCLUDED_REFS_PREFIXES;
    private Duration searchForReuseTimeout = DEFAULT_SEARCH_FOR_REUSE_TIMEOUT;
    private boolean cutDeltaChains;
    private boolean singlePack;

    public PackConfig() {
    }

    public PackConfig(Repository repository) {
        this.fromConfig(repository.getConfig());
    }

    public PackConfig(Config config) {
        this.fromConfig(config);
    }

    public PackConfig(PackConfig packConfig) {
        this.compressionLevel = packConfig.compressionLevel;
        this.reuseDeltas = packConfig.reuseDeltas;
        this.reuseObjects = packConfig.reuseObjects;
        this.preserveOldPacks = packConfig.preserveOldPacks;
        this.prunePreserved = packConfig.prunePreserved;
        this.deltaBaseAsOffset = packConfig.deltaBaseAsOffset;
        this.deltaCompress = packConfig.deltaCompress;
        this.maxDeltaDepth = packConfig.maxDeltaDepth;
        this.deltaSearchWindowSize = packConfig.deltaSearchWindowSize;
        this.deltaSearchMemoryLimit = packConfig.deltaSearchMemoryLimit;
        this.deltaCacheSize = packConfig.deltaCacheSize;
        this.deltaCacheLimit = packConfig.deltaCacheLimit;
        this.bigFileThreshold = packConfig.bigFileThreshold;
        this.waitPreventRacyPack = packConfig.waitPreventRacyPack;
        this.minSizePreventRacyPack = packConfig.minSizePreventRacyPack;
        this.threads = packConfig.threads;
        this.executor = packConfig.executor;
        this.indexVersion = packConfig.indexVersion;
        this.buildBitmaps = packConfig.buildBitmaps;
        this.packKeptObjects = packConfig.packKeptObjects;
        this.bitmapContiguousCommitCount = packConfig.bitmapContiguousCommitCount;
        this.bitmapRecentCommitCount = packConfig.bitmapRecentCommitCount;
        this.bitmapRecentCommitSpan = packConfig.bitmapRecentCommitSpan;
        this.bitmapDistantCommitSpan = packConfig.bitmapDistantCommitSpan;
        this.bitmapExcessiveBranchCount = packConfig.bitmapExcessiveBranchCount;
        this.bitmapInactiveBranchAgeInDays = packConfig.bitmapInactiveBranchAgeInDays;
        this.cutDeltaChains = packConfig.cutDeltaChains;
        this.singlePack = packConfig.singlePack;
        this.searchForReuseTimeout = packConfig.searchForReuseTimeout;
    }

    public boolean isReuseDeltas() {
        return this.reuseDeltas;
    }

    public void setReuseDeltas(boolean bl2) {
        this.reuseDeltas = bl2;
    }

    public boolean isReuseObjects() {
        return this.reuseObjects;
    }

    public void setReuseObjects(boolean bl2) {
        this.reuseObjects = bl2;
    }

    public boolean isPreserveOldPacks() {
        return this.preserveOldPacks;
    }

    public void setPreserveOldPacks(boolean bl2) {
        this.preserveOldPacks = bl2;
    }

    public boolean isPrunePreserved() {
        return this.prunePreserved;
    }

    public void setPrunePreserved(boolean bl2) {
        this.prunePreserved = bl2;
    }

    public boolean isDeltaBaseAsOffset() {
        return this.deltaBaseAsOffset;
    }

    public void setDeltaBaseAsOffset(boolean bl2) {
        this.deltaBaseAsOffset = bl2;
    }

    public boolean isDeltaCompress() {
        return this.deltaCompress;
    }

    public void setDeltaCompress(boolean bl2) {
        this.deltaCompress = bl2;
    }

    public int getMaxDeltaDepth() {
        return this.maxDeltaDepth;
    }

    public void setMaxDeltaDepth(int n2) {
        this.maxDeltaDepth = n2;
    }

    public boolean getCutDeltaChains() {
        return this.cutDeltaChains;
    }

    public void setCutDeltaChains(boolean bl2) {
        this.cutDeltaChains = bl2;
    }

    public boolean getSinglePack() {
        return this.singlePack;
    }

    public void setSinglePack(boolean bl2) {
        this.singlePack = bl2;
    }

    public int getDeltaSearchWindowSize() {
        return this.deltaSearchWindowSize;
    }

    public void setDeltaSearchWindowSize(int n2) {
        if (n2 <= 2) {
            this.setDeltaCompress(false);
        } else {
            this.deltaSearchWindowSize = n2;
        }
    }

    public long getDeltaSearchMemoryLimit() {
        return this.deltaSearchMemoryLimit;
    }

    public void setDeltaSearchMemoryLimit(long l2) {
        this.deltaSearchMemoryLimit = l2;
    }

    public long getDeltaCacheSize() {
        return this.deltaCacheSize;
    }

    public void setDeltaCacheSize(long l2) {
        this.deltaCacheSize = l2;
    }

    public int getDeltaCacheLimit() {
        return this.deltaCacheLimit;
    }

    public void setDeltaCacheLimit(int n2) {
        this.deltaCacheLimit = n2;
    }

    public int getBigFileThreshold() {
        return this.bigFileThreshold;
    }

    public void setBigFileThreshold(int n2) {
        this.bigFileThreshold = n2;
    }

    public boolean isWaitPreventRacyPack() {
        return this.waitPreventRacyPack;
    }

    public boolean doWaitPreventRacyPack(long l2) {
        return this.isWaitPreventRacyPack() && l2 > this.getMinSizePreventRacyPack();
    }

    public void setWaitPreventRacyPack(boolean bl2) {
        this.waitPreventRacyPack = bl2;
    }

    public long getMinSizePreventRacyPack() {
        return this.minSizePreventRacyPack;
    }

    public void setMinSizePreventRacyPack(long l2) {
        this.minSizePreventRacyPack = l2;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int n2) {
        this.compressionLevel = n2;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int n2) {
        this.threads = n2;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public int getIndexVersion() {
        return this.indexVersion;
    }

    public void setIndexVersion(int n2) {
        this.indexVersion = n2;
    }

    public boolean isBuildBitmaps() {
        return this.buildBitmaps;
    }

    public void setBuildBitmaps(boolean bl2) {
        this.buildBitmaps = bl2;
    }

    public void setPackKeptObjects(boolean bl2) {
        this.packKeptObjects = bl2;
    }

    public boolean isPackKeptObjects() {
        return this.packKeptObjects;
    }

    public int getBitmapContiguousCommitCount() {
        return this.bitmapContiguousCommitCount;
    }

    public void setBitmapContiguousCommitCount(int n2) {
        this.bitmapContiguousCommitCount = n2;
    }

    public int getBitmapRecentCommitCount() {
        return this.bitmapRecentCommitCount;
    }

    public void setBitmapRecentCommitCount(int n2) {
        this.bitmapRecentCommitCount = n2;
    }

    public int getBitmapRecentCommitSpan() {
        return this.bitmapRecentCommitSpan;
    }

    public void setBitmapRecentCommitSpan(int n2) {
        this.bitmapRecentCommitSpan = n2;
    }

    public int getBitmapDistantCommitSpan() {
        return this.bitmapDistantCommitSpan;
    }

    public void setBitmapDistantCommitSpan(int n2) {
        this.bitmapDistantCommitSpan = n2;
    }

    public int getBitmapExcessiveBranchCount() {
        return this.bitmapExcessiveBranchCount;
    }

    public void setBitmapExcessiveBranchCount(int n2) {
        this.bitmapExcessiveBranchCount = n2;
    }

    public int getBitmapInactiveBranchAgeInDays() {
        return this.bitmapInactiveBranchAgeInDays;
    }

    public Duration getSearchForReuseTimeout() {
        return this.searchForReuseTimeout;
    }

    public void setBitmapInactiveBranchAgeInDays(int n2) {
        this.bitmapInactiveBranchAgeInDays = n2;
    }

    public String[] getBitmapExcludedRefsPrefixes() {
        return this.bitmapExcludedRefsPrefixes;
    }

    public void setBitmapExcludedRefsPrefixes(String[] stringArray) {
        this.bitmapExcludedRefsPrefixes = stringArray;
    }

    public void setSearchForReuseTimeout(Duration duration) {
        this.searchForReuseTimeout = duration;
    }

    public void fromConfig(Config config) {
        this.setMaxDeltaDepth(config.getInt("pack", "depth", this.getMaxDeltaDepth()));
        this.setDeltaSearchWindowSize(config.getInt("pack", "window", this.getDeltaSearchWindowSize()));
        this.setDeltaSearchMemoryLimit(config.getLong("pack", "windowmemory", this.getDeltaSearchMemoryLimit()));
        this.setDeltaCacheSize(config.getLong("pack", "deltacachesize", this.getDeltaCacheSize()));
        this.setDeltaCacheLimit(config.getInt("pack", "deltacachelimit", this.getDeltaCacheLimit()));
        this.setCompressionLevel(config.getInt("pack", "compression", config.getInt("core", "compression", this.getCompressionLevel())));
        this.setIndexVersion(config.getInt("pack", "indexversion", this.getIndexVersion()));
        this.setBigFileThreshold(config.getInt("core", "bigfilethreshold", this.getBigFileThreshold()));
        this.setThreads(config.getInt("pack", "threads", this.getThreads()));
        this.setReuseDeltas(config.getBoolean("pack", "reusedeltas", this.isReuseDeltas()));
        this.setReuseObjects(config.getBoolean("pack", "reuseobjects", this.isReuseObjects()));
        this.setDeltaCompress(config.getBoolean("pack", "deltacompression", this.isDeltaCompress()));
        this.setCutDeltaChains(config.getBoolean("pack", "cutdeltachains", this.getCutDeltaChains()));
        this.setSinglePack(config.getBoolean("pack", "singlepack", this.getSinglePack()));
        boolean bl2 = config.getBoolean("pack", "buildbitmaps", this.isBuildBitmaps());
        this.setBuildBitmaps(bl2);
        this.setPackKeptObjects(config.getBoolean("repack", "packkeptobjects", bl2 || this.isPackKeptObjects()));
        this.setBitmapContiguousCommitCount(config.getInt("pack", "bitmapcontiguouscommitcount", this.getBitmapContiguousCommitCount()));
        this.setBitmapRecentCommitCount(config.getInt("pack", "bitmaprecentcommitspan", this.getBitmapRecentCommitCount()));
        this.setBitmapRecentCommitSpan(config.getInt("pack", "bitmaprecentcommitspan", this.getBitmapRecentCommitSpan()));
        this.setBitmapDistantCommitSpan(config.getInt("pack", "bitmapdistantcommitspan", this.getBitmapDistantCommitSpan()));
        this.setBitmapExcessiveBranchCount(config.getInt("pack", "bitmapexcessivebranchcount", this.getBitmapExcessiveBranchCount()));
        this.setBitmapInactiveBranchAgeInDays(config.getInt("pack", "bitmapinactivebranchageindays", this.getBitmapInactiveBranchAgeInDays()));
        String[] stringArray = config.getStringList("pack", null, "bitmapexcludedrefsprefixes");
        if (stringArray.length > 0) {
            this.setBitmapExcludedRefsPrefixes(stringArray);
        }
        this.setSearchForReuseTimeout(Duration.ofSeconds(config.getTimeUnit("pack", null, "searchforreusetimeout", this.getSearchForReuseTimeout().getSeconds(), TimeUnit.SECONDS)));
        this.setWaitPreventRacyPack(config.getBoolean("pack", "waitpreventracypack", this.isWaitPreventRacyPack()));
        this.setMinSizePreventRacyPack(config.getLong("pack", "minsizepreventracypack", this.getMinSizePreventRacyPack()));
        this.setPreserveOldPacks(config.getBoolean("pack", "preserveoldpacks", false));
        this.setPrunePreserved(config.getBoolean("pack", "prunepreserved", false));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("maxDeltaDepth=").append(this.getMaxDeltaDepth());
        stringBuilder.append(", deltaSearchWindowSize=").append(this.getDeltaSearchWindowSize());
        stringBuilder.append(", deltaSearchMemoryLimit=").append(this.getDeltaSearchMemoryLimit());
        stringBuilder.append(", deltaCacheSize=").append(this.getDeltaCacheSize());
        stringBuilder.append(", deltaCacheLimit=").append(this.getDeltaCacheLimit());
        stringBuilder.append(", compressionLevel=").append(this.getCompressionLevel());
        stringBuilder.append(", indexVersion=").append(this.getIndexVersion());
        stringBuilder.append(", bigFileThreshold=").append(this.getBigFileThreshold());
        stringBuilder.append(", threads=").append(this.getThreads());
        stringBuilder.append(", reuseDeltas=").append(this.isReuseDeltas());
        stringBuilder.append(", reuseObjects=").append(this.isReuseObjects());
        stringBuilder.append(", deltaCompress=").append(this.isDeltaCompress());
        stringBuilder.append(", buildBitmaps=").append(this.isBuildBitmaps());
        stringBuilder.append(", bitmapContiguousCommitCount=").append(this.getBitmapContiguousCommitCount());
        stringBuilder.append(", bitmapRecentCommitCount=").append(this.getBitmapRecentCommitCount());
        stringBuilder.append(", bitmapRecentCommitSpan=").append(this.getBitmapRecentCommitSpan());
        stringBuilder.append(", bitmapDistantCommitSpan=").append(this.getBitmapDistantCommitSpan());
        stringBuilder.append(", bitmapExcessiveBranchCount=").append(this.getBitmapExcessiveBranchCount());
        stringBuilder.append(", bitmapInactiveBranchAge=").append(this.getBitmapInactiveBranchAgeInDays());
        stringBuilder.append(", searchForReuseTimeout").append(this.getSearchForReuseTimeout());
        stringBuilder.append(", singlePack=").append(this.getSinglePack());
        return stringBuilder.toString();
    }
}

