/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import org.eclipse.jgit.internal.storage.file.WindowCache;
import org.eclipse.jgit.lib.Config;

public class WindowCacheConfig {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    private int packedGitOpenFiles = 128;
    private long packedGitLimit = 0xA00000L;
    private boolean useStrongRefs = false;
    private int packedGitWindowSize = 8192;
    private boolean packedGitMMAP = false;
    private int deltaBaseCacheLimit = 0xA00000;
    private int streamFileThreshold = 0x3200000;
    private boolean exposeStats = true;

    public int getPackedGitOpenFiles() {
        return this.packedGitOpenFiles;
    }

    public void setPackedGitOpenFiles(int n2) {
        this.packedGitOpenFiles = n2;
    }

    public long getPackedGitLimit() {
        return this.packedGitLimit;
    }

    public void setPackedGitLimit(long l2) {
        this.packedGitLimit = l2;
    }

    public boolean isPackedGitUseStrongRefs() {
        return this.useStrongRefs;
    }

    public void setPackedGitUseStrongRefs(boolean bl2) {
        this.useStrongRefs = bl2;
    }

    public int getPackedGitWindowSize() {
        return this.packedGitWindowSize;
    }

    public void setPackedGitWindowSize(int n2) {
        this.packedGitWindowSize = n2;
    }

    public boolean isPackedGitMMAP() {
        return this.packedGitMMAP;
    }

    public void setPackedGitMMAP(boolean bl2) {
        this.packedGitMMAP = bl2;
    }

    public int getDeltaBaseCacheLimit() {
        return this.deltaBaseCacheLimit;
    }

    public void setDeltaBaseCacheLimit(int n2) {
        this.deltaBaseCacheLimit = n2;
    }

    public int getStreamFileThreshold() {
        return this.streamFileThreshold;
    }

    public void setStreamFileThreshold(int n2) {
        this.streamFileThreshold = n2;
    }

    public boolean getExposeStatsViaJmx() {
        return this.exposeStats;
    }

    public void setExposeStatsViaJmx(boolean bl2) {
        this.exposeStats = bl2;
    }

    public WindowCacheConfig fromConfig(Config config) {
        this.setPackedGitUseStrongRefs(config.getBoolean("core", "packedgitusestrongrefs", this.isPackedGitUseStrongRefs()));
        this.setPackedGitOpenFiles(config.getInt("core", null, "packedgitopenfiles", this.getPackedGitOpenFiles()));
        this.setPackedGitLimit(config.getLong("core", null, "packedgitlimit", this.getPackedGitLimit()));
        this.setPackedGitWindowSize(config.getInt("core", null, "packedgitwindowsize", this.getPackedGitWindowSize()));
        this.setPackedGitMMAP(config.getBoolean("core", null, "packedgitmmap", this.isPackedGitMMAP()));
        this.setDeltaBaseCacheLimit(config.getInt("core", null, "deltaBaseCacheLimit", this.getDeltaBaseCacheLimit()));
        long l2 = Runtime.getRuntime().maxMemory();
        long l3 = config.getLong("core", null, "streamFileThreshold", this.getStreamFileThreshold());
        l3 = Math.min(l3, l2 / 4L);
        l3 = Math.min(l3, Integer.MAX_VALUE);
        this.setStreamFileThreshold((int)l3);
        return this;
    }

    public void install() {
        WindowCache.reconfigure(this);
    }
}

