/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedConfig
extends StoredConfig {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedConfig.class);
    private final File configFile;
    private final FS fs;
    private boolean utf8Bom;
    private volatile FileSnapshot snapshot;
    private volatile ObjectId hash;

    public FileBasedConfig(File file, FS fS) {
        this(null, file, fS);
    }

    public FileBasedConfig(Config config, File file, FS fS) {
        super(config);
        this.configFile = file;
        this.fs = fS;
        this.snapshot = FileSnapshot.DIRTY;
        this.hash = ObjectId.zeroId();
    }

    @Override
    protected boolean notifyUponTransientChanges() {
        return false;
    }

    public FS getFs() {
        return this.fs;
    }

    public final File getFile() {
        return this.configFile;
    }

    /*
     * Loose catch block
     */
    @Override
    public void load() {
        int n2 = 5;
        int n3 = 20;
        int n4 = 0;
        while (true) {
            FileSnapshot fileSnapshot = this.snapshot;
            FileSnapshot fileSnapshot2 = FileSnapshot.saveNoConfig(this.getFile(), this.fs);
            try {
                byte[] byArray = IO.readFully(this.getFile());
                ObjectId objectId = FileBasedConfig.hash(byArray);
                if (this.hash.equals(objectId)) {
                    if (fileSnapshot.equals(fileSnapshot2)) {
                        fileSnapshot.setClean(fileSnapshot2);
                    } else {
                        this.snapshot = fileSnapshot2;
                    }
                } else {
                    String string;
                    if (this.isUtf8(byArray)) {
                        string = RawParseUtils.decode(StandardCharsets.UTF_8, byArray, 3, byArray.length);
                        this.utf8Bom = true;
                    } else {
                        string = RawParseUtils.decode(byArray);
                    }
                    this.fromText(string);
                    this.snapshot = fileSnapshot2;
                    this.hash = objectId;
                }
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (n4 < 5 && this.configFile.exists()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(MessageFormat.format(JGitText.get().configHandleMayBeLocked, n4), (Throwable)fileNotFoundException);
                    }
                    try {
                        Thread.sleep(n3);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    ++n4;
                    n3 *= 2;
                    continue;
                }
                if (this.configFile.exists()) {
                    throw fileNotFoundException;
                }
                this.clear();
                this.snapshot = fileSnapshot2;
                return;
            }
            catch (IOException iOException) {
                if (FileUtils.isStaleFileHandle(iOException) && n4 < 5) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(MessageFormat.format(JGitText.get().configHandleIsStale, n4), (Throwable)iOException);
                    }
                    ++n4;
                    continue;
                }
                throw new IOException(MessageFormat.format(JGitText.get().cannotReadFile, this.getFile()), iOException);
            }
            break;
        }
        catch (ConfigInvalidException configInvalidException) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().cannotReadFile, this.getFile()), configInvalidException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        byte[] byArray;
        Object object;
        String string = this.toText();
        if (this.utf8Bom) {
            object = new ByteArrayOutputStream();
            ((ByteArrayOutputStream)object).write(239);
            ((ByteArrayOutputStream)object).write(187);
            ((ByteArrayOutputStream)object).write(191);
            ((OutputStream)object).write(string.getBytes(StandardCharsets.UTF_8));
            byArray = ((ByteArrayOutputStream)object).toByteArray();
        } else {
            byArray = Constants.encode(string);
        }
        object = this.getFile();
        LockFile lockFile = new LockFile((File)object);
        try {
            if (!lockFile.lock()) {
                throw new LockFailedException(this.getFile());
            }
            lockFile.setNeedSnapshotNoConfig(true);
            lockFile.write(byArray);
            if (!lockFile.commit()) {
                throw new IOException(MessageFormat.format(JGitText.get().cannotCommitWriteTo, object));
            }
        }
        finally {
            lockFile.unlock();
        }
        this.snapshot = lockFile.getCommitSnapshot();
        this.hash = FileBasedConfig.hash(byArray);
        this.fireConfigChangedEvent();
    }

    private File resolveSymlinks(File file) {
        if (!file.exists()) {
            return file;
        }
        return file.getAbsoluteFile().toPath().toRealPath(new LinkOption[0]).toFile();
    }

    @Override
    public void clear() {
        this.hash = FileBasedConfig.hash(new byte[0]);
        super.clear();
    }

    private static ObjectId hash(byte[] byArray) {
        return ObjectId.fromRaw(Constants.newMessageDigest().digest(byArray));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getFile().getPath() + "]";
    }

    public boolean isOutdated() {
        return this.snapshot.isModified(this.getFile());
    }

    @Override
    protected byte[] readIncludedConfig(String string) {
        File file = string.startsWith("~/") ? this.fs.resolve(this.fs.userHome(), string.substring(2)) : this.fs.resolve(this.configFile.getParentFile(), string);
        if (!file.exists()) {
            return null;
        }
        try {
            return IO.readFully(file);
        }
        catch (IOException iOException) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().cannotReadFile, string), iOException);
        }
    }
}

