/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.util.RawCharSequence;
import org.eclipse.jgit.util.RawSubStringPattern;

public abstract class SubStringRevFilter
extends RevFilter {
    private final RawSubStringPattern pattern;

    public static boolean safe(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
            }
        }
        return true;
    }

    protected SubStringRevFilter(String string) {
        this.pattern = new RawSubStringPattern(string);
    }

    @Override
    public boolean include(RevWalk revWalk, RevCommit revCommit) {
        return this.pattern.match(this.text(revCommit)) >= 0;
    }

    @Override
    public boolean requiresCommitBody() {
        return true;
    }

    protected abstract RawCharSequence text(RevCommit var1);

    @Override
    public RevFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "(\"" + this.pattern.pattern() + "\")";
    }
}

