/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public class SkipRevFilter
extends RevFilter {
    private final int skip;
    private int count;

    public static RevFilter create(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(JGitText.get().skipMustBeNonNegative);
        }
        return new SkipRevFilter(n2);
    }

    private SkipRevFilter(int n2) {
        this.skip = n2;
    }

    @Override
    public boolean include(RevWalk revWalk, RevCommit revCommit) {
        return this.skip <= this.count++;
    }

    @Override
    public RevFilter clone() {
        return new SkipRevFilter(this.skip);
    }
}

