/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class PatternMatchRevFilter
extends RevFilter {
    private final String patternText;
    private final Matcher compiledPattern;

    protected static final String forceToRaw(String string) {
        byte[] byArray = Constants.encode(string);
        StringBuilder stringBuilder = new StringBuilder(byArray.length);
        for (byte by : byArray) {
            stringBuilder.append((char)(by & 0xFF));
        }
        return stringBuilder.toString();
    }

    protected PatternMatchRevFilter(String string, boolean bl2, boolean bl3, int n2) {
        if (string.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        this.patternText = string;
        if (bl2) {
            if (!string.startsWith("^") && !string.startsWith(".*")) {
                string = ".*" + string;
            }
            if (!string.endsWith("$") && !string.endsWith(".*")) {
                string = string + ".*";
            }
        }
        String string2 = bl3 ? PatternMatchRevFilter.forceToRaw(string) : string;
        this.compiledPattern = Pattern.compile(string2, n2).matcher("");
    }

    public String pattern() {
        return this.patternText;
    }

    @Override
    public boolean include(RevWalk revWalk, RevCommit revCommit) {
        return this.compiledPattern.reset(this.text(revCommit)).matches();
    }

    @Override
    public boolean requiresCommitBody() {
        return true;
    }

    protected abstract CharSequence text(RevCommit var1);

    @Override
    public String toString() {
        return super.toString() + "(\"" + this.patternText + "\")";
    }
}

